/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.www.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class WWWUtils {
    public static boolean isAvailable(URL httpURL) {
        String failMsg = "URL [" + httpURL + "] returned unavailable";
        try {
            HttpURLConnection connection = (HttpURLConnection)httpURL.openConnection();
            connection.setRequestMethod("HEAD");
            connection.setConnectTimeout(3000);
            if (connection instanceof HttpsURLConnection) {
                WWWUtils.disableCertificateVerification((HttpsURLConnection)connection);
            }
            connection.connect();
            connection.getResponseCode();
        }
        catch (SSLException e) {
            Log log = LogFactory.getLog(WWWUtils.class);
            log.warn((Object)(failMsg + " due to: " + e.getLocalizedMessage()), (Throwable)e);
            return false;
        }
        catch (IOException e) {
            Log log = LogFactory.getLog(WWWUtils.class);
            log.debug((Object)(failMsg + " due to: " + e.getLocalizedMessage()), (Throwable)e);
            return false;
        }
        return true;
    }

    public static String getServerHeader(URL httpURL) {
        String ret;
        try {
            HttpURLConnection connection = (HttpURLConnection)httpURL.openConnection();
            connection.setRequestMethod("HEAD");
            connection.setConnectTimeout(3000);
            connection.connect();
            connection.getResponseCode();
            ret = connection.getHeaderField("Server");
        }
        catch (IOException e) {
            ret = null;
        }
        return ret;
    }

    private static void disableCertificateVerification(HttpsURLConnection connection) {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            connection.setSSLSocketFactory(sslContext.getSocketFactory());
            connection.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String s, SSLSession sslSession) {
                    return true;
                }
            });
        }
        catch (NoSuchAlgorithmException e) {
            Log log = LogFactory.getLog(WWWUtils.class);
            log.warn((Object)"Failed to disable certificate validation.", (Throwable)e);
        }
        catch (KeyManagementException e) {
            Log log = LogFactory.getLog(WWWUtils.class);
            log.warn((Object)"Failed to disable certificate validation.", (Throwable)e);
        }
    }
}

