/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache.augeas;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rhq.augeas.node.AugeasNode;
import org.rhq.augeas.node.AugeasNodeLazy;
import org.rhq.augeas.tree.AugeasTree;
import org.rhq.augeas.tree.AugeasTreeException;

public class ApacheAugeasNode
extends AugeasNodeLazy
implements AugeasNode {
    private Map<Integer, List<AugeasNode>> includedNodes;

    public ApacheAugeasNode(String fullPath, AugeasTree tree) {
        super(fullPath, tree);
    }

    public ApacheAugeasNode(AugeasNode parentNode, AugeasTree tree, String fullPath) {
        super(fullPath, tree);
        this.parentNode = parentNode;
    }

    public List<AugeasNode> getChildNodes() {
        List nodes = null;
        nodes = this.ag.match(this.getFullPath() + File.separatorChar + "*");
        if (this.includedNodes != null) {
            ArrayList<Integer> includeNodeIndexes = new ArrayList<Integer>(this.includedNodes.keySet());
            Collections.sort(includeNodeIndexes, Collections.reverseOrder());
            for (Integer idx : includeNodeIndexes) {
                nodes.remove(idx);
                nodes.addAll(idx, (Collection)this.includedNodes.get(idx));
            }
        }
        return nodes;
    }

    public void addIncludeNodes(AugeasNode includeNode, List<AugeasNode> nodes) {
        if (nodes.isEmpty()) {
            return;
        }
        if (this.includedNodes == null) {
            this.includedNodes = new HashMap<Integer, List<AugeasNode>>();
        }
        List childNodes = super.getChildNodes();
        int idx = 0;
        boolean found = false;
        for (AugeasNode child : childNodes) {
            if (child.getLabel().equals(includeNode.getLabel()) && child.getSeq() == includeNode.getSeq()) {
                found = true;
                break;
            }
            ++idx;
        }
        if (found) {
            List<AugeasNode> alreadyIncluded = this.includedNodes.get(idx);
            if (alreadyIncluded == null) {
                this.includedNodes.put(idx, new ArrayList<AugeasNode>(nodes));
            } else {
                alreadyIncluded.addAll(nodes);
            }
        }
    }

    public AugeasNode getParentNode() {
        if (this.parentNode != null) {
            return this.parentNode;
        }
        return super.getParentNode();
    }

    public void addChildNode(AugeasNode node) {
        this.childNodes.add(node);
    }

    public void setPath(String path) throws AugeasTreeException {
        this.path = path;
    }

    public void updateFromParent() {
    }

    public void setParentNode(AugeasNode node) {
        this.parentNode = node;
    }
}

