/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.www.snmp;

import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.plugins.www.snmp.SNMPException;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class SNMPValue {
    private final Log log = LogFactory.getLog(this.getClass());
    private OID oid;
    private Variable var;

    SNMPValue(VariableBinding varBinding) {
        this.oid = varBinding.getOid();
        this.var = varBinding.getVariable();
    }

    private String toHex(int val) {
        return Integer.toHexString(val & 0xFF);
    }

    public String toPhysAddressString() {
        byte[] data = ((OctetString)this.var).getValue();
        if (data.length == 0) {
            return "0:0:0:0:0:0";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.toHex(data[0]));
        for (int i = 1; i < data.length; ++i) {
            buffer.append(':').append(this.toHex(data[i]));
        }
        return buffer.toString();
    }

    public String getOID() {
        return this.oid.toString();
    }

    public Type getType() {
        switch (this.var.getSyntax()) {
            case 2: 
            case 65: 
            case 66: 
            case 67: 
            case 70: {
                return Type.LONG;
            }
        }
        return Type.STRING;
    }

    public long toLong() throws SNMPException {
        if (this.var.getSyntax() == 4) {
            return this.convertDateTimeOctetStringToLong();
        }
        try {
            return this.var.toLong();
        }
        catch (UnsupportedOperationException e) {
            String msg = "Cannot convert " + this.var.getSyntaxString() + " to long";
            throw new SNMPException(msg);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof SNMPValue) {
            Variable var = ((SNMPValue)obj).var;
            return var != null && var.equals((Object)this.var);
        }
        return false;
    }

    public int hashCode() {
        return this.var != null ? this.var.hashCode() : 0;
    }

    public String toString() {
        return this.var.toString();
    }

    private long convertDateTimeOctetStringToLong() throws SNMPException {
        byte[] bytes = ((OctetString)this.var).getValue();
        if (bytes.length != 8) {
            throw new SNMPException("OctetString is not in DateAndTime syntax.");
        }
        Calendar cal = Calendar.getInstance();
        int ix = 0;
        int year = bytes[ix] > 0 ? bytes[ix] : 256 + bytes[ix];
        year <<= 8;
        year += bytes[++ix] > 0 ? bytes[ix] : 256 + bytes[ix];
        int n = ++ix;
        byte month = bytes[n];
        int n2 = ++ix;
        byte day = bytes[n2];
        int n3 = ++ix;
        byte hour = bytes[n3];
        int n4 = ++ix;
        byte minutes = bytes[n4];
        int n5 = ++ix;
        byte seconds = bytes[n5];
        int n6 = ++ix;
        ++ix;
        byte deciseconds = bytes[n6];
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, day);
        cal.set(11, hour);
        cal.set(12, minutes);
        cal.set(13, seconds);
        cal.set(14, 100 * deciseconds);
        cal.set(15, 0);
        cal.set(16, 0);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("converted to DateAndTime: millis=" + cal.getTimeInMillis() + ", date=" + cal.getTime()));
        }
        return cal.getTimeInMillis();
    }

    public static enum Type {
        LONG,
        STRING,
        LONG_CONVERTABLE;

    }
}

