/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ApacheDirective
implements Cloneable {
    private String name;
    private List<String> values = new ArrayList<String>();
    private boolean isNested;
    private boolean isRootNode;
    private boolean isComment;
    private static final String WS = "[ \t]*";
    private static final String WORD = "\"(?:[^\"\n]|\\\")*\"|'(?:[^'\n]|\\')*'|[^'\" \t\n]+";
    private static final String DIRECTIVE_REGEX = "[ \t]*(\"(?:[^\"\n]|\\\")*\"|'(?:[^'\n]|\\')*'|[^'\" \t\n]+)[ \t]*";
    private static final String COMMENT_REGEX = "^[\t ]*#.*+$";
    private boolean updated = false;
    private static final Pattern DIRECTIVE_PATTERN = Pattern.compile("[ \t]*(\"(?:[^\"\n]|\\\")*\"|'(?:[^'\n]|\\')*'|[^'\" \t\n]+)[ \t]*");
    private static final Pattern COMMENT_PATTERN = Pattern.compile("^[\t ]*#.*+$");
    private List<ApacheDirective> childNodes = new ArrayList<ApacheDirective>();
    private ApacheDirective parentNode;
    private String file;

    public ApacheDirective() {
    }

    public ApacheDirective(String directive) {
        Matcher matcher = COMMENT_PATTERN.matcher(directive);
        if (matcher.matches()) {
            this.isComment = true;
            this.values.add(directive);
            this.name = "#";
        } else {
            int startIndex = 0;
            boolean updated = true;
            while (updated && startIndex < directive.length()) {
                updated = false;
                Matcher m = DIRECTIVE_PATTERN.matcher(directive);
                while (m.find(startIndex)) {
                    for (int i = 1; i <= m.groupCount(); ++i) {
                        String val = m.group(i);
                        this.values.add(val);
                    }
                    updated = true;
                    startIndex = m.end();
                }
            }
            if (this.values.isEmpty()) {
                throw new RuntimeException("Directive " + directive + "is not in valid format.");
            }
            String lastVal = this.values.get(this.values.size() - 1);
            if (lastVal.endsWith(">")) {
                lastVal = lastVal.substring(0, lastVal.length() - 1);
                this.values.set(this.values.size() - 1, lastVal);
            }
            this.name = this.values.get(0);
            this.values.remove(0);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public boolean isNested() {
        return this.isNested;
    }

    public void setNested(boolean isNested) {
        this.isNested = isNested;
    }

    public String getValuesAsString() {
        StringBuilder buf = new StringBuilder();
        for (String val : this.values) {
            buf.append(val);
        }
        return buf.toString();
    }

    public void addChildDirective(ApacheDirective directive) {
        this.childNodes.add(directive);
    }

    public List<ApacheDirective> getChildDirectives() {
        return this.childNodes;
    }

    public List<ApacheDirective> getChildByName(String name) {
        ArrayList<ApacheDirective> kids = new ArrayList<ApacheDirective>();
        for (ApacheDirective dir : this.childNodes) {
            if (!dir.getName().equals(name)) continue;
            kids.add(dir);
        }
        return kids;
    }

    public ApacheDirective getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(ApacheDirective parent) {
        this.parentNode = parent;
    }

    public boolean isRootNode() {
        return this.isRootNode;
    }

    public void setRootNode(boolean isRootNode) {
        this.isRootNode = isRootNode;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public void setUpdated(boolean updated) {
        this.updated = updated;
    }

    public String getFile() {
        if (this.isRootNode) {
            return null;
        }
        if (this.file == null) {
            List<ApacheDirective> dir = this.parentNode.getChildByName(this.name);
            for (int i = 0; i < dir.size(); ++i) {
                if (dir.get(i) != this) continue;
                this.file = dir.get(i - 1).getFile();
                break;
            }
        }
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void removeChilDirective(ApacheDirective dir) {
        if (this.childNodes.contains(dir)) {
            this.childNodes.remove(dir);
        }
    }

    public void remove() {
        this.parentNode.removeChilDirective(this);
    }

    public String getText() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name + " ");
        for (String temp : this.values) {
            builder.append(temp + " ");
        }
        builder.deleteCharAt(builder.length() - 1);
        if (this.isNested) {
            builder.append(">");
        }
        return builder.toString();
    }

    public int getSeq() {
        List<ApacheDirective> directives = this.parentNode.getChildByName(this.name);
        for (int i = 0; i < directives.size(); ++i) {
            if (directives.get(i) != this) continue;
            return i;
        }
        return 0;
    }

    public void addValue(String val) {
        this.values.add(val);
    }

    public ApacheDirective clone() {
        try {
            ApacheDirective copy = (ApacheDirective)super.clone();
            ArrayList<ApacheDirective> newChildNodes = new ArrayList<ApacheDirective>(this.childNodes.size());
            for (ApacheDirective child : this.childNodes) {
                ApacheDirective childCopy = child.clone();
                childCopy.parentNode = copy;
                newChildNodes.add(childCopy);
            }
            copy.childNodes = newChildNodes;
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("ApacheDirective not cloneable even though it is declared as such.", e);
        }
    }
}

