/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.augeas.AugeasComponent;
import org.rhq.augeas.node.AugeasNode;
import org.rhq.augeas.tree.AugeasTree;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.measurement.calltime.CallTimeData;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.util.ResponseTimeConfiguration;
import org.rhq.core.pluginapi.util.ResponseTimeLogParser;
import org.rhq.plugins.apache.ApacheServerComponent;
import org.rhq.plugins.apache.mapping.ApacheAugeasMapping;
import org.rhq.plugins.apache.parser.ApacheDirective;
import org.rhq.plugins.apache.parser.ApacheDirectiveTree;
import org.rhq.plugins.apache.util.AugeasNodeSearch;
import org.rhq.plugins.apache.util.AugeasNodeValueUtil;
import org.rhq.plugins.apache.util.ConfigurationTimestamp;
import org.rhq.plugins.apache.util.PluginUtility;
import org.rhq.plugins.apache.util.RuntimeApacheConfiguration;
import org.rhq.plugins.www.snmp.SNMPException;
import org.rhq.plugins.www.snmp.SNMPSession;
import org.rhq.plugins.www.snmp.SNMPValue;
import org.rhq.plugins.www.util.WWWUtils;

public class ApacheVirtualHostServiceComponent
implements ResourceComponent<ApacheServerComponent>,
MeasurementFacet,
ConfigurationFacet,
DeleteResourceFacet,
CreateChildResourceFacet {
    private static final Log log = LogFactory.getLog(ApacheVirtualHostServiceComponent.class);
    public static final String URL_CONFIG_PROP = "url";
    public static final String MAIN_SERVER_RESOURCE_KEY = "MainServer";
    public static final String RESPONSE_TIME_LOG_FILE_CONFIG_PROP = "responseTimeLogFile";
    public static final String RESPONSE_TIME_URL_EXCLUDES_CONFIG_PROP = "responseTimeUrlExcludes";
    public static final String RESPONSE_TIME_URL_TRANSFORMS_CONFIG_PROP = "responseTimeUrlTransforms";
    public static final String SERVER_NAME_CONFIG_PROP = "ServerName";
    private static final String RESPONSE_TIME_METRIC = "ResponseTime";
    private static final double RESPONSE_TIME_LOG_TIME_MULTIPLIER = 0.001;
    private ResourceContext<ApacheServerComponent> resourceContext;
    private URL url;
    private ResponseTimeLogParser logParser;
    private ConfigurationTimestamp lastConfigurationTimeStamp = new ConfigurationTimestamp();
    private int snmpWwwServiceIndex = -1;
    public static final String RESOURCE_TYPE_NAME = "Apache Virtual Host";

    public void start(ResourceContext<ApacheServerComponent> resourceContext) throws Exception {
        ResponseTimeConfiguration responseTimeConfig;
        File logFile;
        this.resourceContext = resourceContext;
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        String url = pluginConfig.getSimple(URL_CONFIG_PROP).getStringValue();
        if (url != null) {
            try {
                this.url = new URL(url);
                if (this.url.getPort() == 0) {
                    throw new InvalidPluginConfigurationException("The 'url' connection property is invalid - 0 is not a valid port; please change the value to the port this virtual host is listening on. NOTE: If the 'url' property was set this way after autodiscovery, you most likely did not include the port in the ServerName directive for this virtual host in httpd.conf.");
                }
            }
            catch (MalformedURLException e) {
                throw new Exception("Value of 'url' connection property ('" + url + "') is not a valid URL.");
            }
        }
        if ((logFile = (responseTimeConfig = new ResponseTimeConfiguration(pluginConfig)).getLogFile()) != null) {
            this.logParser = new ResponseTimeLogParser(logFile, 0.001);
            this.logParser.setExcludes(responseTimeConfig.getExcludes());
            this.logParser.setTransforms(responseTimeConfig.getTransforms());
        }
    }

    public void stop() {
        this.resourceContext = null;
        this.url = null;
    }

    public AvailabilityType getAvailability() {
        if (this.url != null) {
            int timeout = PluginUtility.getAvailabilityFacetTimeout();
            return WWWUtils.isAvailable(this.url, timeout) ? AvailabilityType.UP : AvailabilityType.DOWN;
        }
        try {
            if (this.getWwwServiceIndex() < 1) {
                return AvailabilityType.DOWN;
            }
            SNMPSession snmpSession = ((ApacheServerComponent)this.resourceContext.getParentResourceComponent()).getSNMPSession();
            return snmpSession.ping() ? AvailabilityType.UP : AvailabilityType.DOWN;
        }
        catch (Exception e) {
            log.debug((Object)("Determining the availability of the vhost [" + this.resourceContext.getResourceKey() + "] using SNMP failed."), (Throwable)e);
            return AvailabilityType.DOWN;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration loadResourceConfiguration() throws Exception {
        if (!this.isAugeasEnabled()) {
            throw new IllegalStateException("Configuration and child resource creation/deletion support for Apache is optional. If you switched it on by enabling Augeas support in the connection settings of the Apache server resource and still get this message, it means that either your Apache version is not supported (only Apache 2.x is supported) or Augeas is not available on your platform.");
        }
        ApacheServerComponent parent = (ApacheServerComponent)this.resourceContext.getParentResourceComponent();
        AugeasComponent comp = this.getAugeas();
        try {
            AugeasTree tree = comp.getAugeasTree("Httpd");
            ConfigurationDefinition resourceConfigDef = this.resourceContext.getResourceType().getResourceConfigurationDefinition();
            ApacheAugeasMapping mapping = new ApacheAugeasMapping(tree);
            Configuration configuration = mapping.updateConfiguration(this.getNode(tree), resourceConfigDef);
            return configuration;
        }
        finally {
            comp.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        if (!this.isAugeasEnabled()) {
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
            report.setErrorMessage("Configuration and child resource creation/deletion support for Apache is optional. If you switched it on by enabling Augeas support in the connection settings of the Apache server resource and still get this message, it means that either your Apache version is not supported (only Apache 2.x is supported) or Augeas is not available on your platform.");
            return;
        }
        AugeasComponent comp = this.getAugeas();
        AugeasTree tree = null;
        try {
            tree = comp.getAugeasTree("Httpd");
            ConfigurationDefinition resourceConfigDef = this.resourceContext.getResourceType().getResourceConfigurationDefinition();
            ApacheAugeasMapping mapping = new ApacheAugeasMapping(tree);
            AugeasNode virtHostNode = this.getNode(tree);
            mapping.updateAugeas(virtHostNode, report.getConfiguration(), resourceConfigDef);
            tree.save();
            report.setStatus(ConfigurationUpdateStatus.SUCCESS);
            log.info((Object)"Apache configuration was updated");
            this.finishConfigurationUpdate(report);
        }
        catch (Exception e) {
            if (tree != null) {
                String message = "Augeas failed to save configuration " + tree.summarizeAugeasError();
                report.setErrorMessage(message);
                log.error((Object)message);
            } else {
                report.setErrorMessageFromThrowable((Throwable)e);
                log.error((Object)"Augeas failed to save configuration", (Throwable)e);
            }
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
        }
        finally {
            comp.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteResource() throws Exception {
        if (!this.isAugeasEnabled()) {
            throw new IllegalStateException("Configuration and child resource creation/deletion support for Apache is optional. If you switched it on by enabling Augeas support in the connection settings of the Apache server resource and still get this message, it means that either your Apache version is not supported (only Apache 2.x is supported) or Augeas is not available on your platform.");
        }
        ApacheServerComponent parent = (ApacheServerComponent)this.resourceContext.getParentResourceComponent();
        if (MAIN_SERVER_RESOURCE_KEY.equals(this.resourceContext.getResourceKey())) {
            throw new IllegalArgumentException("Cannot delete the virtual host representing the main server configuration.");
        }
        AugeasComponent comp = this.getAugeas();
        try {
            AugeasTree tree = comp.getAugeasTree("Httpd");
            AugeasNode myNode = this.getNode(tree);
            tree.removeNode(myNode, true);
            tree.save();
            this.deleteEmptyFile(tree, myNode);
            this.conditionalRestart();
        }
        catch (IllegalStateException illegalStateException) {
        }
        finally {
            comp.close();
        }
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> schedules) throws Exception {
        int primaryIndex = this.getWwwServiceIndex();
        if (primaryIndex < 0) {
            return;
        }
        log.debug((Object)("Collecting metrics for VirtualHost service #" + primaryIndex + "..."));
        SNMPSession snmpSession = ((ApacheServerComponent)this.resourceContext.getParentResourceComponent()).getSNMPSession();
        if (!snmpSession.ping()) {
            log.debug((Object)("Failed to connect to SNMP agent at " + snmpSession + " - aborting metric collection..."));
            return;
        }
        for (MeasurementScheduleRequest schedule : schedules) {
            String metricName = schedule.getName();
            if (metricName.equals(RESPONSE_TIME_METRIC)) {
                if (this.logParser != null) {
                    try {
                        CallTimeData callTimeData = new CallTimeData(schedule);
                        this.logParser.parseLog(callTimeData);
                        report.addData(callTimeData);
                    }
                    catch (Exception e) {
                        log.error((Object)"Failed to retrieve HTTP call-time data.", (Throwable)e);
                    }
                    continue;
                }
                log.error((Object)("The 'ResponseTime' metric is enabled for resource '" + this.resourceContext.getResourceKey() + "', but no value is defined for the '" + RESPONSE_TIME_LOG_FILE_CONFIG_PROP + "' connection property."));
                continue;
            }
            try {
                this.collectSnmpMetric(report, primaryIndex, snmpSession, schedule);
            }
            catch (SNMPException e) {
                log.error((Object)"An error occurred while attempting to collect an SNMP metric.", (Throwable)e);
            }
        }
        log.info((Object)("Collected " + report.getDataCount() + " metrics for VirtualHost " + this.resourceContext.getResourceKey() + "."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CreateResourceReport createResource(CreateResourceReport report) {
        if (!this.isAugeasEnabled()) {
            report.setStatus(CreateResourceStatus.FAILURE);
            report.setErrorMessage("Configuration and child resource creation/deletion support for Apache is optional. If you switched it on by enabling Augeas support in the connection settings of the Apache server resource and still get this message, it means that either your Apache version is not supported (only Apache 2.x is supported) or Augeas is not available on your platform.");
            return report;
        }
        ResourceType resourceType = report.getResourceType();
        AugeasComponent comp = null;
        try {
            comp = this.getAugeas();
            if (resourceType.equals((Object)this.getDirectoryResourceType())) {
                Configuration resourceConfiguration = report.getResourceConfiguration();
                Configuration pluginConfiguration = report.getPluginConfiguration();
                String directoryName = report.getUserSpecifiedResourceName();
                AugeasTree tree = comp.getAugeasTree("Httpd");
                AugeasNode myNode = this.getNode(tree);
                List directories = myNode.getChildByLabel("<Directory");
                int seq = 1;
                for (AugeasNode n : directories) {
                    String param = n.getFullPath();
                    int end = param.lastIndexOf(File.separatorChar);
                    if (end == -1 || !myNode.getFullPath().equals(param.substring(0, end))) continue;
                    ++seq;
                }
                pluginConfiguration.put((Property)new PropertySimple("regexp", (Object)false));
                String dirNameToSet = AugeasNodeValueUtil.escape(directoryName);
                try {
                    ApacheAugeasMapping mapping = new ApacheAugeasMapping(tree);
                    AugeasNode directoryNode = tree.createNode(myNode, "<Directory", null, seq);
                    String myNodeKey = AugeasNodeSearch.getNodeKey(myNode, tree.getRootNode());
                    tree.createNode(directoryNode, "param", dirNameToSet, 0);
                    mapping.updateAugeas(directoryNode, resourceConfiguration, resourceType.getResourceConfigurationDefinition());
                    tree.save();
                    comp.close();
                    tree = comp.getAugeasTree("Httpd");
                    AugeasNode parentNode = myNodeKey.equals("") ? tree.getRootNode() : AugeasNodeSearch.findNodeById(tree.getRootNode(), myNodeKey);
                    List nodes = parentNode.getChildByLabel("<Directory");
                    if (nodes.size() < seq) {
                        report.setStatus(CreateResourceStatus.FAILURE);
                        report.setErrorMessage("Could not create directory node.");
                    }
                    AugeasNode nd = (AugeasNode)nodes.get(seq - 1);
                    String key = AugeasNodeSearch.getNodeKey(nd, parentNode);
                    report.setResourceKey(key);
                    report.setResourceName(directoryName);
                    report.setStatus(CreateResourceStatus.SUCCESS);
                    ((ApacheServerComponent)this.resourceContext.getParentResourceComponent()).finishChildResourceCreate(report);
                }
                catch (Exception e) {
                    log.error((Object)"Could not create httpd virtual host child resource.", (Throwable)e);
                    report.setException((Throwable)e);
                    report.setStatus(CreateResourceStatus.FAILURE);
                }
            } else {
                report.setErrorMessage("Unable to create resources of type " + resourceType.getName());
                report.setStatus(CreateResourceStatus.FAILURE);
            }
        }
        finally {
            if (comp != null) {
                comp.close();
            }
        }
        return report;
    }

    public AugeasComponent getAugeas() {
        return ((ApacheServerComponent)this.resourceContext.getParentResourceComponent()).getAugeas();
    }

    public AugeasNode getNode(AugeasTree tree) {
        String resourceKey = this.resourceContext.getResourceKey();
        int snmpIdx = this.getWwwServiceIndex();
        ApacheServerComponent server = (ApacheServerComponent)this.resourceContext.getParentResourceComponent();
        if (snmpIdx < 1) {
            throw new IllegalStateException("Could not determine the index of the virtual host [" + resourceKey + "] in the runtime configuration. This is very strange.");
        }
        if (snmpIdx == 1) {
            return tree.getRootNode();
        }
        final ArrayList allVhosts = new ArrayList();
        RuntimeApacheConfiguration.walkRuntimeConfig(new RuntimeApacheConfiguration.NodeVisitor<AugeasNode>(){

            @Override
            public void visitOrdinaryNode(AugeasNode node) {
                if ("<VirtualHost".equalsIgnoreCase(node.getLabel())) {
                    allVhosts.add(node);
                }
            }

            @Override
            public void visitConditionalNode(AugeasNode node, boolean isSatisfied) {
            }
        }, tree, server.getCurrentProcessInfo(), server.getCurrentBinaryInfo(), server.getModuleNames(), false);
        int idx = allVhosts.size() - snmpIdx + 1;
        AugeasNode vhost = (AugeasNode)allVhosts.get(idx);
        if (vhost.getChildByLabel("<IfDefine").isEmpty() && vhost.getChildByLabel("<IfModule").isEmpty() && vhost.getChildByLabel("<IfVersion").isEmpty()) {
            return vhost;
        }
        throw new IllegalStateException("Configuration of the virtual host [" + resourceKey + "] contains conditional blocks. This is not supported by this plugin.");
    }

    public void finishConfigurationUpdate(ConfigurationUpdateReport report) {
        ((ApacheServerComponent)this.resourceContext.getParentResourceComponent()).finishConfigurationUpdate(report);
    }

    public void conditionalRestart() throws Exception {
        ((ApacheServerComponent)this.resourceContext.getParentResourceComponent()).conditionalRestart();
    }

    public void deleteEmptyFile(AugeasTree tree, AugeasNode deletedNode) {
        ((ApacheServerComponent)this.resourceContext.getParentResourceComponent()).deleteEmptyFile(tree, deletedNode);
    }

    private void collectSnmpMetric(MeasurementReport report, int primaryIndex, SNMPSession snmpSession, MeasurementScheduleRequest schedule) throws SNMPException {
        SNMPValue snmpValue = null;
        String metricName = schedule.getName();
        int dotIndex = metricName.indexOf(46);
        if (dotIndex == -1) {
            String mibName = metricName;
            List<SNMPValue> snmpValues = snmpSession.getColumn(mibName);
            snmpValue = snmpValues.get(primaryIndex - 1);
        } else {
            String oid;
            String mibName = metricName.substring(0, dotIndex);
            String mibSecondaryIndex = metricName.substring(dotIndex + 1);
            try {
                Integer.parseInt(mibSecondaryIndex);
                oid = mibSecondaryIndex;
            }
            catch (NumberFormatException e) {
                oid = this.convertStringToOid(mibSecondaryIndex);
            }
            boolean found = false;
            Map<String, SNMPValue> table = snmpSession.getTable(mibName, primaryIndex);
            if (table != null && (snmpValue = table.get(oid)) != null) {
                found = true;
            }
            if (!found) {
                log.error((Object)("Entry '" + oid + "' not found for " + mibName + "[" + primaryIndex + "]."));
                log.error((Object)("Table:\n" + table));
                return;
            }
        }
        log.debug((Object)("Collected SNMP metric [" + metricName + "], value = " + snmpValue));
        boolean valueIsTimestamp = false;
        ApacheServerComponent.addSnmpMetricValueToReport(report, schedule, snmpValue, valueIsTimestamp);
    }

    private String convertStringToOid(String string) {
        StringBuilder strBuf = new StringBuilder();
        strBuf.append(string.length());
        for (int i = 0; i < string.length(); ++i) {
            strBuf.append('.').append((byte)string.charAt(i));
        }
        String oid = strBuf.toString();
        return oid;
    }

    public static int getWwwServiceIndex(ApacheServerComponent parent, String resourceKey) {
        String vhostServerName = null;
        String[] vhostAddressStrings = null;
        int pipeIdx = resourceKey.indexOf(124);
        if (pipeIdx >= 0 && (vhostServerName = resourceKey.substring(0, pipeIdx)).isEmpty()) {
            vhostServerName = null;
        }
        vhostAddressStrings = resourceKey.substring(pipeIdx + 1).split(" ");
        int foundIdx = 0;
        if (!MAIN_SERVER_RESOURCE_KEY.equals(vhostAddressStrings[0])) {
            ApacheDirectiveTree tree = parent.parseRuntimeConfiguration(false);
            List<ApacheDirective> vhosts = tree.search("/<VirtualHost");
            for (ApacheDirective vhost : vhosts) {
                List<ApacheDirective> serverNames = vhost.getChildByName(SERVER_NAME_CONFIG_PROP);
                String serverName = serverNames.size() > 0 ? serverNames.get(0).getValuesAsString() : null;
                List<String> addrs = vhost.getValues();
                boolean serverNamesMatch = serverName == null && vhostServerName == null || serverName != null && serverName.equals(vhostServerName);
                boolean addrsMatch = true;
                if (addrs.size() != vhostAddressStrings.length) {
                    addrsMatch = false;
                } else {
                    for (int i = 0; i < vhostAddressStrings.length; ++i) {
                        if (addrs.contains(vhostAddressStrings[i])) continue;
                        addrsMatch = false;
                        break;
                    }
                }
                if (serverNamesMatch && addrsMatch) break;
                ++foundIdx;
            }
            if (foundIdx == vhosts.size()) {
                log.debug((Object)("The virtual host with resource key [" + resourceKey + "] doesn't seem to be present in the apache configuration anymore."));
                return -1;
            }
            foundIdx = vhosts.size() - foundIdx;
        }
        return foundIdx + 1;
    }

    private int getWwwServiceIndex() {
        ConfigurationTimestamp currentTimestamp = ((ApacheServerComponent)this.resourceContext.getParentResourceComponent()).getConfigurationTimestamp();
        if (!this.lastConfigurationTimeStamp.equals(currentTimestamp)) {
            this.snmpWwwServiceIndex = -1;
            this.lastConfigurationTimeStamp = currentTimestamp;
            this.snmpWwwServiceIndex = ApacheVirtualHostServiceComponent.getWwwServiceIndex((ApacheServerComponent)this.resourceContext.getParentResourceComponent(), this.resourceContext.getResourceKey());
        }
        return this.snmpWwwServiceIndex;
    }

    private ResourceType getDirectoryResourceType() {
        return (ResourceType)this.resourceContext.getResourceType().getChildResourceTypes().iterator().next();
    }

    public boolean isAugeasEnabled() {
        ApacheServerComponent parent = (ApacheServerComponent)this.resourceContext.getParentResourceComponent();
        return parent.isAugeasEnabled();
    }
}

