/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.cassandra;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.cassandra.installer.RMIContextFactory;
import org.rhq.core.domain.cloud.StorageNode;

public final class ClusterInitService {
    private final Log log = LogFactory.getLog(ClusterInitService.class);

    public boolean ping(List<StorageNode> storageNodes, int numHosts) {
        int connections = 0;
        long sleep = 100L;
        for (StorageNode host : storageNodes) {
            try {
                boolean isNativeTransportRunning = this.isNativeTransportRunning(host);
                if (isNativeTransportRunning) {
                    ++connections;
                }
                if (connections == numHosts) {
                    return true;
                }
            }
            catch (Exception e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Unable to open JMX connection to cassandra node [" + host + "]"), (Throwable)e);
                }
                return false;
            }
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException ex) {}
        }
        return true;
    }

    public void waitForClusterToStart(List<StorageNode> storageNodes) {
        this.waitForClusterToStart(storageNodes, storageNodes.size(), 10);
    }

    public void waitForClusterToStart(List<StorageNode> storageNodes, int numHosts, int retries) {
        this.waitForClusterToStart(storageNodes, numHosts, 250L, retries, 1);
    }

    public void waitForClusterToStart(List<StorageNode> storageNodes, int numHosts, long delay, int retries, int initialWait) {
        if (initialWait > 0) {
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Waiting before JMX calls to the storage nodes for " + initialWait + " seconds..."));
                }
                Thread.sleep(initialWait * 1000);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        int connections = 0;
        int failedConnections = 0;
        LinkedList<StorageNode> queue = new LinkedList<StorageNode>(storageNodes);
        StorageNode storageNode = (StorageNode)queue.poll();
        while (storageNode != null) {
            block17: {
                if (failedConnections >= retries) {
                    throw new RuntimeException("Unable to verify that cluster nodes have started after " + failedConnections + " failed attempts");
                }
                try {
                    boolean isNativeTransportRunning = this.isNativeTransportRunning(storageNode);
                    if (this.log.isDebugEnabled() && isNativeTransportRunning) {
                        this.log.debug((Object)("Successfully connected to cassandra node [" + storageNode + "]"));
                    }
                    if (isNativeTransportRunning) {
                        ++connections;
                    } else {
                        queue.offer(storageNode);
                    }
                    if (connections != numHosts) break block17;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"Successdully connected to all nodes. Sleeping for 10 seconds to allow for the cassandra superuser set up to complete.");
                    }
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    return;
                }
                catch (Exception e) {
                    ++failedConnections;
                    queue.offer(storageNode);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Unable to open JMX connection to cassandra node [" + storageNode + "]."), (Throwable)e);
                    }
                    if (!this.log.isInfoEnabled()) break block17;
                    this.log.debug((Object)"Unable to open connection to cassandra node.");
                }
            }
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            storageNode = (StorageNode)queue.poll();
        }
    }

    public void waitForSchemaAgreement(List<StorageNode> storageNodes) throws Exception {
        if (storageNodes == null) {
            return;
        }
        long sleep = 100L;
        boolean schemaInAgreement = false;
        while (!schemaInAgreement) {
            HashSet<String> schemaVersions = new HashSet<String>();
            for (StorageNode host : storageNodes) {
                String otherSchchemaVersion = this.getSchemaVersionForNode(host);
                if (otherSchchemaVersion == null) continue;
                schemaVersions.add(otherSchchemaVersion);
            }
            if (schemaVersions.size() > 1) {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("Schema agreement has not been reached. Found " + schemaVersions.size() + " schema versions"));
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Found the following schema versions: " + schemaVersions));
                }
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException e) {}
                continue;
            }
            String schemaVersion = (String)schemaVersions.iterator().next();
            if (schemaVersion != null) {
                schemaInAgreement = true;
                continue;
            }
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Schema agreement has not been reached. Unable to get the schema version from cassandra nodes [" + storageNodes + "]"));
            }
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNativeTransportRunning(StorageNode storageNode) throws Exception {
        Boolean nativeTransportRunning;
        block7: {
            nativeTransportRunning = false;
            String url = storageNode.getJMXConnectionURL();
            JMXServiceURL serviceURL = new JMXServiceURL(url);
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("java.naming.factory.initial", RMIContextFactory.class.getName());
            JMXConnector connector = null;
            try {
                connector = JMXConnectorFactory.connect(serviceURL, env);
                MBeanServerConnection serverConnection = connector.getMBeanServerConnection();
                ObjectName storageService = new ObjectName("org.apache.cassandra.db:type=StorageService");
                String attribute = "NativeTransportRunning";
                try {
                    nativeTransportRunning = (Boolean)serverConnection.getAttribute(storageService, attribute);
                }
                catch (Exception e) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Failed to read attribute [" + attribute + "] from " + storageService), (Throwable)e);
                        break block7;
                    }
                    this.log.info((Object)("Faied to read attribute [" + attribute + "] from " + storageService + ": " + e.getMessage()));
                }
            }
            finally {
                if (connector != null) {
                    connector.close();
                }
            }
        }
        return nativeTransportRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getSchemaVersionForNode(StorageNode storageNode) throws Exception {
        String url = storageNode.getJMXConnectionURL();
        JMXServiceURL serviceURL = new JMXServiceURL(url);
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("java.naming.factory.initial", RMIContextFactory.class.getName());
        JMXConnector connector = null;
        try {
            connector = JMXConnectorFactory.connect(serviceURL, env);
            MBeanServerConnection serverConnection = connector.getMBeanServerConnection();
            ObjectName storageService = new ObjectName("org.apache.cassandra.db:type=StorageService");
            String attribute = "SchemaVersion";
            try {
                String string = (String)serverConnection.getAttribute(storageService, attribute);
                return string;
            }
            catch (Exception e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Failed to read attribute [" + attribute + "] from " + storageService), (Throwable)e);
                } else {
                    this.log.info((Object)("Faied to read attribute [" + attribute + "] from " + storageService + ": " + e.getMessage()));
                }
                if (connector == null) return null;
                connector.close();
                return null;
            }
        }
        finally {
            if (connector != null) {
                connector.close();
            }
        }
    }
}

