/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.cassandra;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.cassandra.DeploymentException;
import org.rhq.cassandra.DeploymentOptions;
import org.rhq.core.util.TokenReplacingProperties;
import org.rhq.core.util.TokenReplacingReader;
import org.rhq.core.util.ZipUtil;
import org.rhq.core.util.stream.StreamUtil;

public class Deployer {
    private final Log log = LogFactory.getLog(Deployer.class);
    private DeploymentOptions deploymentOptions;

    public void setDeploymentOptions(DeploymentOptions deploymentOptions) {
        this.deploymentOptions = deploymentOptions;
    }

    public void unzipDistro() throws DeploymentException {
        InputStream inputStream = this.getClass().getResourceAsStream("/cassandra.zip");
        File deployDir = new File(this.deploymentOptions.getBasedir());
        deployDir.mkdir();
        try {
            this.log.info((Object)("Unzipping storage node to " + deployDir));
            ZipUtil.unzipFile((InputStream)inputStream, (File)deployDir);
        }
        catch (IOException e) {
            this.log.error((Object)"An error occurred while unzipping the storage zip file", (Throwable)e);
            throw new DeploymentException("An error occurred while unzipping the storage zip file", e);
        }
    }

    public void applyConfigChanges() throws DeploymentException {
        File deployDir = new File(this.deploymentOptions.getBasedir());
        File confDir = new File(deployDir, "conf");
        TokenReplacingProperties tokens = this.deploymentOptions.toMap();
        tokens.put("cluster.name", "rhq");
        this.applyConfigChanges(confDir, "cassandra.yaml", (Map<String, String>)tokens);
        this.applyConfigChanges(confDir, "log4j-server.properties", (Map<String, String>)tokens);
        this.applyConfigChanges(confDir, "cassandra-env.sh", (Map<String, String>)tokens);
    }

    private void applyConfigChanges(File confDir, String fileName, Map<String, String> tokens) throws DeploymentException {
        File filteredFile = new File(confDir, fileName);
        try {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Applying configuration changes to " + filteredFile));
            }
            File rhqFile = new File(confDir, "rhq." + fileName);
            TokenReplacingReader reader = new TokenReplacingReader((Reader)new FileReader(rhqFile), tokens);
            StreamUtil.copy((Reader)reader, (Writer)new FileWriter(filteredFile));
            rhqFile.delete();
        }
        catch (IOException e) {
            this.log.error((Object)("An unexpected error occurred while apply configuration changes to " + filteredFile), (Throwable)e);
            throw new DeploymentException("An unexpected error occurred while apply configuration changes to " + filteredFile, e);
        }
    }

    public void updateFilePerms() {
        File deployDir = new File(this.deploymentOptions.getBasedir());
        File binDir = new File(deployDir, "bin");
        this.log.info((Object)("Updating file permissions in " + binDir));
        for (File f : binDir.listFiles()) {
            f.setExecutable(true);
        }
    }
}

