/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.cassandra;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.cassandra.DeploymentProperty;
import org.rhq.core.util.TokenReplacingProperties;

public class DeploymentOptions {
    private final Log log = LogFactory.getLog(DeploymentOptions.class);
    private boolean loaded;
    private String clusterDir;
    private String basedir;
    private Integer numNodes;
    private Boolean embedded;
    private String loggingLevel;
    private Integer numTokens;
    private Integer nativeTransportPort;
    private Boolean startRpc;
    private Integer rpcPort;
    private Integer nativeTransportMaxThreads;
    private String username;
    private String password;
    private String authenticator;
    private String authorizer;
    private String dataDir;
    private String commitLogDir;
    private String savedCachesDir;
    private String listenAddress;
    private String rpcAddress;
    private Integer jmxPort;
    private Integer storagePort;
    private Integer sslStoragePort;
    private String seeds;
    private String heapSize;
    private String heapNewSize;
    private String logFileName;
    private String stackSize;

    DeploymentOptions() {
    }

    public void load() throws IOException {
        if (this.loaded) {
            return;
        }
        InputStream stream = null;
        try {
            stream = this.getClass().getResourceAsStream("/cassandra.properties");
            Properties props = new Properties();
            props.load(stream);
            this.init(props);
            this.loaded = true;
        }
        catch (IOException e) {
            this.log.warn((Object)"Unable to load deployment options from cassandra.properties.");
            this.log.info((Object)"The following error occurred while trying to load options.", (Throwable)e);
            throw e;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    String msg = "An error occurred while closing input stream on cassandra.properties";
                    this.log.info((Object)msg, (Throwable)e);
                }
            }
        }
    }

    private void init(Properties properties) {
        this.setClusterDir(this.loadProperty("rhq.cassandra.cluster.dir", properties));
        this.setNumNodes(Integer.parseInt(this.loadProperty("rhq.cassandra.cluster.num-nodes", properties)));
        this.setEmbedded(Boolean.valueOf(this.loadProperty("rhq.cassandra.cluster.is-embedded", properties)));
        this.setLoggingLevel(this.loadProperty("rhq.cassandra.logging.level", properties));
        this.setNumTokens(Integer.valueOf(this.loadProperty("rhq.cassandra.num-tokens", properties)));
        this.setNativeTransportPort(Integer.valueOf(this.loadProperty("rhq.cassandra.native-transport-port", properties)));
        this.setRpcPort(Integer.valueOf(this.loadProperty("rhq.cassandra.rpc-port", properties)));
        this.setNativeTransportMaxThreads(Integer.valueOf(this.loadProperty("rhq.cassandra.native-transport-max-threads", properties)));
        this.setUsername(this.loadProperty("rhq.cassandra.username", properties));
        this.setPassword(this.loadProperty("rhq.cassandra.password", properties));
        this.setAuthenticator(this.loadProperty("rhq.cassandra.authenticator", properties));
        this.setAuthorizer(this.loadProperty("rhq.cassandra.authorizer", properties));
        this.setDataDir(this.loadProperty("rhq.cassandra.data.dir", properties));
        this.setCommitLogDir(this.loadProperty("rhq.cassandra.commitlog.dir", properties));
        this.setSavedCachesDir(this.loadProperty("rhq.cassandra.saved.caches.dir", properties));
        this.setLogFileName(this.loadProperty("rhq.cassandra.log.file", properties));
        this.setListenAddress(this.loadProperty("rhq.cassandra.listen.address", properties));
        this.setStartRpc(Boolean.valueOf(this.loadProperty("rhq.cassandra.start_rpc", properties)));
        this.setRpcAddress(this.loadProperty("rhq.cassandra.rpc.address", properties));
        this.setJmxPort(Integer.valueOf(this.loadProperty("rhq.cassandra.jmx.port", properties)));
        this.setStoragePort(Integer.valueOf(this.loadProperty("rhq.cassandra.storage.port", properties)));
        this.setSslStoragePort(Integer.valueOf(this.loadProperty("rhq.cassandra.ssl.storage.port", properties)));
        this.setSeeds(this.loadProperty("rhq.cassandra.seeds", properties));
        this.setBasedir(this.loadProperty("rhq.cassandra.basedir", properties));
        this.setHeapSize(this.loadProperty("rhq.cassandra.max.heap.size", properties));
        this.setHeapNewSize(this.loadProperty("rhq.cassandra.heap.new.size", properties));
        this.setStackSize(this.loadProperty("rhq.cassandra.stack.size", properties));
    }

    private String loadProperty(String key, Properties properties) {
        String value = System.getProperty(key);
        if (value == null || value.isEmpty()) {
            return properties.getProperty(key);
        }
        return value;
    }

    public void merge(DeploymentOptions other) {
        this.setClusterDir(other.clusterDir);
        this.setNumNodes(other.numNodes);
        this.setEmbedded(other.embedded);
        this.setLoggingLevel(other.loggingLevel);
        this.setNumTokens(other.numTokens);
        this.setNativeTransportPort(other.nativeTransportPort);
        this.setNativeTransportMaxThreads(other.nativeTransportMaxThreads);
        this.setUsername(other.username);
        this.setPassword(other.password);
        this.setAuthenticator(other.authenticator);
        this.setAuthorizer(other.authorizer);
        this.setDataDir(other.dataDir);
        this.setCommitLogDir(other.commitLogDir);
        this.setSavedCachesDir(other.savedCachesDir);
        this.setLogFileName(other.logFileName);
        this.setListenAddress(other.listenAddress);
        this.setRpcAddress(other.rpcAddress);
        this.setStartRpc(other.startRpc);
        this.setRpcPort(other.rpcPort);
        this.setJmxPort(other.jmxPort);
        this.setStoragePort(other.storagePort);
        this.setSslStoragePort(other.sslStoragePort);
        this.setSeeds(other.seeds);
        this.setBasedir(other.basedir);
        this.setHeapSize(other.heapSize);
        this.setHeapNewSize(other.heapNewSize);
        this.setStackSize(other.stackSize);
    }

    public TokenReplacingProperties toMap() {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(DeploymentOptions.class);
            TreeMap<String, String> properties = new TreeMap<String, String>();
            for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
                Object value;
                if (pd.getReadMethod() == null) {
                    throw new RuntimeException("The [" + pd.getName() + "] property must define a getter method");
                }
                Method method = pd.getReadMethod();
                DeploymentProperty deploymentProperty = method.getAnnotation(DeploymentProperty.class);
                if (deploymentProperty == null || (value = method.invoke((Object)this, null)) == null) continue;
                properties.put(deploymentProperty.name(), value.toString());
            }
            return new TokenReplacingProperties(properties);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert " + DeploymentOptions.class.getName() + " to a map", e);
        }
    }

    @DeploymentProperty(name="cluster.dir")
    public String getClusterDir() {
        return this.clusterDir;
    }

    public void setClusterDir(String dir) {
        if (this.clusterDir == null) {
            this.clusterDir = dir;
        }
    }

    @DeploymentProperty(name="rhq.cassandra.basedir")
    public String getBasedir() {
        return this.basedir;
    }

    public void setBasedir(String dir) {
        if (this.basedir == null) {
            this.basedir = dir;
        }
    }

    @DeploymentProperty(name="rhq.cassandra.cluster.num-nodes")
    public int getNumNodes() {
        return this.numNodes;
    }

    public void setNumNodes(int numNodes) {
        if (this.numNodes == null) {
            this.numNodes = numNodes;
        }
    }

    @DeploymentProperty(name="rhq.cassandra.cluster.is-embedded")
    public boolean isEmbedded() {
        return this.embedded;
    }

    public void setEmbedded(boolean embedded) {
        if (this.embedded == null) {
            this.embedded = embedded;
        }
    }

    @DeploymentProperty(name="rhq.cassandra.logging.level")
    public String getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setLoggingLevel(String loggingLevel) {
        if (this.loggingLevel == null) {
            this.loggingLevel = loggingLevel;
        }
    }

    @DeploymentProperty(name="rhq.cassandra.num_tokens")
    public Integer getNumTokens() {
        return this.numTokens;
    }

    public void setNumTokens(int numTokens) {
        if (this.numTokens == null) {
            this.numTokens = numTokens;
        }
    }

    @DeploymentProperty(name="rhq.cassandra.native_transport_port")
    public Integer getNativeTransportPort() {
        return this.nativeTransportPort;
    }

    public void setNativeTransportPort(Integer port) {
        if (this.nativeTransportPort == null) {
            this.nativeTransportPort = port;
        }
    }

    @DeploymentProperty(name="rhq.cassandra.start_rpc")
    public Boolean getStartRpc() {
        return this.startRpc;
    }

    public void setStartRpc(Boolean startRpc) {
        if (this.startRpc == null) {
            this.startRpc = startRpc;
        }
    }

    @DeploymentProperty(name="rhq.cassandra.rpc_port")
    public Integer getRpcPort() {
        return this.rpcPort;
    }

    public void setRpcPort(Integer port) {
        if (this.rpcPort == null) {
            this.rpcPort = port;
        }
    }

    @DeploymentProperty(name="rhq.cassandra.native_transport_max_threads")
    public Integer getNativeTransportMaxThreads() {
        return this.nativeTransportMaxThreads;
    }

    public void setNativeTransportMaxThreads(Integer numThreads) {
        if (this.nativeTransportMaxThreads == null) {
            this.nativeTransportMaxThreads = numThreads;
        }
    }

    @DeploymentProperty(name="rhq.cassandra.username")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        if (this.username == null) {
            this.username = username;
        }
    }

    @DeploymentProperty(name="rhq.cassandra.password")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        if (this.password == null) {
            this.password = password;
        }
    }

    @DeploymentProperty(name="rhq.cassandra.authenticator")
    public String getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(String authenticator) {
        if (this.authenticator == null) {
            this.authenticator = authenticator;
        }
    }

    @DeploymentProperty(name="rhq.cassandra.authorizer")
    public String getAuthorizer() {
        return this.authorizer;
    }

    public void setAuthorizer(String authorizer) {
        if (this.authorizer == null) {
            this.authorizer = authorizer;
        }
    }

    @DeploymentProperty(name="rhq.cassandra.data.dir")
    public String getDataDir() {
        return this.dataDir;
    }

    public void setDataDir(String dir) {
        if (this.dataDir == null) {
            this.dataDir = dir;
        }
    }

    @DeploymentProperty(name="rhq.cassandra.commitlog.dir")
    public String getCommitLogDir() {
        return this.commitLogDir;
    }

    public void setCommitLogDir(String dir) {
        if (this.commitLogDir == null) {
            this.commitLogDir = dir;
        }
    }

    @DeploymentProperty(name="rhq.cassandra.saved.caches.dir")
    public String getSavedCachesDir() {
        return this.savedCachesDir;
    }

    public void setSavedCachesDir(String dir) {
        if (this.savedCachesDir == null) {
            this.savedCachesDir = dir;
        }
    }

    @DeploymentProperty(name="rhq.cassandra.log.file")
    public String getLogFileName() {
        return this.logFileName;
    }

    public void setLogFileName(String name) {
        if (this.logFileName == null) {
            this.logFileName = name;
        }
    }

    @DeploymentProperty(name="rhq.cassandra.listen.address")
    public String getListenAddress() {
        return this.listenAddress;
    }

    public void setListenAddress(String address) {
        if (this.listenAddress == null) {
            this.listenAddress = address;
        }
    }

    @DeploymentProperty(name="rpc.address")
    public String getRpcAddress() {
        return this.rpcAddress;
    }

    public void setRpcAddress(String address) {
        if (this.rpcAddress == null) {
            this.rpcAddress = address;
        }
    }

    @DeploymentProperty(name="rhq.cassandra.jmx.port")
    public Integer getJmxPort() {
        return this.jmxPort;
    }

    public void setJmxPort(Integer port) {
        if (this.jmxPort == null) {
            this.jmxPort = port;
        }
    }

    @DeploymentProperty(name="rhq.cassandra.storage.port")
    public Integer getStoragePort() {
        return this.storagePort;
    }

    public void setStoragePort(Integer port) {
        if (this.storagePort == null) {
            this.storagePort = port;
        }
    }

    @DeploymentProperty(name="rhq.cassandra.ssl.storage.port")
    public Integer getSslStoragePort() {
        return this.sslStoragePort;
    }

    public void setSslStoragePort(Integer port) {
        if (this.sslStoragePort == null) {
            this.sslStoragePort = port;
        }
    }

    @DeploymentProperty(name="rhq.cassandra.seeds")
    public String getSeeds() {
        return this.seeds;
    }

    public void setSeeds(String seeds) {
        if (this.seeds == null) {
            this.seeds = seeds;
        }
    }

    @DeploymentProperty(name="rhq.cassandra.max.heap.size")
    public String getHeapSize() {
        return this.heapSize;
    }

    public void setHeapSize(String heapSize) {
        if (this.heapSize == null) {
            this.heapSize = heapSize;
        }
    }

    @DeploymentProperty(name="rhq.cassandra.heap.new.size")
    public String getHeapNewSize() {
        return this.heapNewSize;
    }

    public void setHeapNewSize(String heapNewSize) {
        if (this.heapNewSize == null) {
            this.heapNewSize = heapNewSize;
        }
    }

    @DeploymentProperty(name="rhq.cassandra.stack.size")
    public String getStackSize() {
        return this.stackSize;
    }

    public void setStackSize(String size) {
        if (this.stackSize == null) {
            this.stackSize = size;
        }
    }
}

