/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.cassandra.schema;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Query;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.cassandra.schema.AbstractManager;
import org.rhq.core.domain.cloud.StorageNode;

public class VersionManager
extends AbstractManager {
    private static final String SCHEMA_BASE_FOLDER = "schema";
    private static final String INSERT_VERSION_QUERY = "INSERT INTO rhq.schema_version (version, time ) VALUES ( ?, ?);";
    private final Log log = LogFactory.getLog(VersionManager.class);

    public VersionManager(String username, String password, List<StorageNode> nodes) {
        super(username, password, nodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install() throws Exception {
        this.log.info((Object)"Preparing to install schema");
        try {
            this.initCluster();
        }
        catch (AuthenticationException e) {
            this.bootstrap();
        }
        try {
            this.initCluster();
            if (!this.schemaExists()) {
                this.session.execute("ALTER USER cassandra NOSUPERUSER");
                this.session.execute("ALTER USER cassandra WITH PASSWORD '" + UUID.randomUUID() + "'");
                this.executeTask(Task.Create);
            } else {
                this.log.info((Object)"RHQ schema already exists.");
            }
            this.executeTask(Task.Update);
        }
        finally {
            this.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrap() {
        try {
            this.initCluster("cassandra", "cassandra");
            int replicationFactor = this.nodes.size() < 3 ? this.nodes.size() : (this.nodes.size() < 4 ? 2 : 3);
            this.log.info((Object)("Updating replication_factor of system_auth keyspace to " + replicationFactor));
            this.session.execute("ALTER KEYSPACE system_auth WITH replication = {'class': 'SimpleStrategy', 'replication_factor': " + replicationFactor + "}");
            this.log.info((Object)"Creating rhqadmin user");
            this.session.execute("CREATE USER rhqadmin WITH PASSWORD 'rhqadmin' SUPERUSER");
        }
        finally {
            this.shutdown();
        }
    }

    public void drop() throws Exception {
        this.log.info((Object)"Preparing to drop RHQ schema");
        try {
            this.initCluster();
            if (this.schemaExists()) {
                this.executeTask(Task.Drop);
            } else {
                this.log.info((Object)"RHQ schema does not exist. Drop operation not required.");
            }
        }
        catch (NoHostAvailableException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.shutdown();
        }
    }

    private void executeTask(Task task) {
        try {
            this.log.info((Object)("Starting to execute " + (Object)((Object)task) + " task."));
            List<String> updateFiles = this.getUpdateFiles(task.getFolder());
            if (Task.Update.equals((Object)task)) {
                int currentSchemaVersion = this.getSchemaVersion();
                this.log.info((Object)("Current schema version is " + currentSchemaVersion));
                this.removeAppliedUpdates(updateFiles, currentSchemaVersion);
            }
            if (updateFiles.size() == 0 && Task.Update.equals((Object)task)) {
                this.log.info((Object)"RHQ schema is current! No updates applied.");
            }
            for (String updateFile : updateFiles) {
                this.log.info((Object)("Applying file " + updateFile + " for " + (Object)((Object)task) + " task."));
                for (String step : this.getSteps(updateFile)) {
                    this.log.info((Object)("Statement: \n" + step));
                    this.session.execute(step);
                }
                if (Task.Update.equals((Object)task)) {
                    this.updateSchemaVersion(updateFile);
                }
                this.log.info((Object)("File " + updateFile + " applied for " + (Object)((Object)task) + " task."));
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new RuntimeException(e);
        }
        this.log.info((Object)("Successfully executed " + (Object)((Object)task) + " task."));
    }

    private void updateSchemaVersion(String updateFileName) {
        PreparedStatement preparedStatement = this.session.prepare(INSERT_VERSION_QUERY);
        BoundStatement boundStatement = preparedStatement.bind(new Object[]{this.extractVersionFromUpdateFile(updateFileName), new Date()});
        this.session.execute((Query)boundStatement);
    }

    private static enum Task {
        Drop("drop"),
        Create("create"),
        Update("update");

        private final String folder;

        private Task(String folder) {
            this.folder = folder;
        }

        protected String getFolder() {
            return "schema/" + this.folder + "/";
        }
    }
}

