/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.clientapi.shared;

import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.ValidationEventCollector;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.rhq.core.clientapi.agent.metadata.ConfigurationMetadataParser;
import org.rhq.core.clientapi.agent.metadata.PluginMetadataParser;
import org.rhq.core.clientapi.descriptor.configuration.ConfigurationDescriptor;
import org.rhq.core.clientapi.descriptor.plugin.PluginDescriptor;
import org.rhq.core.clientapi.descriptor.plugin.ResourceDescriptor;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;

public class PluginDescriptorUtil {
    public static PluginDescriptor loadPluginDescriptor(String file) {
        URL pluginDescriptorURL = PluginDescriptorUtil.class.getClassLoader().getResource(file);
        if (pluginDescriptorURL == null) {
            throw new RuntimeException("File " + file + " not found");
        }
        return PluginDescriptorUtil.loadPluginDescriptor(pluginDescriptorURL);
    }

    public static PluginDescriptor loadPluginDescriptor(URL pluginDescriptorURL) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.rhq.core.clientapi.descriptor.plugin");
            URL pluginSchemaURL = PluginDescriptorUtil.class.getClassLoader().getResource("rhq-plugin.xsd");
            Schema pluginSchema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(pluginSchemaURL);
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            ValidationEventCollector vec = new ValidationEventCollector();
            unmarshaller.setEventHandler((ValidationEventHandler)vec);
            unmarshaller.setSchema(pluginSchema);
            return (PluginDescriptor)unmarshaller.unmarshal(pluginDescriptorURL.openStream());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static PluginDescriptor toPluginDescriptor(String string) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.rhq.core.clientapi.descriptor.plugin");
            URL pluginSchemaURL = PluginMetadataParser.class.getClassLoader().getResource("rhq-plugin.xsd");
            Schema pluginSchema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(pluginSchemaURL);
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            ValidationEventCollector vec = new ValidationEventCollector();
            unmarshaller.setEventHandler((ValidationEventHandler)vec);
            unmarshaller.setSchema(pluginSchema);
            StringReader reader = new StringReader(string);
            return (PluginDescriptor)unmarshaller.unmarshal((Reader)reader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object find(PluginDescriptor descriptor, String path) {
        JXPathContext context = JXPathContext.newContext((Object)descriptor);
        return context.getValue(path);
    }

    public static ConfigurationDefinition loadPluginConfigDefFor(PluginDescriptor descriptor, String path, String configName) {
        try {
            ResourceDescriptor resourceDescriptor = (ResourceDescriptor)PluginDescriptorUtil.find(descriptor, path);
            return ConfigurationMetadataParser.parse((String)configName, (ConfigurationDescriptor)resourceDescriptor.getPluginConfiguration());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ConfigurationDefinition loadResourceConfigDefFor(PluginDescriptor descriptor, String path, String configName) {
        try {
            ResourceDescriptor resourceDescriptor = (ResourceDescriptor)PluginDescriptorUtil.find(descriptor, path);
            return ConfigurationMetadataParser.parse((String)configName, (ConfigurationDescriptor)resourceDescriptor.getResourceConfiguration());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

