/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.tool.plugindoc;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.metadata.ConfigurationMetadataParser;
import org.rhq.core.clientapi.agent.metadata.ContentMetadataParser;
import org.rhq.core.clientapi.agent.metadata.InvalidPluginDescriptorException;
import org.rhq.core.clientapi.agent.metadata.MetricsMetadataParser;
import org.rhq.core.clientapi.agent.metadata.OperationsMetadataParser;
import org.rhq.core.clientapi.agent.metadata.SubCategoriesMetadataParser;
import org.rhq.core.clientapi.descriptor.configuration.ConfigurationDescriptor;
import org.rhq.core.clientapi.descriptor.plugin.ContentDescriptor;
import org.rhq.core.clientapi.descriptor.plugin.MetricDescriptor;
import org.rhq.core.clientapi.descriptor.plugin.OperationDescriptor;
import org.rhq.core.clientapi.descriptor.plugin.ParentResourceType;
import org.rhq.core.clientapi.descriptor.plugin.PlatformDescriptor;
import org.rhq.core.clientapi.descriptor.plugin.PluginDescriptor;
import org.rhq.core.clientapi.descriptor.plugin.ProcessScanDescriptor;
import org.rhq.core.clientapi.descriptor.plugin.ResourceCreateDeletePolicy;
import org.rhq.core.clientapi.descriptor.plugin.ResourceCreationData;
import org.rhq.core.clientapi.descriptor.plugin.ResourceDescriptor;
import org.rhq.core.clientapi.descriptor.plugin.RunsInsideType;
import org.rhq.core.clientapi.descriptor.plugin.ServerDescriptor;
import org.rhq.core.clientapi.descriptor.plugin.ServiceDescriptor;
import org.rhq.core.clientapi.descriptor.plugin.SubCategoryDescriptor;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.resource.CreateDeletePolicy;
import org.rhq.core.domain.resource.ProcessScan;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceCreationDataType;
import org.rhq.core.domain.resource.ResourceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginDescriptorProcessor {
    private final Log log = LogFactory.getLog(PluginDescriptorProcessor.class);
    private PluginDescriptor pluginDescriptor;
    private Set<ResourceType> resourceTypes = new LinkedHashSet<ResourceType>();

    public PluginDescriptorProcessor(PluginDescriptor pluginDescriptor) {
        this.pluginDescriptor = pluginDescriptor;
    }

    public Set<ResourceType> processPluginDescriptor() throws InvalidPluginDescriptorException {
        for (PlatformDescriptor serverDescriptor : this.pluginDescriptor.getPlatforms()) {
            this.parsePlatformDescriptor(serverDescriptor);
        }
        for (PlatformDescriptor serverDescriptor : this.pluginDescriptor.getServers()) {
            this.parseServerDescriptor((ServerDescriptor)serverDescriptor, null);
        }
        for (ServiceDescriptor serviceDescriptor : this.pluginDescriptor.getServices()) {
            this.parseServiceDescriptor(serviceDescriptor, null);
        }
        return this.resourceTypes;
    }

    private ResourceType parsePlatformDescriptor(PlatformDescriptor platformDescriptor) throws InvalidPluginDescriptorException {
        ResourceType platformResourceType = new ResourceType(platformDescriptor.getName(), this.pluginDescriptor.getName(), ResourceCategory.PLATFORM, null);
        platformResourceType.setSubCategory(SubCategoriesMetadataParser.findSubCategoryOnResourceTypeAncestor((ResourceType)platformResourceType, (String)platformDescriptor.getSubCategory()));
        platformResourceType.setDescription(platformDescriptor.getDescription());
        this.log.debug((Object)("Parsed platform resource type: " + platformResourceType));
        this.parseResourceDescriptor((ResourceDescriptor)platformDescriptor, platformResourceType, null, null, null);
        if (platformResourceType.getProcessScans() != null && platformResourceType.getProcessScans().size() > 0) {
            this.log.warn((Object)("Platforms are not auto-discovered via process scans. The <process-scan> elements will be ignored in resource type: " + platformResourceType));
        }
        return platformResourceType;
    }

    private ResourceType parseServerDescriptor(ServerDescriptor serverDescriptor, ResourceType parentServerType) throws InvalidPluginDescriptorException {
        ResourceType serverResourceType;
        String sourcePlugin = serverDescriptor.getSourcePlugin();
        String sourceServer = serverDescriptor.getSourceType();
        sourcePlugin = sourcePlugin == null ? "" : sourcePlugin.trim();
        String string = sourceServer = sourceServer == null ? "" : sourceServer.trim();
        if (sourcePlugin.length() == 0 && sourceServer.length() == 0) {
            serverResourceType = new ResourceType(serverDescriptor.getName(), this.pluginDescriptor.getName(), ResourceCategory.SERVER, parentServerType);
            serverResourceType.setSubCategory(SubCategoriesMetadataParser.findSubCategoryOnResourceTypeAncestor((ResourceType)serverResourceType, (String)serverDescriptor.getSubCategory()));
            serverResourceType.setDescription(serverDescriptor.getDescription());
            serverResourceType.setCreationDataType(this.convertCreationDataType(serverDescriptor.getCreationDataType()));
            serverResourceType.setCreateDeletePolicy(this.convertCreateDeletePolicy(serverDescriptor.getCreateDeletePolicy()));
            serverResourceType.setSingleton(serverDescriptor.isSingleton());
            this.log.debug((Object)("Parsed server resource type: " + serverResourceType));
            this.parseResourceDescriptor((ResourceDescriptor)serverDescriptor, serverResourceType, null, null, null);
        } else if (sourcePlugin.length() > 0 && sourceServer.length() > 0) {
            serverResourceType = new ResourceType(serverDescriptor.getName(), this.pluginDescriptor.getName(), ResourceCategory.SERVER, parentServerType);
            serverResourceType.setDescription(serverDescriptor.getDescription());
            serverResourceType.setSubCategory(SubCategoriesMetadataParser.findSubCategoryOnResourceTypeAncestor((ResourceType)serverResourceType, (String)serverDescriptor.getSubCategory()));
            serverResourceType.setCreationDataType(this.convertCreationDataType(serverDescriptor.getCreationDataType()));
            serverResourceType.setCreateDeletePolicy(this.convertCreateDeletePolicy(serverDescriptor.getCreateDeletePolicy()));
            serverResourceType.setSingleton(serverDescriptor.isSingleton());
            String discoveryClass = this.getFullyQualifiedComponentClassName(this.pluginDescriptor.getPackage(), serverDescriptor.getDiscovery());
            String componentClass = this.getFullyQualifiedComponentClassName(this.pluginDescriptor.getPackage(), serverDescriptor.getClazz());
        } else {
            throw new InvalidPluginDescriptorException("Both sourcePlugin and sourceType must be defined: " + serverDescriptor.getName());
        }
        RunsInsideType runsInside = serverDescriptor.getRunsInside();
        if (runsInside != null) {
            List parentTypesDescriptor = runsInside.getParentResourceType();
            for (ParentResourceType parentTypeDescriptor : parentTypesDescriptor) {
                ResourceType parentResourceType = new ResourceType(parentTypeDescriptor.getName(), parentTypeDescriptor.getPlugin(), ResourceCategory.SERVER, ResourceType.ANY_PLATFORM_TYPE);
                serverResourceType.addParentResourceType(parentResourceType);
            }
        }
        for (ServerDescriptor childServerDescriptor : serverDescriptor.getServers()) {
            this.parseServerDescriptor(childServerDescriptor, serverResourceType);
        }
        return serverResourceType;
    }

    private ResourceType parseServiceDescriptor(ServiceDescriptor serviceDescriptor, ResourceType parentType) throws InvalidPluginDescriptorException {
        RunsInsideType runsInside;
        ResourceType serviceResourceType;
        String sourcePlugin = serviceDescriptor.getSourcePlugin();
        String sourceService = serviceDescriptor.getSourceType();
        sourcePlugin = sourcePlugin == null ? "" : sourcePlugin.trim();
        String string = sourceService = sourceService == null ? "" : sourceService.trim();
        if (sourcePlugin.length() == 0 && sourceService.length() == 0) {
            serviceResourceType = new ResourceType(serviceDescriptor.getName(), this.pluginDescriptor.getName(), ResourceCategory.SERVICE, parentType);
            serviceResourceType.setSubCategory(SubCategoriesMetadataParser.findSubCategoryOnResourceTypeAncestor((ResourceType)serviceResourceType, (String)serviceDescriptor.getSubCategory()));
            serviceResourceType.setDescription(serviceDescriptor.getDescription());
            serviceResourceType.setCreationDataType(this.convertCreationDataType(serviceDescriptor.getCreationDataType()));
            serviceResourceType.setCreateDeletePolicy(this.convertCreateDeletePolicy(serviceDescriptor.getCreateDeletePolicy()));
            serviceResourceType.setSingleton(serviceDescriptor.isSingleton());
            this.log.debug((Object)("Parsed service resource type: " + serviceResourceType));
            this.parseResourceDescriptor((ResourceDescriptor)serviceDescriptor, serviceResourceType, null, null, null);
            if (serviceResourceType.getProcessScans() != null && serviceResourceType.getProcessScans().size() > 0) {
                this.log.warn((Object)("Child services are not auto-discovered via process scans. The <process-scan> elements will be ignored in resource type: " + serviceResourceType));
            }
        } else if (sourcePlugin.length() > 0) {
            if (sourceService.length() == 0) {
                ServiceDescriptor serviceDescriptor2 = serviceDescriptor;
            }
            serviceResourceType = new ResourceType(serviceDescriptor.getName(), this.pluginDescriptor.getName(), ResourceCategory.SERVICE, parentType);
            serviceResourceType.setDescription(serviceDescriptor.getDescription());
            serviceResourceType.setSubCategory(SubCategoriesMetadataParser.findSubCategoryOnResourceTypeAncestor((ResourceType)serviceResourceType, (String)serviceDescriptor.getSubCategory()));
            serviceResourceType.setCreationDataType(this.convertCreationDataType(serviceDescriptor.getCreationDataType()));
            serviceResourceType.setCreateDeletePolicy(this.convertCreateDeletePolicy(serviceDescriptor.getCreateDeletePolicy()));
            serviceResourceType.setSingleton(serviceDescriptor.isSingleton());
            String pluginPackage = "";
            String discoveryClass = this.getFullyQualifiedComponentClassName(pluginPackage, serviceDescriptor.getDiscovery());
            String componentClass = this.getFullyQualifiedComponentClassName(pluginPackage, serviceDescriptor.getClazz());
        } else {
            throw new InvalidPluginDescriptorException("Both sourcePlugin and sourceType must be defined: " + serviceDescriptor.getName());
        }
        if (parentType == null && (runsInside = serviceDescriptor.getRunsInside()) != null) {
            List parentTypesDescriptor = runsInside.getParentResourceType();
            for (ParentResourceType parentTypeDescriptor : parentTypesDescriptor) {
                ResourceType parentResourceType = new ResourceType(parentTypeDescriptor.getName(), parentTypeDescriptor.getPlugin(), ResourceCategory.SERVER, ResourceType.ANY_PLATFORM_TYPE);
                serviceResourceType.addParentResourceType(parentResourceType);
            }
        }
        return serviceResourceType;
    }

    private void parseResourceDescriptor(ResourceDescriptor resourceDescriptor, ResourceType resourceType, String discoveryClass, String componentClass, String sourcePlugin) throws InvalidPluginDescriptorException {
        if (discoveryClass == null) {
            discoveryClass = this.getFullyQualifiedComponentClassName(this.pluginDescriptor.getPackage(), resourceDescriptor.getDiscovery());
        }
        if (componentClass == null) {
            componentClass = this.getFullyQualifiedComponentClassName(this.pluginDescriptor.getPackage(), resourceDescriptor.getClazz());
        }
        resourceType.setPlugin(this.pluginDescriptor.getName());
        if (resourceDescriptor.getPluginConfiguration() != null) {
            resourceType.setPluginConfigurationDefinition(ConfigurationMetadataParser.parse((String)resourceType.getName(), (ConfigurationDescriptor)resourceDescriptor.getPluginConfiguration()));
        }
        if (resourceDescriptor.getResourceConfiguration() != null) {
            resourceType.setResourceConfigurationDefinition(ConfigurationMetadataParser.parse((String)resourceType.getName(), (ConfigurationDescriptor)resourceDescriptor.getResourceConfiguration()));
        }
        int displayPosition = 1;
        for (MetricDescriptor metricDescriptor : resourceDescriptor.getMetric()) {
            List measurementDefinitions = MetricsMetadataParser.parseMetricsMetadata((MetricDescriptor)metricDescriptor, (ResourceType)resourceType);
            for (MeasurementDefinition measurementDefinition : measurementDefinitions) {
                measurementDefinition.setDisplayOrder(displayPosition++);
                resourceType.addMetricDefinition(measurementDefinition);
            }
        }
        for (OperationDescriptor operationDescriptor : resourceDescriptor.getOperation()) {
            resourceType.addOperationDefinition(OperationsMetadataParser.parseOperationDescriptor((OperationDescriptor)operationDescriptor));
        }
        for (ProcessScanDescriptor processMatch : resourceDescriptor.getProcessScan()) {
            resourceType.addProcessScan(new ProcessScan(processMatch.getQuery(), processMatch.getName()));
        }
        for (ContentDescriptor contentDescriptor : resourceDescriptor.getContent()) {
            resourceType.addPackageType(ContentMetadataParser.parseContentDescriptor((ContentDescriptor)contentDescriptor));
        }
        if (resourceDescriptor.getSubcategories() != null) {
            for (SubCategoryDescriptor subCategoryDescriptor : resourceDescriptor.getSubcategories().getSubcategory()) {
                resourceType.addChildSubCategory(SubCategoriesMetadataParser.getSubCategory((SubCategoryDescriptor)subCategoryDescriptor, (ResourceType)resourceType));
            }
        }
        if (resourceDescriptor.getHelp() != null && !resourceDescriptor.getHelp().getContent().isEmpty()) {
            resourceType.setHelpText(String.valueOf(resourceDescriptor.getHelp().getContent().get(0)));
        }
        if (resourceDescriptor instanceof PlatformDescriptor) {
            for (ServerDescriptor serverDescriptor : ((PlatformDescriptor)resourceDescriptor).getServers()) {
                this.parseServerDescriptor(serverDescriptor, resourceType);
            }
            for (ServiceDescriptor serviceDescriptor : ((PlatformDescriptor)resourceDescriptor).getServices()) {
                this.parseServiceDescriptor(serviceDescriptor, resourceType);
            }
        }
        if (resourceDescriptor instanceof ServerDescriptor) {
            for (ServerDescriptor serverDescriptor : ((ServerDescriptor)resourceDescriptor).getServers()) {
                this.parseServerDescriptor(serverDescriptor, resourceType);
            }
            for (ServiceDescriptor serviceDescriptor : ((ServerDescriptor)resourceDescriptor).getServices()) {
                this.parseServiceDescriptor(serviceDescriptor, resourceType);
            }
        }
        if (resourceDescriptor instanceof ServiceDescriptor) {
            for (ServiceDescriptor serviceDescriptor : ((ServiceDescriptor)resourceDescriptor).getServices()) {
                this.parseServiceDescriptor(serviceDescriptor, resourceType);
            }
        }
        this.resourceTypes.add(resourceType);
    }

    private String getFullyQualifiedComponentClassName(String packageName, String baseClassName) {
        if (baseClassName == null) {
            return null;
        }
        if (baseClassName.indexOf(46) > -1 || packageName == null) {
            return baseClassName;
        }
        return packageName + '.' + baseClassName;
    }

    private ResourceCreationDataType convertCreationDataType(ResourceCreationData creationType) {
        switch (creationType) {
            case CONTENT: {
                return ResourceCreationDataType.CONTENT;
            }
            case CONFIGURATION: {
                return ResourceCreationDataType.CONFIGURATION;
            }
        }
        return null;
    }

    private CreateDeletePolicy convertCreateDeletePolicy(ResourceCreateDeletePolicy policy) {
        switch (policy) {
            case BOTH: {
                return CreateDeletePolicy.BOTH;
            }
            case CREATE_ONLY: {
                return CreateDeletePolicy.CREATE_ONLY;
            }
            case DELETE_ONLY: {
                return CreateDeletePolicy.DELETE_ONLY;
            }
            case NEITHER: {
                return CreateDeletePolicy.NEITHER;
            }
        }
        return null;
    }
}

