/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.tool.plugindoc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.ValidationEventCollector;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.app.event.implement.EscapeXmlReference;
import org.codehaus.swizzle.confluence.Confluence;
import org.codehaus.swizzle.confluence.Page;
import org.codehaus.swizzle.confluence.SwizzleException;
import org.rhq.core.clientapi.agent.metadata.InvalidPluginDescriptorException;
import org.rhq.core.clientapi.descriptor.plugin.PluginDescriptor;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.tool.plugindoc.EscapeConfluenceReference;
import org.rhq.core.tool.plugindoc.PluginDescriptorProcessor;
import org.rhq.core.tool.plugindoc.VelocityTemplateProcessor;

public class PluginDocMojo
extends AbstractMojo {
    private static final String PLUGIN_DESCRIPTOR_PATH = "src/main/resources/META-INF/rhq-plugin.xml";
    private static final String OUTPUT_DIR_PATH = "target/plugindoc";
    private static final String PLUGIN_DESCRIPTOR_JAXB_CONTEXT_PATH = "org.rhq.core.clientapi.descriptor.plugin";
    private static final String CONFLUENCE_TEMPLATE_RESOURCE_PATH = "resource-type-doc-confluence.vm";
    private static final String DOCBOOK_TEMPLATE_RESOURCE_PATH = "resource-type-doc-docbook.vm";
    private static final String CONFLUENCE_MACRO_LIBRARY_RESOURCE_PATH = "confluence-macros.vm";
    private static final String DOCBOOK_MACRO_LIBRARY_RESOURCE_PATH = "docbook-macros.vm";
    private final Log log = LogFactory.getLog(PluginDocMojo.class);
    private MavenProject project;
    private String confluenceUrl;
    private String confluenceSpace;
    private String confluenceParentPageTitle;
    private String confluenceUserName;
    private String confluencePassword;
    private String endpoint;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Set<ResourceType> resourceTypes;
        File pluginXmlFile = new File(this.project.getBasedir(), PLUGIN_DESCRIPTOR_PATH);
        if (!pluginXmlFile.exists()) {
            this.log.info((Object)("'" + pluginXmlFile + "' does not exist - nothing to do."));
            return;
        }
        PluginDescriptor pluginDescriptor = this.parsePluginDescriptor(pluginXmlFile);
        PluginDescriptorProcessor descriptorProcessor = new PluginDescriptorProcessor(pluginDescriptor);
        try {
            resourceTypes = descriptorProcessor.processPluginDescriptor();
        }
        catch (InvalidPluginDescriptorException e) {
            throw new MojoExecutionException("Failed to process plugin descriptor.", (Exception)((Object)e));
        }
        String pluginName = pluginDescriptor.getName();
        File baseOutputDir = new File(this.project.getBasedir().getParentFile(), OUTPUT_DIR_PATH);
        File outputDir = new File(baseOutputDir, pluginName);
        outputDir.mkdirs();
        VelocityTemplateProcessor confluenceTemplateProcessor = new VelocityTemplateProcessor(CONFLUENCE_TEMPLATE_RESOURCE_PATH, CONFLUENCE_MACRO_LIBRARY_RESOURCE_PATH, EscapeConfluenceReference.class);
        VelocityTemplateProcessor docbookTemplateProcessor = new VelocityTemplateProcessor(DOCBOOK_TEMPLATE_RESOURCE_PATH, DOCBOOK_MACRO_LIBRARY_RESOURCE_PATH, EscapeXmlReference.class);
        if (this.confluenceUrl != null) {
            this.log.debug((Object)("Using Confluence URL: " + this.confluenceUrl));
            this.endpoint = this.confluenceUrl + "/rpc/xmlrpc";
        }
        for (ResourceType resourceType : resourceTypes) {
            this.log.info((Object)("Generating plugin doc for '" + resourceType.getName() + "' Resource type..."));
            confluenceTemplateProcessor.getContext().put("resourceType", (Object)resourceType);
            String confluenceOutputFileName = PluginDocMojo.escapeFileName(resourceType.getName() + ".wiki");
            File confluenceOutputFile = new File(outputDir, confluenceOutputFileName);
            confluenceTemplateProcessor.processTemplate(confluenceOutputFile);
            if (this.endpoint != null) {
                this.publishPage(confluenceOutputFile, resourceType);
            }
            docbookTemplateProcessor.getContext().put("resourceType", (Object)resourceType);
            String docbookOutputFileName = PluginDocMojo.escapeFileName(resourceType.getName() + ".xml");
            File docbookOutputFile = new File(outputDir, docbookOutputFileName);
            docbookTemplateProcessor.processTemplate(docbookOutputFile);
        }
    }

    private PluginDescriptor parsePluginDescriptor(File pluginXmlFile) throws MojoExecutionException, MojoFailureException {
        JAXBContext jaxbContext;
        try {
            jaxbContext = JAXBContext.newInstance((String)PLUGIN_DESCRIPTOR_JAXB_CONTEXT_PATH);
        }
        catch (JAXBException e) {
            throw new MojoExecutionException("Failed to instantiate JAXB context for context path 'org.rhq.core.clientapi.descriptor.plugin'.", (Exception)((Object)e));
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(pluginXmlFile);
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            URL pluginSchemaURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("rhq-plugin.xsd");
            Schema pluginSchema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(pluginSchemaURL);
            unmarshaller.setSchema(pluginSchema);
            ValidationEventCollector validationEventCollector = new ValidationEventCollector();
            unmarshaller.setEventHandler((ValidationEventHandler)validationEventCollector);
            PluginDescriptor pluginDescriptor = (PluginDescriptor)unmarshaller.unmarshal((InputStream)is);
            for (ValidationEvent event : validationEventCollector.getEvents()) {
                this.log.debug((Object)("Plugin [" + pluginDescriptor.getName() + "] descriptor messages {Severity: " + event.getSeverity() + ", Message: " + event.getMessage() + ", Exception: " + event.getLinkedException() + "}"));
            }
            PluginDescriptor pluginDescriptor2 = pluginDescriptor;
            return pluginDescriptor2;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not successfully parse plugin descriptor '" + pluginXmlFile + "'.", e);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void publishPage(File contentFile, ResourceType resourceType) throws MojoExecutionException {
        this.log.info((Object)("Publishing plugin doc page for '" + resourceType.getName() + "' Resource type to Confluence..."));
        String title = PluginDocMojo.getPageTitle(resourceType);
        try {
            Page page;
            Confluence confluence = new Confluence(this.endpoint);
            confluence.login(this.confluenceUserName, this.confluencePassword);
            try {
                page = confluence.getPage(this.confluenceSpace, title);
                this.log.warn((Object)("Page with title '" + title + "' already exists - overwriting it..."));
            }
            catch (SwizzleException e) {
                page = new Page(new HashMap());
                page.setSpace(this.confluenceSpace);
                if (this.confluenceParentPageTitle != null) {
                    Page parentPage = confluence.getPage(this.confluenceSpace, this.confluenceParentPageTitle);
                    if (parentPage != null) {
                        page.setParentId(parentPage.getId());
                    } else {
                        this.log.error((Object)("Specified parent page ('" + this.confluenceParentPageTitle + "') does not exist."));
                    }
                }
                page.setTitle(title);
            }
            page.setContent(PluginDocMojo.getContentAsString(contentFile));
            confluence.storePage(page);
            confluence.logout();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to publish plugin doc page to Confluence.", e);
        }
    }

    private static String getPageTitle(ResourceType resourceType) {
        String title = resourceType.getName();
        if (!resourceType.getName().endsWith(resourceType.getCategory().toString())) {
            title = title + " " + resourceType.getCategory();
        }
        return PluginDocMojo.escapePageTitle(title);
    }

    private static String getContentAsString(File contentFile) throws IOException {
        String line;
        StringBuilder content = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(contentFile)));
        while ((line = bufferedReader.readLine()) != null) {
            content.append(line).append("\n");
        }
        bufferedReader.close();
        return content.toString();
    }

    private static String escapeFileName(String fileName) {
        return fileName.replace('/', '-').replace('\\', '-').replace(' ', '_');
    }

    private static String escapePageTitle(String fileName) {
        return fileName.replace('/', '-');
    }
}

