/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.tool.plugindoc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class VelocityTemplateProcessor {
    private VelocityContext context = new VelocityContext();
    private Template template;

    public VelocityTemplateProcessor(String templateResourcePath, String macroLibrary, Class referenceInsertionClass) {
        Properties config = this.createVelocityConfiguration(macroLibrary, referenceInsertionClass);
        try {
            VelocityEngine engine = new VelocityEngine(config);
            this.template = engine.getTemplate(templateResourcePath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Properties createVelocityConfiguration(String macroLibrary, Class referenceInsertionClass) {
        Properties velocityConfig = new Properties();
        velocityConfig.setProperty("resource.loader", "class");
        velocityConfig.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        if (referenceInsertionClass != null) {
            velocityConfig.setProperty("eventhandler.referenceinsertion.class", referenceInsertionClass.getName());
        }
        String macroLibraries = "common-macros.vm";
        if (macroLibrary != null) {
            macroLibraries = macroLibraries + ", " + macroLibrary;
        }
        velocityConfig.setProperty("velocimacro.library", macroLibraries);
        return velocityConfig;
    }

    public VelocityContext getContext() {
        return this.context;
    }

    public void processTemplate(File outputFile) {
        try {
            FileOutputStream outputStream = new FileOutputStream(outputFile);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));
            this.template.merge((Context)this.context, (Writer)writer);
            ((Writer)writer).close();
            ((OutputStream)outputStream).close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

