/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mazz.i18n.Logger;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentShutdownHook
extends Thread {
    private final Logger log = AgentI18NFactory.getLogger(AgentShutdownHook.class);
    private final AgentMain agent;

    public AgentShutdownHook(AgentMain agent) {
        this.agent = agent;
    }

    @Override
    public void run() {
        this.showMessage("AgentShutdownHook.exit.shutting-down", new Object[0]);
        try {
            this.agent.shutdown();
            this.spawnKillThread(300000L);
            int threadsStillAlive = this.waitForNonDaemonThreads();
            if (threadsStillAlive > 0) {
                this.showMessage("AgentShutdownHook.threads-still-alive", threadsStillAlive);
            }
        }
        catch (Throwable t) {
            String errors = ThrowableUtil.getAllMessages((Throwable)t);
            this.log.error(t, "AgentShutdownHook.exit.shutdown-error", new Object[]{errors});
            this.agent.getOut().println(this.agent.getI18NMsg().getMsg("AgentShutdownHook.exit.shutdown-error", new Object[]{errors}));
        }
        this.showMessage("AgentShutdownHook.exit.shutdown-complete", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int waitForNonDaemonThreads() {
        try {
            int countdown = 10;
            HashMap<String, String> threadsStillActive = new HashMap<String, String>();
            threadsStillActive.put("prime-the-pump", "");
            while (threadsStillActive.size() > 0 && countdown-- > 0) {
                threadsStillActive.clear();
                List<Thread> threads = this.interruptAllThreads();
                this.showMessage("AgentShutdownHook.wait", threads.size());
                for (Thread thread : threads) {
                    ByteArrayOutputStream baos;
                    Throwable t;
                    Object var8_8;
                    try {
                        try {
                            thread.join(10000L);
                        }
                        catch (InterruptedException ie) {
                            var8_8 = null;
                            if (!thread.isAlive()) continue;
                            t = new Throwable("Thread [" + thread.getName() + "]");
                            t.setStackTrace(thread.getStackTrace());
                            baos = new ByteArrayOutputStream();
                            t.printStackTrace(new PrintStream(baos));
                            threadsStillActive.put(thread.getName(), baos.toString());
                            this.logDebugMessage("AgentShutdownHook.thread-is-still-active", thread.getName(), baos.toString());
                            continue;
                        }
                        var8_8 = null;
                        if (!thread.isAlive()) continue;
                        t = new Throwable("Thread [" + thread.getName() + "]");
                        t.setStackTrace(thread.getStackTrace());
                        baos = new ByteArrayOutputStream();
                        t.printStackTrace(new PrintStream(baos));
                        threadsStillActive.put(thread.getName(), baos.toString());
                    }
                    catch (Throwable throwable) {
                        var8_8 = null;
                        if (thread.isAlive()) {
                            t = new Throwable("Thread [" + thread.getName() + "]");
                            t.setStackTrace(thread.getStackTrace());
                            baos = new ByteArrayOutputStream();
                            t.printStackTrace(new PrintStream(baos));
                            threadsStillActive.put(thread.getName(), baos.toString());
                            this.logDebugMessage("AgentShutdownHook.thread-is-still-active", thread.getName(), baos.toString());
                        }
                        throw throwable;
                    }
                    this.logDebugMessage("AgentShutdownHook.thread-is-still-active", thread.getName(), baos.toString());
                }
            }
            if (threadsStillActive.size() > 0) {
                this.showMessage("AgentShutdownHook.no-more-wait", threadsStillActive.size());
            }
            return threadsStillActive.size();
        }
        catch (Throwable t) {
            this.showMessage("AgentShutdownHook.cannot-wait", ThrowableUtil.getAllMessages((Throwable)t));
            return Thread.activeCount();
        }
    }

    public List<Thread> interruptAllThreads() {
        ArrayList<Thread> nonDaemonThreads = new ArrayList<Thread>();
        try {
            String currentThreadName = Thread.currentThread().getName();
            int threadCount = Thread.activeCount();
            Thread[] threads = new Thread[threadCount + 50];
            Thread.enumerate(threads);
            for (Thread thread : threads) {
                if (thread == null) continue;
                StackTraceElement[] threadStackTrace = thread.getStackTrace();
                String threadName = thread.getName();
                if (threadStackTrace == null || threadStackTrace.length <= 0 || currentThreadName.equals(threadName)) continue;
                if (!"RHQ Agent Prompt Input Thread".equals(threadName) && !thread.isDaemon()) {
                    nonDaemonThreads.add(thread);
                }
                thread.interrupt();
            }
        }
        catch (Exception e) {
            this.showMessage("AgentShutdownHook.cannot-int", ThrowableUtil.getAllMessages((Throwable)e));
        }
        return nonDaemonThreads;
    }

    public void spawnKillThread(final long doomsday) {
        Runnable killRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Thread.sleep(doomsday);
                }
                catch (Throwable throwable) {
                }
                finally {
                    System.exit(0);
                }
            }
        };
        Thread killThread = new Thread(killRunnable, "RHQ Agent Kill Thread");
        killThread.setDaemon(true);
        killThread.start();
    }

    private void showMessage(String msg, Object ... args) {
        try {
            this.log.info(msg, args);
            this.agent.getOut().println(this.agent.getI18NMsg().getMsg(msg, args));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void logDebugMessage(String msg, Object ... args) {
        try {
            this.log.debug(msg, args);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

