/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.util.Date;
import java.util.List;
import mazz.i18n.Msg;
import org.rhq.core.domain.discovery.AvailabilityReport;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.AgentPrintWriter;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;

public class AvailabilityPromptCommand
implements AgentPromptCommand {
    private static final Msg MSG = AgentI18NFactory.getMsg();

    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.availability", new Object[0]);
    }

    public boolean execute(AgentMain agent, String[] args) {
        String[] realArgs = new String[args.length - 1];
        System.arraycopy(args, 1, realArgs, 0, args.length - 1);
        this.processCommand(realArgs, agent);
        return true;
    }

    public String getSyntax() {
        return MSG.getMsg("PromptCommand.availability.syntax", new Object[0]);
    }

    public String getHelp() {
        return MSG.getMsg("PromptCommand.availability.help", new Object[0]);
    }

    public String getDetailedHelp() {
        return MSG.getMsg("PromptCommand.availability.detailed-help", new Object[0]);
    }

    private void processCommand(String[] args, AgentMain agent) {
        int code;
        AgentPrintWriter out = agent.getOut();
        boolean changedOnly = false;
        boolean verbose = false;
        String sopts = "-cv";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("changed", 0, null, 99), new LongOpt("verbose", 0, null, 118)};
        Getopt getopt = new Getopt(this.getPromptCommandString(), args, sopts, lopts);
        while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 1: 
                case 58: 
                case 63: {
                    out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
                    return;
                }
                case 99: {
                    changedOnly = true;
                    break;
                }
                case 118: {
                    verbose = true;
                }
            }
        }
        if (getopt.getOptind() < args.length) {
            out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
            return;
        }
        PluginContainer pc = PluginContainer.getInstance();
        if (!agent.isStarted() || !pc.isStarted()) {
            out.println(MSG.getMsg("PromptCommand.availability.must-be-started", new Object[0]));
            return;
        }
        InventoryManager inventoryManager = pc.getInventoryManager();
        AvailabilityReport report = inventoryManager.executeAvailabilityScanImmediately(changedOnly);
        if (report == null) {
            out.println(MSG.getMsg("PromptCommand.availability.no-committed-inventory", new Object[0]));
            return;
        }
        List availabilities = report.getResourceAvailability();
        out.println(MSG.getMsg("PromptCommand.availability.report-header", new Object[]{new Date(), availabilities.size(), report.isChangesOnlyReport()}));
        for (Availability availability : availabilities) {
            if (verbose) {
                out.println(MSG.getMsg("PromptCommand.availability.report-resource-verbose", new Object[]{availability.getAvailabilityType(), availability.getResource().getName(), availability.getResource().getId(), availability.getResource().getResourceKey()}));
                continue;
            }
            out.println(MSG.getMsg("PromptCommand.availability.report-resource", new Object[]{availability.getAvailabilityType(), availability.getResource().getName()}));
        }
        out.println(MSG.getMsg("PromptCommand.availability.sending", new Object[0]));
        inventoryManager.handleReport(report);
        out.println(MSG.getMsg("PromptCommand.availability.sent", new Object[0]));
    }
}

