/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import java.util.Map;
import java.util.TreeMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import mazz.i18n.Msg;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;

public class GetConfigPromptCommand
implements AgentPromptCommand {
    private static final Msg MSG = AgentI18NFactory.getMsg();

    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.getconfig", new Object[0]);
    }

    public boolean execute(AgentMain agent, String[] args) {
        Preferences preferences = agent.getConfiguration().getPreferences();
        if (args.length == 1) {
            try {
                TreeMap<String, String> sortedMap = new TreeMap<String, String>();
                String[] keys = preferences.keys();
                for (int i = 0; i < keys.length; ++i) {
                    sortedMap.put(keys[i], preferences.get(keys[i], MSG.getMsg("PromptCommand.getconfig.unknown-value", new Object[0])));
                }
                for (Map.Entry entry : sortedMap.entrySet()) {
                    agent.getOut().println((String)entry.getKey() + "=" + (String)entry.getValue());
                }
            }
            catch (BackingStoreException e) {
                agent.getOut().println(MSG.getMsg("PromptCommand.getconfig.cannot-get", new Object[]{e}));
            }
        } else {
            for (int i = 1; i < args.length; ++i) {
                String prop = args[i];
                String prop_value = preferences.get(prop, MSG.getMsg("PromptCommand.getconfig.unknown-value", new Object[0]));
                agent.getOut().println(prop + "=" + prop_value);
            }
        }
        return true;
    }

    public String getSyntax() {
        return MSG.getMsg("PromptCommand.getconfig.syntax", new Object[0]);
    }

    public String getHelp() {
        return MSG.getMsg("PromptCommand.getconfig.help", new Object[0]);
    }

    public String getDetailedHelp() {
        return MSG.getMsg("PromptCommand.getconfig.detailed-help", new Object[0]);
    }
}

