/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import mazz.i18n.Logger;
import mazz.i18n.LoggerLocale;
import mazz.i18n.Msg;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;

public class LogPromptCommand
implements AgentPromptCommand {
    private static final Msg MSG = AgentI18NFactory.getMsg();

    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.log", new Object[0]);
    }

    public boolean execute(AgentMain agent, String[] args) {
        boolean show_current_settings = false;
        try {
            if (args.length == 1) {
                show_current_settings = true;
            } else if (args.length != 3) {
                agent.getOut().println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
            } else {
                String subcommand = args[1];
                String subcommand_arg = args[2];
                if (subcommand.equals(MSG.getMsg("PromptCommand.log.locale", new Object[0]))) {
                    LoggerLocale.setLogLocale((String)subcommand_arg);
                    show_current_settings = true;
                } else if (subcommand.equals(MSG.getMsg("PromptCommand.log.dumpstacks", new Object[0]))) {
                    boolean flag = subcommand_arg.equalsIgnoreCase(MSG.getMsg("PromptCommand.log.true", new Object[0]));
                    Logger.setDumpStackTraces((boolean)flag);
                    show_current_settings = true;
                } else if (subcommand.equals(MSG.getMsg("PromptCommand.log.dumpkeys", new Object[0]))) {
                    boolean flag = subcommand_arg.equalsIgnoreCase(MSG.getMsg("PromptCommand.log.true", new Object[0]));
                    Logger.setDumpLogKeys((boolean)flag);
                    show_current_settings = true;
                } else {
                    agent.getOut().println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
                }
            }
        }
        catch (Exception e) {
            agent.getOut().println(MSG.getMsg("PromptCommand.log.failure", new Object[0]));
            e.printStackTrace(agent.getOut());
        }
        if (show_current_settings) {
            agent.getOut().println(MSG.getMsg("PromptCommand.log.show-current-settings", new Object[]{LoggerLocale.getLogLocale(), Logger.getDumpStackTraces(), Logger.getDumpLogKeys()}));
        }
        return true;
    }

    public String getSyntax() {
        return MSG.getMsg("PromptCommand.log.syntax", new Object[0]);
    }

    public String getHelp() {
        return MSG.getMsg("PromptCommand.log.help", new Object[0]);
    }

    public String getDetailedHelp() {
        return MSG.getMsg("PromptCommand.log.detailed-help", new Object[0]);
    }
}

