/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import java.io.Serializable;
import mazz.i18n.Msg;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;
import org.rhq.enterprise.agent.promptcmd.Callback;
import org.rhq.enterprise.communications.Ping;
import org.rhq.enterprise.communications.command.client.ClientCommandSender;
import org.rhq.enterprise.communications.command.client.ClientRemotePojoFactory;
import org.rhq.enterprise.communications.command.client.CommandResponseCallback;

public class PingPromptCommand
implements AgentPromptCommand,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Msg MSG = AgentI18NFactory.getMsg();

    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.ping", new Object[0]);
    }

    public boolean execute(AgentMain agent, String[] args) {
        ClientCommandSender sender;
        int numberOfTimes = this.getTestBlastCount(agent);
        ClientRemotePojoFactory.GuaranteedDelivery guaranteed = ClientRemotePojoFactory.GuaranteedDelivery.NO;
        if (args.length > 1) {
            if (args.length > 2 || !args[1].equals(MSG.getMsg("PromptCommand.ping.guaranteed", new Object[0]))) {
                agent.getOut().println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
                return true;
            }
            if (numberOfTimes == 1) {
                agent.getOut().println(MSG.getMsg("PromptCommand.ping.guaranteed-for-async-only", new Object[0]));
            }
            guaranteed = ClientRemotePojoFactory.GuaranteedDelivery.YES;
        }
        if ((sender = agent.getClientCommandSender()) != null) {
            if (numberOfTimes == 1) {
                Ping ping = (Ping)sender.getClientRemotePojoFactory().getRemotePojo(Ping.class);
                agent.getOut().println(MSG.getMsg("PromptCommand.ping.pinging", new Object[0]));
                String ping_results = ping.ping("PING", "Ack: ");
                agent.getOut().println(MSG.getMsg("PromptCommand.ping.ping-results", new Object[]{ping_results}));
            } else {
                ClientRemotePojoFactory factory = sender.getClientRemotePojoFactory();
                factory.setDeliveryGuaranteed(guaranteed);
                factory.setAsynch(true, (CommandResponseCallback)new Callback(agent));
                Ping ping = (Ping)factory.getRemotePojo(Ping.class);
                for (int i = 0; i < numberOfTimes; ++i) {
                    agent.getOut().println(MSG.getMsg("PromptCommand.ping.async-ping", new Object[]{i, guaranteed}));
                    ping.ping("PING", "Ack #" + i + (ClientRemotePojoFactory.GuaranteedDelivery.YES == guaranteed ? " (" + MSG.getMsg("PromptCommand.ping.guaranteed", new Object[0]) + ")" : "") + ": ");
                }
            }
        } else {
            agent.getOut().println(MSG.getMsg("PromptCommand.ping.not-started", new Object[0]));
        }
        return true;
    }

    public String getSyntax() {
        return MSG.getMsg("PromptCommand.ping.syntax", new Object[0]);
    }

    public String getHelp() {
        return MSG.getMsg("PromptCommand.ping.help", new Object[0]);
    }

    public String getDetailedHelp() {
        return MSG.getMsg("PromptCommand.ping.detailed-help", new Object[0]);
    }

    private int getTestBlastCount(AgentMain agent) {
        int value = agent.getConfiguration().getPreferences().getInt("rhq.agent.test.blast-count", 1);
        return value;
    }
}

