/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import mazz.i18n.Msg;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.AgentPrintWriter;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;

public class SleepPromptCommand
implements AgentPromptCommand {
    private static final Msg MSG = AgentI18NFactory.getMsg();

    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.sleep", new Object[0]);
    }

    public boolean execute(AgentMain agent, String[] args) {
        AgentPrintWriter out = agent.getOut();
        if (args.length != 2) {
            out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
            return true;
        }
        out.println(MSG.getMsg("PromptCommand.sleep.sleeping", new Object[0]));
        try {
            long seconds = Long.parseLong(args[1]);
            Thread.sleep(seconds * 1000L);
        }
        catch (Exception e) {
            out.println(MSG.getMsg("PromptCommand.sleep.sleeping-error", new Object[]{e.toString()}));
        }
        out.println(MSG.getMsg("PromptCommand.sleep.sleeping-done", new Object[0]));
        return true;
    }

    public String getSyntax() {
        return MSG.getMsg("PromptCommand.sleep.syntax", new Object[0]);
    }

    public String getHelp() {
        return MSG.getMsg("PromptCommand.sleep.help", new Object[0]);
    }

    public String getDetailedHelp() {
        return MSG.getMsg("PromptCommand.sleep.detailed-help", new Object[0]);
    }
}

