/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.net.URL;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import mazz.i18n.Msg;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.AgentPrintWriter;
import org.rhq.enterprise.agent.AgentUpdateDownload;
import org.rhq.enterprise.agent.AgentUpdateInformation;
import org.rhq.enterprise.agent.AgentUpdateThread;
import org.rhq.enterprise.agent.AgentUpdateVersion;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;

public class UpdatePromptCommand
implements AgentPromptCommand {
    private static final Msg MSG = AgentI18NFactory.getMsg();

    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.update", new Object[0]);
    }

    public boolean execute(AgentMain agent, String[] args) {
        this.processArguments(agent, args);
        return true;
    }

    public String getSyntax() {
        return MSG.getMsg("PromptCommand.update.syntax", new Object[0]);
    }

    public String getHelp() {
        return MSG.getMsg("PromptCommand.update.help", new Object[0]);
    }

    public String getDetailedHelp() {
        return MSG.getMsg("PromptCommand.update.detailed-help", new Object[0]);
    }

    private void processArguments(AgentMain agent, String[] args) {
        int code;
        AgentPrintWriter out = agent.getOut();
        if (args.length <= 1) {
            out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
            return;
        }
        String sopts = "vudeos";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("version", 0, null, 118), new LongOpt("update", 0, null, 117), new LongOpt("disable", 0, null, 100), new LongOpt("enable", 0, null, 101), new LongOpt("download", 0, null, 111), new LongOpt("status", 0, null, 115)};
        Getopt getopt = new Getopt(this.getPromptCommandString(), args, sopts, lopts);
        while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 1: 
                case 58: 
                case 63: {
                    out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
                    break;
                }
                case 117: {
                    AgentUpdateThread.updateAgentNow(agent, true);
                    break;
                }
                case 118: {
                    URL url = null;
                    try {
                        AgentUpdateVersion check = new AgentUpdateVersion(agent);
                        url = check.getVersionUrl();
                        AgentUpdateInformation info = check.getAgentUpdateInformation();
                        out.println(MSG.getMsg("PromptCommand.update.check-info", new Object[]{url, info.getUpdateVersion(), info.getUpdateBuild(), info.getAgentVersion(), info.getAgentBuild()}));
                        if (info.isAgentOutOfDate()) {
                            out.println(MSG.getMsg("PromptCommand.update.check-ood", new Object[0]));
                            break;
                        }
                        if (info.isAgentOutOfDateStrict()) {
                            out.println(MSG.getMsg("PromptCommand.update.check-ood-strict", new Object[0]));
                            break;
                        }
                        out.println(MSG.getMsg("PromptCommand.update.check-not-ood", new Object[0]));
                    }
                    catch (Exception e) {
                        out.println(MSG.getMsg("PromptCommand.update.check-failed", new Object[]{url, e}));
                    }
                    break;
                }
                case 100: {
                    Preferences prefs = agent.getConfiguration().getPreferences();
                    String prefName = "rhq.agent.agent-update.enabled";
                    boolean prefValue = false;
                    prefs.putBoolean(prefName, prefValue);
                    try {
                        prefs.flush();
                    }
                    catch (BackingStoreException e) {
                        out.println(MSG.getMsg("AgentConfiguration.cannot-store-preferences", new Object[]{prefName, prefValue}));
                    }
                    out.println(MSG.getMsg("PromptCommand.update.disabled", new Object[0]));
                    break;
                }
                case 101: {
                    Preferences prefs = agent.getConfiguration().getPreferences();
                    String prefName = "rhq.agent.agent-update.enabled";
                    boolean prefValue = true;
                    prefs.putBoolean(prefName, prefValue);
                    try {
                        prefs.flush();
                    }
                    catch (BackingStoreException e) {
                        out.println(MSG.getMsg("AgentConfiguration.cannot-store-preferences", new Object[]{prefName, prefValue}));
                    }
                    out.println(MSG.getMsg("PromptCommand.update.enabled", new Object[0]));
                    break;
                }
                case 111: {
                    try {
                        AgentUpdateDownload aud = new AgentUpdateDownload(agent);
                        aud.download();
                        aud.validate();
                        out.println(MSG.getMsg("PromptCommand.update.downloaded", new Object[]{aud.getAgentUpdateBinaryFile()}));
                    }
                    catch (Exception e) {
                        out.println(MSG.getMsg("PromptCommand.update.download-failed", new Object[]{ThrowableUtil.getAllMessages((Throwable)e)}));
                    }
                    break;
                }
                case 115: {
                    if (agent.getConfiguration().isAgentUpdateEnabled()) {
                        out.println(MSG.getMsg("PromptCommand.update.enabled", new Object[0]));
                        break;
                    }
                    out.println(MSG.getMsg("PromptCommand.update.disabled", new Object[0]));
                }
            }
        }
        if (getopt.getOptind() + 1 < args.length) {
            out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
        }
    }
}

