/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent;

import java.io.FileReader;
import java.io.IOException;
import org.rhq.core.system.SystemInfo;
import org.rhq.core.system.SystemInfoFactory;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.JavaAgentInputReader;

public class SigarAgentInputReader
extends JavaAgentInputReader {
    private final AgentMain agent;

    public SigarAgentInputReader(AgentMain agent) throws IOException {
        this.agent = agent;
    }

    public SigarAgentInputReader(AgentMain agent, FileReader fr) throws IOException {
        super(fr);
        this.agent = agent;
    }

    public String readLine() throws IOException {
        SystemInfo systemInfo = SystemInfoFactory.createSystemInfo();
        String input = systemInfo == null || !systemInfo.isNative() || !this.isConsole() ? super.readLine() : systemInfo.readLineFromConsole(false);
        return input;
    }

    public String readLineNoEcho() throws IOException {
        String input = null;
        SystemInfo systemInfo = SystemInfoFactory.createSystemInfo();
        if (systemInfo == null || !systemInfo.isNative() || !this.isConsole()) {
            input = super.readLine();
        } else {
            while (true) {
                input = systemInfo.readLineFromConsole(true);
                systemInfo.writeLineToConsole(this.agent.getI18NMsg().getMsg("AgentNativePromptInfo.prompt-confirm", new Object[0]));
                String confirmation = systemInfo.readLineFromConsole(true);
                systemInfo.writeLineToConsole("\n");
                if (input.equals(confirmation)) break;
                systemInfo.writeLineToConsole(this.agent.getI18NMsg().getMsg("AgentNativePromptInfo.prompt-confirm-failed", new Object[0]));
            }
        }
        return input;
    }
}

