/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import mazz.i18n.Msg;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;
import org.rhq.enterprise.communications.command.Command;
import org.rhq.enterprise.communications.command.CommandResponse;
import org.rhq.enterprise.communications.command.client.CmdlineClient;
import org.rhq.enterprise.communications.command.client.CommandResponseCallback;

public class ServerAsyncCommandPromptCommand
implements AgentPromptCommand {
    private static final Msg MSG = AgentI18NFactory.getMsg();

    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.serverasync", new Object[0]);
    }

    public boolean execute(AgentMain agent, String[] args) {
        try {
            String[] remoteCmdArgs = new String[args.length - 1];
            System.arraycopy(args, 1, remoteCmdArgs, 0, remoteCmdArgs.length);
            CmdlineClient client = new CmdlineClient();
            Command command = client.buildCommand(remoteCmdArgs);
            int blast_count = this.getTestBlastCount(agent);
            for (int i = 0; i < blast_count; ++i) {
                agent.getClientCommandSender().sendAsynch(command, (CommandResponseCallback)new Callback(agent));
                agent.getOut().println(MSG.getMsg("PromptCommand.serverasync.queued", new Object[]{i}));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(MSG.getMsg("PromptCommand.serverasync.failure", new Object[0]), e);
        }
        return true;
    }

    public String getSyntax() {
        return MSG.getMsg("PromptCommand.serverasync.syntax", new Object[0]);
    }

    public String getHelp() {
        return MSG.getMsg("PromptCommand.serverasync.help", new Object[0]);
    }

    public String getDetailedHelp() {
        return MSG.getMsg("PromptCommand.serverasync.detailed-help", new Object[]{new CmdlineClient().getUsage()});
    }

    private int getTestBlastCount(AgentMain agent) {
        int value = agent.getConfiguration().getPreferences().getInt("rhq.agent.test.blast-count", 1);
        return value;
    }

    private class Callback
    implements CommandResponseCallback {
        private static final long serialVersionUID = 1L;
        private transient AgentMain m_agent;

        public Callback(AgentMain agent) {
            this.m_agent = agent;
        }

        public void commandSent(CommandResponse response) {
            if (this.m_agent != null) {
                this.m_agent.getOut().println(MSG.getMsg("PromptCommand.serverasync.finished", new Object[]{response}));
            } else {
                System.out.println(MSG.getMsg("PromptCommand.serverasync.recovered", new Object[]{response}));
            }
        }
    }
}

