/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.LogManager;
import java.util.prefs.Preferences;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import mazz.i18n.Logger;
import mazz.i18n.Msg;
import org.apache.log4j.Level;
import org.apache.log4j.xml.DOMConfigurator;
import org.jboss.remoting.invocation.NameBasedInvocation;
import org.jboss.remoting.security.SSLSocketBuilder;
import org.rhq.core.clientapi.server.bundle.BundleServerService;
import org.rhq.core.clientapi.server.configuration.ConfigurationServerService;
import org.rhq.core.clientapi.server.content.ContentServerService;
import org.rhq.core.clientapi.server.core.AgentNotSupportedException;
import org.rhq.core.clientapi.server.core.AgentRegistrationException;
import org.rhq.core.clientapi.server.core.AgentRegistrationRequest;
import org.rhq.core.clientapi.server.core.AgentRegistrationResults;
import org.rhq.core.clientapi.server.core.AgentVersion;
import org.rhq.core.clientapi.server.core.ConnectAgentRequest;
import org.rhq.core.clientapi.server.core.ConnectAgentResults;
import org.rhq.core.clientapi.server.core.CoreServerService;
import org.rhq.core.clientapi.server.core.PingRequest;
import org.rhq.core.clientapi.server.discovery.DiscoveryServerService;
import org.rhq.core.clientapi.server.drift.DriftServerService;
import org.rhq.core.clientapi.server.event.EventServerService;
import org.rhq.core.clientapi.server.inventory.ResourceFactoryServerService;
import org.rhq.core.clientapi.server.measurement.MeasurementServerService;
import org.rhq.core.clientapi.server.operation.OperationServerService;
import org.rhq.core.domain.cloud.composite.FailoverListComposite;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.PluginContainerConfiguration;
import org.rhq.core.pc.RebootRequestListener;
import org.rhq.core.pc.ServerServices;
import org.rhq.core.pc.agent.AgentRegistrar;
import org.rhq.core.pc.agent.AgentServiceLifecycleListener;
import org.rhq.core.pc.agent.AgentServiceStreamRemoter;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pc.plugin.FileSystemPluginFinder;
import org.rhq.core.pc.plugin.PluginFinder;
import org.rhq.core.pc.util.LoggingThreadFactory;
import org.rhq.core.system.SystemInfoFactory;
import org.rhq.core.util.ObjectNameFactory;
import org.rhq.core.util.StringPropertyReplacer;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.agent.AgentAutoDiscoveryListener;
import org.rhq.enterprise.agent.AgentConfiguration;
import org.rhq.enterprise.agent.AgentConfigurationUpgrade;
import org.rhq.enterprise.agent.AgentInputReader;
import org.rhq.enterprise.agent.AgentInputReaderFactory;
import org.rhq.enterprise.agent.AgentManagement;
import org.rhq.enterprise.agent.AgentManagementMBean;
import org.rhq.enterprise.agent.AgentPrintWriter;
import org.rhq.enterprise.agent.AgentPromptInfo;
import org.rhq.enterprise.agent.AgentRegistrarImpl;
import org.rhq.enterprise.agent.AgentRestartCounter;
import org.rhq.enterprise.agent.AgentServiceRemoter;
import org.rhq.enterprise.agent.AgentShutdownHook;
import org.rhq.enterprise.agent.AgentUpdateThread;
import org.rhq.enterprise.agent.AgentUtils;
import org.rhq.enterprise.agent.ConnectAgentInitializeCallback;
import org.rhq.enterprise.agent.FailoverFailureCallback;
import org.rhq.enterprise.agent.PluginUpdate;
import org.rhq.enterprise.agent.PrimaryServerSwitchoverThread;
import org.rhq.enterprise.agent.SecurityTokenCommandPreprocessor;
import org.rhq.enterprise.agent.TimerPromptCommand;
import org.rhq.enterprise.agent.VMHealthCheckThread;
import org.rhq.enterprise.agent.Version;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;
import org.rhq.enterprise.agent.promptcmd.AvailabilityPromptCommand;
import org.rhq.enterprise.agent.promptcmd.ConfigPromptCommand;
import org.rhq.enterprise.agent.promptcmd.DebugPromptCommand;
import org.rhq.enterprise.agent.promptcmd.DiscoveryPromptCommand;
import org.rhq.enterprise.agent.promptcmd.DownloadPromptCommand;
import org.rhq.enterprise.agent.promptcmd.DumpSpoolPromptCommand;
import org.rhq.enterprise.agent.promptcmd.ExitPromptCommand;
import org.rhq.enterprise.agent.promptcmd.FailoverPromptCommand;
import org.rhq.enterprise.agent.promptcmd.GCPromptCommand;
import org.rhq.enterprise.agent.promptcmd.GetConfigPromptCommand;
import org.rhq.enterprise.agent.promptcmd.HelpPromptCommand;
import org.rhq.enterprise.agent.promptcmd.IdentifyPromptCommand;
import org.rhq.enterprise.agent.promptcmd.InventoryPromptCommand;
import org.rhq.enterprise.agent.promptcmd.ListDataPromptCommand;
import org.rhq.enterprise.agent.promptcmd.LogPromptCommand;
import org.rhq.enterprise.agent.promptcmd.MetricsPromptCommand;
import org.rhq.enterprise.agent.promptcmd.NativePromptCommand;
import org.rhq.enterprise.agent.promptcmd.PingPromptCommand;
import org.rhq.enterprise.agent.promptcmd.PiqlPromptCommand;
import org.rhq.enterprise.agent.promptcmd.PluginContainerPromptCommand;
import org.rhq.enterprise.agent.promptcmd.PluginsPromptCommand;
import org.rhq.enterprise.agent.promptcmd.RegisterPromptCommand;
import org.rhq.enterprise.agent.promptcmd.SchedulesPromptCommand;
import org.rhq.enterprise.agent.promptcmd.SenderPromptCommand;
import org.rhq.enterprise.agent.promptcmd.SetConfigPromptCommand;
import org.rhq.enterprise.agent.promptcmd.SetupPromptCommand;
import org.rhq.enterprise.agent.promptcmd.ShutdownPromptCommand;
import org.rhq.enterprise.agent.promptcmd.SleepPromptCommand;
import org.rhq.enterprise.agent.promptcmd.StartPromptCommand;
import org.rhq.enterprise.agent.promptcmd.UpdatePromptCommand;
import org.rhq.enterprise.agent.promptcmd.VersionPromptCommand;
import org.rhq.enterprise.agent.promptcmd.aliases.QuitPromptCommand;
import org.rhq.enterprise.communications.Ping;
import org.rhq.enterprise.communications.ServiceContainer;
import org.rhq.enterprise.communications.ServiceContainerConfiguration;
import org.rhq.enterprise.communications.ServiceContainerSenderCreationListener;
import org.rhq.enterprise.communications.command.Command;
import org.rhq.enterprise.communications.command.CommandResponse;
import org.rhq.enterprise.communications.command.client.ClientCommandSender;
import org.rhq.enterprise.communications.command.client.ClientCommandSenderConfiguration;
import org.rhq.enterprise.communications.command.client.ClientCommandSenderStateListener;
import org.rhq.enterprise.communications.command.client.ClientRemotePojoFactory;
import org.rhq.enterprise.communications.command.client.CommandPreprocessor;
import org.rhq.enterprise.communications.command.client.FailureCallback;
import org.rhq.enterprise.communications.command.client.InitializeCallback;
import org.rhq.enterprise.communications.command.client.JBossRemotingRemoteCommunicator;
import org.rhq.enterprise.communications.command.client.OutgoingCommandTrace;
import org.rhq.enterprise.communications.command.client.RemoteCommunicator;
import org.rhq.enterprise.communications.command.impl.remotepojo.RemotePojoInvocationCommand;
import org.rhq.enterprise.communications.command.server.CommandListener;
import org.rhq.enterprise.communications.command.server.IncomingCommandTrace;
import org.rhq.enterprise.communications.command.server.discovery.AutoDiscoveryListener;
import org.rhq.enterprise.communications.util.CommandTraceUtil;
import org.rhq.enterprise.communications.util.SecurityUtil;

public class AgentMain {
    private static final Logger LOG = AgentI18NFactory.getLogger(AgentMain.class);
    private static final Msg MSG = AgentI18NFactory.getMsg();
    private static final String PROMPT_SHUTDOWN = MSG.getMsg("AgentMain.prompt-string.shutdown", new Object[0]) + "> ";
    private static final String PROMPT_STARTED = MSG.getMsg("AgentMain.prompt-string.started", new Object[0]) + "> ";
    private static final String PROMPT_SENDING = MSG.getMsg("AgentMain.prompt-string.sending", new Object[0]) + "> ";
    private static final String PROMPT_TINY = "> ";
    private static final String FILENAME_SERVER_FAILOVER_LIST = "failover-list.dat";
    private static final String JAVA_UTIL_LOGGING_PROPERTIES_RESOURCE_PATH = "java.util.logging.properties";
    private static final String PING_THREAD_POOL_NAME = "RHQ Agent Ping Thread";
    private static final int PING_THREAD_POOL_CORE_POOL_SIZE = 1;
    private static final long PING_INTERVAL_MINIMUM = 60000L;
    static final String PROMPT_INPUT_THREAD_NAME = "RHQ Agent Prompt Input Thread";
    private String m_agentHomeDirectory;
    private String[] m_commandLineArgs;
    private boolean m_daemonMode;
    private AgentInputReader m_input;
    private boolean m_stdinInput;
    private AgentPrintWriter m_output;
    private AgentConfiguration m_configuration;
    private String m_agentPreferencesNodeName;
    private ServiceContainer m_commServices;
    private ClientCommandSender m_clientSender;
    private boolean[] m_started;
    private long m_startTime = 0L;
    private Map<String, Class<? extends AgentPromptCommand>> m_promptCommands;
    private Thread m_shutdownHook;
    private Thread m_inputLoopThread;
    private AgentAutoDiscoveryListener m_autoDiscoveryListener;
    private LinkedList<Runnable> m_previouslyQueueCommands;
    private boolean m_advancedSetup = false;
    private boolean m_forcedSetup = false;
    private boolean m_startAtBoot = true;
    private Thread[] m_registrationThread = new Thread[1];
    private AgentRegistrationResults m_registration;
    private AgentManagement m_managementMBean;
    private FailoverListComposite m_serverFailoverList;
    private long[] m_lastFailoverTime = new long[]{0L};
    private PrimaryServerSwitchoverThread m_primaryServerSwitchoverThread;
    private LastSentConnectAgent m_lastSentConnectAgent = new LastSentConnectAgent();
    private long m_agentServerClockDifference = 0L;
    private VMHealthCheckThread m_vmHealthCheckThread;
    private final AgentRestartCounter m_agentRestartCounter = new AgentRestartCounter();
    private boolean m_disableNativeSystem;
    private ScheduledThreadPoolExecutor m_pingThreadPoolExecutor;
    private boolean m_loggedNativeSystemInfoUnavailableWarning;

    public static void main(String[] args) {
        AgentMain.reconfigureJavaLogging();
        AgentMain agent = null;
        int retries = 0;
        int MAX_RETRIES = 5;
        while (retries++ < 5) {
            try {
                agent = new AgentMain(args);
                String productNameAndVersion = Version.getProductNameAndVersion();
                String buildNumber = Version.getBuildNumber();
                Date buildDate = Version.getBuildDate();
                agent.getOut().println(productNameAndVersion + " [" + buildNumber + "] (" + buildDate + ")");
                LOG.info("AgentMain.identify-version", new Object[]{productNameAndVersion, buildNumber, buildDate});
                if (agent.m_forcedSetup || !agent.m_daemonMode && !agent.m_configuration.isAgentConfigurationSetup()) {
                    SetupPromptCommand setup_cmd = new SetupPromptCommand();
                    AgentPromptInfo in = new AgentPromptInfo(agent);
                    AgentPrintWriter out = agent.getOut();
                    Preferences prefs = agent.m_configuration.getPreferences();
                    if (agent.m_advancedSetup) {
                        setup_cmd.performAdvancedSetup(prefs, in, out);
                    } else {
                        setup_cmd.performBasicSetup(prefs, in, out);
                    }
                }
                if (agent.m_startAtBoot) {
                    agent.start();
                    agent.m_agentRestartCounter.restartedAgent(AgentRestartCounter.AgentRestartReason.PROCESS_START);
                } else {
                    agent.inputLoop();
                }
                retries = 5;
            }
            catch (HelpException he) {
                retries = 5;
            }
            catch (AgentNotSupportedException anse) {
                LOG.fatal((Throwable)anse, "AgentMain.start-failure", new Object[0]);
                agent.getOut().println(MSG.getMsg("AgentMain.start-failure", new Object[0]));
                anse.printStackTrace((PrintWriter)agent.getOut());
                retries = 5;
            }
            catch (Exception e) {
                LOG.fatal((Throwable)e, "AgentMain.start-failure", new Object[0]);
                if (agent != null) {
                    agent.getOut().println(MSG.getMsg("AgentMain.start-failure", new Object[0]));
                    e.printStackTrace(agent.getOut());
                    if (retries < 5) {
                        LOG.error("AgentMain.start-retry-after-failure", new Object[0]);
                        agent.getOut().println(MSG.getMsg("AgentMain.start-retry-after-failure", new Object[0]));
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (InterruptedException e1) {}
                    }
                } else {
                    System.err.println(MSG.getMsg("AgentMain.start-failure", new Object[0]));
                    e.printStackTrace(System.err);
                    retries = 5;
                }
                agent = null;
            }
        }
    }

    public AgentMain() throws Exception {
        this(null);
    }

    public AgentMain(String[] args) throws Exception {
        LOG.debug("AgentMain.creating-agent", new Object[0]);
        this.m_agentHomeDirectory = null;
        this.m_daemonMode = false;
        this.m_input = null;
        this.m_output = new AgentPrintWriter(System.out, true);
        this.m_stdinInput = true;
        this.m_configuration = null;
        this.m_started = new boolean[]{false};
        this.m_agentPreferencesNodeName = "default";
        this.m_previouslyQueueCommands = null;
        this.m_registration = null;
        this.m_serverFailoverList = null;
        this.m_primaryServerSwitchoverThread = null;
        this.m_vmHealthCheckThread = null;
        this.m_pingThreadPoolExecutor = null;
        if (args == null) {
            args = new String[]{};
        }
        this.m_commandLineArgs = args;
        this.processArguments(this.m_commandLineArgs);
        this.m_promptCommands = new HashMap<String, Class<? extends AgentPromptCommand>>();
        this.setupPromptCommandsMap(this.m_promptCommands);
        if (this.m_input == null) {
            this.m_input = AgentInputReaderFactory.create(this);
        }
        this.prepareNativeSystem();
    }

    public String getAgentHomeDirectory() {
        if (this.m_agentHomeDirectory != null) {
            return this.m_agentHomeDirectory;
        }
        File agentHomeDir = null;
        String env = System.getenv("RHQ_AGENT_HOME");
        if (env != null) {
            agentHomeDir = new File(env);
        } else {
            try {
                int lastIndexOfFileProtocol;
                File file;
                String pathStr;
                int lastIndexOfLib;
                String resource = AgentMain.class.getName().replace('.', '/').concat(".class");
                URL classUrl = AgentMain.class.getClassLoader().getResource(resource);
                if (classUrl != null && (lastIndexOfLib = (pathStr = classUrl.toString()).lastIndexOf("/lib")) >= 0 && (file = new File(pathStr = pathStr.substring(lastIndexOfFileProtocol = pathStr.lastIndexOf("file:") + 5, lastIndexOfLib))).exists()) {
                    agentHomeDir = file;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (agentHomeDir != null) {
            try {
                this.m_agentHomeDirectory = agentHomeDir.getCanonicalPath();
            }
            catch (Exception e) {
                this.m_agentHomeDirectory = agentHomeDir.getAbsolutePath();
            }
            return this.m_agentHomeDirectory;
        }
        return "";
    }

    public boolean isStarted() {
        return this.m_started[0];
    }

    public boolean isPluginContainerStarted() {
        return PluginContainer.getInstance().isStarted();
    }

    public long getStartTime() {
        return this.m_startTime;
    }

    public long getAgentServerClockDifference() {
        return this.m_agentServerClockDifference;
    }

    public void serverClockNotification(long serverTime) {
        long agentTime = System.currentTimeMillis();
        this.m_agentServerClockDifference = agentTime - serverTime;
        if (Math.abs(this.m_agentServerClockDifference) > 30000L) {
            LOG.error("AgentMain.time-not-synced", new Object[]{serverTime, new Date(serverTime), agentTime, new Date(agentTime)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        boolean[] blArray = this.m_started;
        synchronized (this.m_started) {
            if (!this.isStarted()) {
                try {
                    if (this.m_configuration.getAgentName() == null || this.m_configuration.getAgentName().length() == 0) {
                        try {
                            String hostname = InetAddress.getLocalHost().getCanonicalHostName();
                            this.m_configuration.getPreferences().put("rhq.agent.name", hostname);
                            this.m_configuration.getPreferences().flush();
                            LOG.info("AgentMain.agent-name-auto-generated", new Object[]{hostname});
                        }
                        catch (Exception e) {
                            throw new IllegalStateException(MSG.getMsg("AgentMain.agent-name-not-defined", new Object[0]), e);
                        }
                    }
                    this.prepareNativeSystem();
                    BootstrapLatchCommandListener latch = new BootstrapLatchCommandListener();
                    this.startCommServices(latch);
                    this.startManagementServices();
                    this.prepareStartupWorkRequiringServer();
                    this.waitForServer(this.m_configuration.getWaitForServerAtStartupMsecs());
                    if (!this.m_configuration.doNotStartPluginContainerAtStartup()) {
                        if (!this.startPluginContainer(0L)) {
                            throw new Exception(MSG.getMsg("AgentMain.plugin-container-not-initialized", new Object[0]));
                        }
                    } else {
                        LOG.info("AgentMain.not-starting-pc-at-startup", new Object[0]);
                    }
                    latch.allowAllCommands(this.m_commServices);
                    this.m_pingThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new LoggingThreadFactory(PING_THREAD_POOL_NAME, true));
                    long pingInterval = this.m_configuration.getClientSenderServerPollingInterval();
                    pingInterval = pingInterval < 60000L ? 60000L : pingInterval;
                    this.m_pingThreadPoolExecutor.scheduleWithFixedDelay(new PingExecutor(), 0L, pingInterval, TimeUnit.MILLISECONDS);
                    this.m_shutdownHook = new AgentShutdownHook(this);
                    Runtime.getRuntime().addShutdownHook(this.m_shutdownHook);
                    this.m_primaryServerSwitchoverThread = new PrimaryServerSwitchoverThread(this);
                    long check_interval = this.m_configuration.getPrimaryServerSwitchoverCheckIntervalMsecs();
                    if (check_interval > 0L) {
                        this.m_primaryServerSwitchoverThread.setInterval(check_interval);
                        this.m_primaryServerSwitchoverThread.start();
                    }
                    this.m_vmHealthCheckThread = new VMHealthCheckThread(this);
                    if (this.m_configuration.getVMHealthCheckIntervalMsecs() > 0L) {
                        this.m_vmHealthCheckThread.start();
                    }
                    this.setStarted(true);
                    if (this.m_inputLoopThread == null || !this.m_inputLoopThread.isAlive()) {
                        this.inputLoop();
                    }
                }
                catch (Exception e) {
                    LOG.fatal((Throwable)e, "AgentMain.startup-error", new Object[0]);
                    this.setStarted(true);
                    this.shutdown();
                    throw e;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        boolean[] blArray = this.m_started;
        synchronized (this.m_started) {
            if (this.isStarted()) {
                try {
                    LOG.info("AgentMain.shutting-down", new Object[0]);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                try {
                    if (null != this.m_pingThreadPoolExecutor) {
                        this.m_pingThreadPoolExecutor.shutdownNow();
                        this.m_pingThreadPoolExecutor = null;
                    }
                }
                catch (Throwable ignore) {
                    LOG.warn("AgentMain.failed-to-shutdown-component", new Object[]{"Server Ping Thread", ThrowableUtil.getAllMessages((Throwable)ignore)});
                }
                try {
                    if (this.m_vmHealthCheckThread != null) {
                        this.m_vmHealthCheckThread.stopChecking();
                        this.m_vmHealthCheckThread.interrupt();
                        this.m_vmHealthCheckThread = null;
                    }
                }
                catch (Throwable ignore) {
                    LOG.warn("AgentMain.failed-to-shutdown-component", new Object[]{"Low Memory Check Thread", ThrowableUtil.getAllMessages((Throwable)ignore)});
                }
                try {
                    if (this.m_primaryServerSwitchoverThread != null) {
                        this.m_primaryServerSwitchoverThread.stopChecking();
                        this.m_primaryServerSwitchoverThread.interrupt();
                        this.m_primaryServerSwitchoverThread = null;
                    }
                }
                catch (Throwable ignore) {
                    LOG.warn("AgentMain.failed-to-shutdown-component", new Object[]{"Server Switchover Thread", ThrowableUtil.getAllMessages((Throwable)ignore)});
                }
                if (this.m_shutdownHook != null) {
                    try {
                        Runtime.getRuntime().removeShutdownHook(this.m_shutdownHook);
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    this.m_shutdownHook = null;
                }
                try {
                    this.shutdownPluginContainer();
                }
                catch (Throwable ignore) {
                    LOG.warn("AgentMain.failed-to-shutdown-component", new Object[]{"Plugin Container", ThrowableUtil.getAllMessages((Throwable)ignore)});
                }
                try {
                    if (!this.m_configuration.doNotNotifyServerOfShutdown()) {
                        this.notifyServerOfShutdown();
                    } else {
                        LOG.info("AgentMain.told-to-not-notify-server-of-shutdown", new Object[0]);
                    }
                }
                catch (Throwable ignore) {
                    LOG.warn("AgentMain.failed-to-shutdown-component", new Object[]{"Server Shutdown Notification", ThrowableUtil.getAllMessages((Throwable)ignore)});
                }
                try {
                    this.stopManagementServices();
                }
                catch (Throwable ignore) {
                    LOG.warn("AgentMain.failed-to-shutdown-component", new Object[]{"Agent Management Services", ThrowableUtil.getAllMessages((Throwable)ignore)});
                }
                try {
                    this.shutdownCommServices();
                }
                catch (Throwable ignore) {
                    LOG.warn("AgentMain.failed-to-shutdown-component", new Object[]{"Communication Services", ThrowableUtil.getAllMessages((Throwable)ignore)});
                }
                this.setStarted(false);
                this.m_started.notifyAll();
                if (this.m_inputLoopThread != null && this.m_inputLoopThread.isAlive()) {
                    this.m_inputLoopThread.interrupt();
                }
                LOG.info("AgentMain.shut-down", new Object[0]);
            }
            SystemInfoFactory.shutdown();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public AgentPrintWriter getOut() {
        return this.m_output;
    }

    public AgentInputReader getIn() {
        return this.m_input;
    }

    public Msg getI18NMsg() {
        return MSG;
    }

    public AgentConfiguration getConfiguration() {
        return this.m_configuration;
    }

    public ClientCommandSender getClientCommandSender() {
        return this.m_clientSender;
    }

    public ServiceContainer getServiceContainer() {
        return this.m_commServices;
    }

    public AgentManagement getAgentManagementMBean() {
        return this.m_managementMBean;
    }

    public void agentServerCommunicationsTrace(boolean enabled) {
        Level newLevel;
        org.apache.log4j.Logger outLogger = org.apache.log4j.LogManager.getLogger(OutgoingCommandTrace.class);
        org.apache.log4j.Logger inLogger = org.apache.log4j.LogManager.getLogger(IncomingCommandTrace.class);
        Level level = newLevel = enabled ? Level.TRACE : Level.OFF;
        if (enabled) {
            if (CommandTraceUtil.getSettingTraceCommandConfig() == null) {
                CommandTraceUtil.setSettingTraceCommandConfig((Boolean)Boolean.TRUE);
            }
            if (CommandTraceUtil.getSettingTraceCommandResponseResults() == null) {
                CommandTraceUtil.setSettingTraceCommandResponseResults((Integer)256);
            }
            if (CommandTraceUtil.getSettingTraceCommandSizeThreshold() == null) {
                CommandTraceUtil.setSettingTraceCommandSizeThreshold((Integer)99999);
            }
            if (CommandTraceUtil.getSettingTraceCommandResponseSizeThreshold() == null) {
                CommandTraceUtil.setSettingTraceCommandResponseSizeThreshold((Integer)99999);
            }
        }
        outLogger.setLevel(newLevel);
        inLogger.setLevel(newLevel);
    }

    public void hotDeployLogConfigurationFile(String logFilePath) throws Exception {
        URL logFileUrl = this.getClass().getClassLoader().getResource(logFilePath);
        if (logFileUrl == null) {
            File file = new File(logFilePath);
            if (!file.exists()) {
                throw new FileNotFoundException(logFilePath);
            }
            logFileUrl = file.toURI().toURL();
        }
        try {
            org.apache.log4j.LogManager.resetConfiguration();
            DOMConfigurator.configure((URL)logFileUrl);
        }
        catch (Exception e) {
            this.hotDeployLogConfigurationFile("log4j-debug.xml");
            throw e;
        }
    }

    public FailoverListComposite getServerFailoverList() {
        FailoverListComposite list;
        if (this.m_serverFailoverList != null) {
            return this.m_serverFailoverList;
        }
        if (this.m_configuration == null) {
            return new FailoverListComposite(new ArrayList());
        }
        File dataDir = this.m_configuration.getDataDirectory();
        File failoverListFile = new File(dataDir, FILENAME_SERVER_FAILOVER_LIST);
        if (!failoverListFile.exists()) {
            list = new FailoverListComposite(new ArrayList());
        } else {
            try {
                byte[] bytes = StreamUtil.slurp((InputStream)new FileInputStream(failoverListFile));
                list = FailoverListComposite.readAsText((String)new String(bytes));
                LOG.debug("AgentMain.failover-list-loaded", new Object[]{failoverListFile, list.size()});
            }
            catch (Exception e) {
                list = new FailoverListComposite(new ArrayList());
                LOG.warn((Throwable)e, "AgentMain.failover-list-cannot-be-loaded", new Object[]{failoverListFile, ThrowableUtil.getAllMessages((Throwable)e)});
            }
        }
        this.m_serverFailoverList = list;
        return list;
    }

    public FailoverListComposite downloadServerFailoverList() {
        try {
            ClientCommandSender sender = this.getClientCommandSender();
            if (sender != null) {
                String agent_name = this.getConfiguration().getAgentName();
                ClientRemotePojoFactory factory = sender.getClientRemotePojoFactory();
                CoreServerService pojo = (CoreServerService)factory.getRemotePojo(CoreServerService.class);
                FailoverListComposite list = pojo.getFailoverList(agent_name);
                if (list == null) {
                    list = new FailoverListComposite(new ArrayList());
                }
                if (!list.equals((Object)this.m_serverFailoverList)) {
                    this.storeServerFailoverList(list);
                    this.m_serverFailoverList = list;
                    LOG.debug("AgentMain.failover-list-downloaded", new Object[]{this.m_serverFailoverList.size()});
                }
            }
        }
        catch (Throwable t) {
            LOG.warn("AgentMain.failover-list-download-failure", new Object[]{t});
        }
        return this.getServerFailoverList();
    }

    public void performPrimaryServerSwitchoverCheck() {
        if (this.m_primaryServerSwitchoverThread != null) {
            this.m_primaryServerSwitchoverThread.checkNow();
        }
    }

    public String getUserInput(String prompt) {
        boolean use_default_prompt;
        String input_string = "";
        boolean bl = use_default_prompt = prompt == null;
        while (input_string != null && input_string.trim().length() == 0) {
            if (use_default_prompt) {
                prompt = this.getDefaultPrompt();
            }
            this.m_output.print(prompt);
            if (!prompt.endsWith(" ")) {
                this.m_output.print(' ');
            }
            try {
                this.m_output.flush();
                input_string = this.m_input.readLine();
                if (input_string != null) continue;
                LOG.debug("AgentMain.input-eof", new Object[0]);
            }
            catch (Exception e) {
                input_string = null;
                LOG.debug("AgentMain.input-exception", new Object[]{ThrowableUtil.getAllMessages((Throwable)e)});
            }
        }
        if (input_string != null) {
            if (!this.m_stdinInput) {
                this.m_output.println(input_string);
            }
        } else if (!this.m_stdinInput) {
            try {
                this.m_input.close();
            }
            catch (IOException e1) {
                // empty catch block
            }
            if (!this.m_daemonMode) {
                try {
                    this.m_input = AgentInputReaderFactory.create(this);
                }
                catch (IOException e1) {
                    this.m_input = null;
                    LOG.debug((Throwable)e1, "AgentMain.input-factory-exception", new Object[0]);
                }
                this.m_stdinInput = true;
                input_string = "";
            } else {
                this.m_input = null;
            }
        }
        return input_string;
    }

    public Map<String, Class<? extends AgentPromptCommand>> getPromptCommands() {
        return this.m_promptCommands;
    }

    public AgentConfiguration loadConfigurationFile(String pref_node_name, String file_name) throws Exception {
        this.setConfigurationPreferencesNode(pref_node_name);
        return this.loadConfigurationFile(file_name);
    }

    public AgentConfiguration loadConfigurationFile(String file_name) throws Exception {
        File config_file = new File(file_name);
        InputStream config_file_input_stream = config_file.exists() ? new FileInputStream(config_file) : Thread.currentThread().getContextClassLoader().getResourceAsStream(file_name);
        if (config_file_input_stream == null) {
            throw new IOException(MSG.getMsg("AgentMain.cannot-find-config-file", new Object[]{file_name}));
        }
        LOG.debug("AgentMain.loading-config-file", new Object[]{file_name});
        Preferences preferencesNode = this.getPreferencesNode();
        String securityToken = preferencesNode.get("rhq.agent.security-token", null);
        ByteArrayOutputStream backup = new ByteArrayOutputStream();
        preferencesNode.exportSubtree(backup);
        preferencesNode.clear();
        try {
            ByteArrayOutputStream raw_config_file = new ByteArrayOutputStream();
            StreamUtil.copy((InputStream)config_file_input_stream, (OutputStream)raw_config_file, (boolean)true);
            Properties replacements = new Properties();
            replacements.putAll((Map<?, ?>)System.getProperties());
            replacements.put("rhq.agent.preferences-node", this.m_agentPreferencesNodeName);
            String new_config = StringPropertyReplacer.replaceProperties((String)raw_config_file.toString(), (Properties)replacements);
            ByteArrayInputStream new_config_input_stream = new ByteArrayInputStream(new_config.getBytes());
            Preferences.importPreferences(new_config_input_stream);
            AgentConfiguration newAgentConfig = new AgentConfiguration(preferencesNode);
            if (newAgentConfig.getAgentConfigurationVersion() == 0) {
                throw new IllegalArgumentException(MSG.getMsg("AgentMain.bad-node-name-in-config-file", new Object[]{file_name, this.m_agentPreferencesNodeName}));
            }
            if (securityToken != null) {
                if (newAgentConfig.getAgentSecurityToken() == null) {
                    LOG.debug("AgentMain.restoring-security-token", new Object[0]);
                    newAgentConfig.setAgentSecurityToken(securityToken);
                } else {
                    LOG.info("AgentMain.not-restoring-security-token", new Object[0]);
                }
            }
            preferencesNode.flush();
        }
        catch (Exception e) {
            try {
                Preferences.importPreferences(new ByteArrayInputStream(backup.toByteArray()));
            }
            catch (Exception e1) {
                // empty catch block
            }
            throw e;
        }
        AgentConfiguration agent_configuration = new AgentConfiguration(preferencesNode);
        LOG.debug("AgentMain.loaded-config-file", new Object[]{file_name});
        this.m_configuration = agent_configuration;
        return this.m_configuration;
    }

    public void overlaySystemPropertiesOnAgentConfiguration() {
        this.overlaySystemProperties(this.m_configuration.getPreferences());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerWithServer(long wait, final boolean regenerate_token) {
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public void run() {
                retry = true;
                retry_interval = 1000L;
                got_registered = false;
                registrationFailures = 0;
                MAX_ALLOWED_REGISTRATION_FAILURES = 5;
                hide_loopback_warning = Boolean.getBoolean("rhq.hide-agent-localhost-warning");
                hide_failover_list_warning = false;
                while (retry) {
                    try {
                        block16: {
                            block15: {
                                sender = AgentMain.this.getClientCommandSender();
                                if (sender == null || Thread.currentThread().isInterrupted()) {
                                    AgentMain.access$300().debug("AgentMain.agent-registration-aborted", new Object[0]);
                                    retry = false;
                                    continue;
                                }
                                token = AgentMain.access$400(AgentMain.this);
                                pojo_factory = sender.getClientRemotePojoFactory();
                                remote_pojo = (CoreServerService)pojo_factory.getRemotePojo(CoreServerService.class);
                                agent_config = AgentMain.this.getConfiguration();
                                server_config = agent_config.getServiceContainerPreferences();
                                agent_name = agent_config.getAgentName();
                                address = server_config.getConnectorBindAddress();
                                port = server_config.getConnectorBindPort();
                                remote_endpoint = server_config.getConnectorRemoteEndpoint();
                                version = Version.getProductVersion();
                                build = Version.getBuildNumber();
                                agentVersion = new AgentVersion(version, build);
                                request = new AgentRegistrationRequest(agent_name, address, port, remote_endpoint, regenerate_token, token, agentVersion);
                                Thread.sleep(retry_interval);
                                if (!sender.isSending()) continue;
                                AgentMain.access$300().debug("AgentMain.agent-registration-attempt", new Object[]{request});
                                if (!hide_loopback_warning && (remote_endpoint.contains("localhost") || remote_endpoint.contains("127.0.0."))) {
                                    msg_id = "AgentMain.registering-with-loopback";
                                    AgentMain.access$300().warn(msg_id, new Object[]{remote_endpoint});
                                    AgentMain.this.getOut().println(AgentMain.access$500().getMsg(msg_id, new Object[]{remote_endpoint}));
                                    AgentMain.this.getOut().println();
                                    hide_loopback_warning = true;
                                }
                                agent_config.setAgentSecurityToken(null);
                                failover_list = null;
                                try {
                                    results = remote_pojo.registerAgent(request);
                                    failover_list = results.getFailoverList();
                                    token = results.getAgentToken();
                                    test_failover_list = AgentMain.access$600(AgentMain.this).isTestFailoverListAtStartupEnabled();
                                    if (!test_failover_list) ** GOTO lbl71
                                    failed = AgentMain.access$700(AgentMain.this, failover_list);
                                    if (failed.size() <= 0 || failed.size() != failover_list.size()) break block15;
                                    retry = true;
                                    retry_interval = 30000L;
                                    if (!hide_failover_list_warning) {
                                        msg_id = "AgentMain.failover-list-check-failed";
                                        AgentMain.access$300().warn(msg_id, new Object[]{failed.size(), failed.toString()});
                                        AgentMain.this.getOut().println(AgentMain.access$500().getMsg(msg_id, new Object[]{failed.size(), failed.toString()}));
                                        AgentMain.this.getOut().println();
                                        hide_failover_list_warning = true;
                                    }
                                    agent_config.setAgentSecurityToken(token);
                                }
                                catch (Throwable var28_31) {
                                    agent_config.setAgentSecurityToken(token);
                                    AgentMain.access$300().debug("SecurityTokenCommandPreprocessor.new-security-token", new Object[]{token});
                                    throw var28_31;
                                }
                                AgentMain.access$300().debug("SecurityTokenCommandPreprocessor.new-security-token", new Object[]{token});
                                continue;
                            }
                            break block16;
lbl71:
                            // 1 sources

                            AgentMain.access$300().info("AgentMain.test-failover-list-at-startup-disabled", new Object[0]);
                        }
                        AgentMain.access$802(AgentMain.this, results);
                        got_registered = true;
                        retry = false;
                        AgentMain.access$300().info("AgentMain.agent-registration-results", new Object[]{results});
                        agent_config.setAgentSecurityToken(token);
                        AgentMain.access$300().debug("SecurityTokenCommandPreprocessor.new-security-token", new Object[]{token});
                        AgentMain.access$900(AgentMain.this, failover_list);
                        AgentMain.access$1002(AgentMain.this, failover_list);
                        if (!failover_list.hasNext()) continue;
                        currentAddress = agent_config.getServerBindAddress();
                        currentPort = agent_config.getServerBindPort();
                        currentTransport = agent_config.getServerTransport();
                        nextServer = failover_list.peek();
                        if (currentAddress.equals(nextServer.address) && currentPort == (SecurityUtil.isTransportSecure((String)currentTransport) != false ? nextServer.securePort : nextServer.port)) {
                            nextServer = failover_list.next();
                            continue;
                        }
                        AgentMain.this.failoverToNewServer(sender.getRemoteCommunicator());
                    }
                    catch (AgentNotSupportedException anse) {
                        AgentMain.access$802(AgentMain.this, null);
                        retry = false;
                        cause = ThrowableUtil.getAllMessages((Throwable)anse);
                        AgentMain.access$300().fatal("AgentMain.agent-not-supported", new Object[]{cause});
                        AgentMain.this.getOut().println(AgentMain.access$500().getMsg("AgentMain.agent-not-supported", new Object[]{cause}));
                        AgentUpdateThread.updateAgentNow(AgentMain.this, true);
                    }
                    catch (AgentRegistrationException are) {
                        AgentMain.access$802(AgentMain.this, null);
                        cause = ThrowableUtil.getAllMessages((Throwable)are);
                        AgentMain.access$300().error("AgentMain.agent-registration-rejected", new Object[]{cause});
                        AgentMain.this.getOut().println(AgentMain.access$500().getMsg("AgentMain.agent-registration-rejected", new Object[]{cause}));
                        if (++registrationFailures < 5) {
                            retry = true;
                            retry_interval = 30000L;
                            AgentMain.access$300().error("AgentMain.agent-registration-retry", new Object[0]);
                            AgentMain.this.getOut().println(AgentMain.access$500().getMsg("AgentMain.agent-registration-retry", new Object[0]));
                            continue;
                        }
                        AgentMain.this.getOut().println(AgentMain.access$500().getMsg("AgentMain.agent-cannot-register", new Object[0]));
                        retry = false;
                    }
                    catch (InterruptedException ie) {
                        AgentMain.access$300().debug("AgentMain.agent-registration-aborted", new Object[0]);
                        retry = false;
                    }
                    catch (Throwable t) {
                        if (!got_registered) {
                            retry_interval = retry_interval < 60000L ? retry_interval * 2L : 60000L;
                            AgentMain.access$300().warn(t, "AgentMain.agent-registration-failure", new Object[]{retry, retry_interval, ThrowableUtil.getAllMessages((Throwable)t)});
                            continue;
                        }
                        AgentMain.access$300().warn(t, "AgentMain.agent-postregistration-failure", new Object[]{AgentMain.access$800(AgentMain.this), ThrowableUtil.getAllMessages((Throwable)t)});
                    }
                }
            }
        };
        Thread[] threadArray = this.m_registrationThread;
        synchronized (this.m_registrationThread) {
            Thread thread = this.m_registrationThread[0];
            if (thread != null) {
                thread.interrupt();
            }
            thread = new Thread(task, "RHQ Agent Registration Thread");
            thread.setDaemon(true);
            this.m_registrationThread[0] = thread;
            thread.start();
            // ** MonitorExit[var6_4] (shouldn't be in output)
            if (wait > 0L) {
                try {
                    thread.join(wait);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            return;
        }
    }

    public AgentRegistrationResults getAgentRegistration() {
        return this.m_registration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForServer(long wait_ms) throws AgentNotSupportedException {
        final StringBuffer flag_and_lock = new StringBuffer();
        ClientCommandSenderStateListener listener = new ClientCommandSenderStateListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean startedSending(ClientCommandSender sender) {
                StringBuffer stringBuffer = flag_and_lock;
                synchronized (stringBuffer) {
                    flag_and_lock.append("1");
                    flag_and_lock.notifyAll();
                    return false;
                }
            }

            public boolean stoppedSending(ClientCommandSender sender) {
                return true;
            }
        };
        ClientCommandSender sender_to_server = this.getClientCommandSender();
        StringBuffer stringBuffer = flag_and_lock;
        synchronized (stringBuffer) {
            if (sender_to_server != null) {
                LOG.debug("AgentMain.waiting-for-server", new Object[]{wait_ms});
                sender_to_server.addStateListener(listener, true);
                if (flag_and_lock.length() == 0) {
                    try {
                        long start_time = System.currentTimeMillis();
                        while (wait_ms > 0L && flag_and_lock.length() == 0) {
                            try {
                                flag_and_lock.wait(wait_ms);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            if (AgentUpdateThread.isUpdatingNow()) {
                                throw new AgentNotSupportedException();
                            }
                            wait_ms -= System.currentTimeMillis() - start_time;
                        }
                    }
                    finally {
                        sender_to_server.removeStateListener(listener);
                    }
                }
            } else {
                LOG.debug("AgentMain.cannot-wait-for-server", new Object[0]);
            }
            return flag_and_lock.length() > 0;
        }
    }

    public boolean isRegistered() {
        return this.getAgentSecurityToken() != null;
    }

    private boolean prepareStartupWorkRequiringServer() {
        boolean register = this.m_configuration.isRegisterWithServerAtStartupEnabled();
        if (!register && !this.isRegistered()) {
            register = true;
            LOG.info("AgentMain.forcing-agent-registration", new Object[0]);
        }
        if (register) {
            this.m_clientSender.addStateListener((ClientCommandSenderStateListener)new RegisterStateListener(), true);
        }
        if (this.m_configuration.isUpdatePluginsAtStartupEnabled()) {
            this.updatePlugins();
        }
        this.m_clientSender.addStateListener((ClientCommandSenderStateListener)new PluginContainerConditionalRestartListener(), false);
        return register;
    }

    public void updatePlugins() {
        this.m_clientSender.addStateListener((ClientCommandSenderStateListener)new UpdatePluginsStateListener(), true);
    }

    public boolean startPluginContainer(long wait_for_registration) {
        PluginContainer plugin_container = PluginContainer.getInstance();
        if (plugin_container.isStarted()) {
            return true;
        }
        plugin_container.setRebootRequestListener(new RebootRequestListener(){

            public void reboot() {
                try {
                    AgentMain.this.shutdown();
                }
                catch (Throwable t) {
                    LOG.error(t, "The plugin container has requested the agent be restarted but the shutdown operation failed.", new Object[0]);
                }
                if (AgentMain.this.isStarted()) {
                    try {
                        Thread.sleep(3000L);
                        AgentMain.this.shutdown();
                    }
                    catch (Throwable t) {
                        LOG.error(t, "The plugin container has requested the agent be restarted but the shutdown operation failed again.", new Object[0]);
                    }
                }
                if (AgentMain.this.isStarted()) {
                    LOG.warn("The agent shut down operation has failed twice. Attempting to reboot the plugin container so that stale resource types and deleted plugins are removed.", new Object[0]);
                    try {
                        this.rebootPluginContainer();
                    }
                    catch (Throwable t) {
                        LOG.error("The agent could not be shut down and rebooting the plugin container failed. Please check the logs for errors and manually restart the agent as soon as possible.", new Object[0]);
                        return;
                    }
                }
                try {
                    AgentMain.this.cleanDataDirectory();
                }
                catch (Throwable t) {
                    LOG.warn(t, "The plugin container has requested the agent be restarted but purging the data directory failed.", new Object[0]);
                }
                try {
                    AgentMain.this.start();
                }
                catch (Throwable t) {
                    LOG.warn(t, "An error occurred while trying to restart the agent. Attempting restart one more time", new Object[0]);
                    try {
                        AgentMain.this.shutdown();
                        AgentMain.this.start();
                    }
                    catch (Throwable t1) {
                        LOG.error(t1, "Restarting the agent has failed. Please check the logs for errors and manually restart the agent as soon as possible.", new Object[0]);
                        return;
                    }
                }
                AgentMain.this.getAgentRestartCounter().restartedAgent(AgentRestartCounter.AgentRestartReason.STALE_INVENTORY);
            }

            private void rebootPluginContainer() throws Throwable {
                PluginContainer pc = PluginContainer.getInstance();
                if (pc.isStarted()) {
                    try {
                        AgentMain.this.shutdownPluginContainer();
                    }
                    catch (Throwable t) {
                        LOG.error(t, "The plugin container shut down operation failed.", new Object[0]);
                        throw t;
                    }
                    try {
                        AgentMain.this.startPluginContainer(0L);
                    }
                    catch (Throwable t) {
                        LOG.error(t, "The plugin container was shut down but an error occurred trying to restart it.", new Object[0]);
                        throw t;
                    }
                }
                LOG.warn("The plugin container is already shut down. Attempting to restart it...", new Object[0]);
                try {
                    AgentMain.this.startPluginContainer(0L);
                }
                catch (Throwable t) {
                    LOG.error(t, "The plugin container was shut down but an error occurred trying to restart it.", new Object[0]);
                    throw t;
                }
            }
        });
        try {
            this.waitToBeRegistered(wait_for_registration);
        }
        catch (Exception e) {
            LOG.debug("AgentMain.pc-start-failed-waiting-for-registration", new Object[]{ThrowableUtil.getAllMessages((Throwable)e)});
            return false;
        }
        PluginContainerConfiguration pc_config = this.m_configuration.getPluginContainerConfiguration();
        pc_config.setPluginFinder((PluginFinder)new FileSystemPluginFinder(pc_config.getPluginDirectory()));
        try {
            LOG.debug("AgentMain.creating-plugin-container-server-services", new Object[0]);
            ClientRemotePojoFactory factory = this.m_clientSender.getClientRemotePojoFactory();
            CoreServerService coreServerService = (CoreServerService)factory.getRemotePojo(CoreServerService.class);
            DiscoveryServerService discoveryServerService = (DiscoveryServerService)factory.getRemotePojo(DiscoveryServerService.class);
            MeasurementServerService measurementServerService = (MeasurementServerService)factory.getRemotePojo(MeasurementServerService.class);
            OperationServerService operationServerService = (OperationServerService)factory.getRemotePojo(OperationServerService.class);
            ConfigurationServerService configurationServerService = (ConfigurationServerService)factory.getRemotePojo(ConfigurationServerService.class);
            ResourceFactoryServerService resourceFactoryServerSerfice = (ResourceFactoryServerService)factory.getRemotePojo(ResourceFactoryServerService.class);
            ContentServerService contentServerService = (ContentServerService)factory.getRemotePojo(ContentServerService.class);
            EventServerService eventServerService = (EventServerService)factory.getRemotePojo(EventServerService.class);
            BundleServerService bundleServerService = (BundleServerService)factory.getRemotePojo(BundleServerService.class);
            DriftServerService driftServerService = (DriftServerService)factory.getRemotePojo(DriftServerService.class);
            ServerServices serverServices = new ServerServices();
            serverServices.setCoreServerService(coreServerService);
            serverServices.setDiscoveryServerService(discoveryServerService);
            serverServices.setMeasurementServerService(measurementServerService);
            serverServices.setOperationServerService(operationServerService);
            serverServices.setConfigurationServerService(configurationServerService);
            serverServices.setResourceFactoryServerService(resourceFactoryServerSerfice);
            serverServices.setContentServerService(contentServerService);
            serverServices.setEventServerService(eventServerService);
            serverServices.setBundleServerService(bundleServerService);
            serverServices.setDriftServerService(driftServerService);
            pc_config.setServerServices(serverServices);
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "AgentMain.failed-to-create-plugin-container-server-services", new Object[]{e});
            return false;
        }
        try {
            boolean keep_waiting;
            File plugin_dir = pc_config.getPluginDirectory();
            boolean bl = keep_waiting = plugin_dir.list().length == 0 || PluginUpdate.waitForUpdateToComplete(pc_config, 1000L);
            if (this.m_configuration.isUpdatePluginsAtStartupEnabled()) {
                boolean notified_user = false;
                while (keep_waiting) {
                    if (!notified_user) {
                        LOG.info("AgentMain.waiting-for-plugins-with-dir", new Object[]{plugin_dir});
                        this.getOut().println(MSG.getMsg("AgentMain.waiting-for-plugins", new Object[0]));
                        notified_user = true;
                    } else {
                        LOG.debug("AgentMain.waiting-for-plugins-with-dir", new Object[]{plugin_dir});
                    }
                    boolean updating = PluginUpdate.waitForUpdateToComplete(pc_config, 30000L);
                    int after = plugin_dir.list().length;
                    if (after == 0 && !updating) {
                        this.updatePluginsNow(this.m_clientSender);
                        after = plugin_dir.list().length;
                    }
                    if (keep_waiting = after == 0 || updating) continue;
                    after = plugin_dir.list(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.endsWith(".jar");
                        }
                    }).length;
                    LOG.info("AgentMain.done-waiting-for-plugins", new Object[]{after});
                    this.getOut().println(MSG.getMsg("AgentMain.done-waiting-for-plugins", new Object[]{after}));
                }
            } else if (plugin_dir.list().length == 0) {
                LOG.warn("AgentMain.no-plugins", new Object[0]);
                this.getOut().println(MSG.getMsg("AgentMain.no-plugins", new Object[0]));
                return false;
            }
        }
        catch (InterruptedException e) {
            LOG.warn("AgentMain.plugin-container-initialization-interrupted", new Object[0]);
            this.getOut().println(MSG.getMsg("AgentMain.plugin-container-initialization-interrupted", new Object[0]));
            return false;
        }
        plugin_container.setConfiguration(pc_config);
        AgentServiceRemoter agentServiceRemoter = new AgentServiceRemoter(this);
        plugin_container.addAgentServiceLifecycleListener((AgentServiceLifecycleListener)agentServiceRemoter);
        plugin_container.setAgentServiceStreamRemoter((AgentServiceStreamRemoter)agentServiceRemoter);
        plugin_container.setAgentRegistrar((AgentRegistrar)new AgentRegistrarImpl(this));
        plugin_container.initialize();
        LOG.debug("AgentMain.plugin-container-initialized", new Object[]{pc_config});
        return plugin_container.isStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean switchToServer(String server) {
        RemoteCommunicator comm;
        AgentUtils.ServerEndpoint newServer;
        AgentConfiguration config = this.getConfiguration();
        String currentServerAddress = config.getServerBindAddress();
        int currentServerPort = config.getServerBindPort();
        String currentServerTransport = config.getServerTransport();
        String currentServerTransportParams = config.getServerTransportParams();
        try {
            newServer = AgentUtils.getServerEndpoint(config, server);
        }
        catch (Exception e) {
            LOG.warn("AgentMain.cannot-switch-to-invalid-server", new Object[]{server, ThrowableUtil.getAllMessages((Throwable)e)});
            return false;
        }
        try {
            comm = this.getClientCommandSender().getRemoteCommunicator();
            if (comm == null) {
                throw new IllegalStateException();
            }
        }
        catch (Exception e) {
            LOG.warn("AgentMain.cannot-switch-null-communicator", new Object[]{server, ThrowableUtil.getAllMessages((Throwable)e)});
            return false;
        }
        String originalServerEndpoint = comm.getRemoteEndpoint();
        long[] lArray = this.m_lastFailoverTime;
        synchronized (this.m_lastFailoverTime) {
            boolean ok = this.switchCommServer(comm, newServer.namePort, newServer.transport, newServer.transportParams);
            if (!ok) {
                try {
                    comm.setRemoteEndpoint(originalServerEndpoint);
                    config.setServerLocatorUri(currentServerTransport, currentServerAddress, currentServerPort, currentServerTransportParams);
                }
                catch (Exception e) {
                    LOG.warn("AgentMain.cannot-switch-to-invalid-server", new Object[]{originalServerEndpoint, e});
                }
            }
            // ** MonitorExit[var10_12] (shouldn't be in output)
            return ok;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void failoverToNewServer(RemoteCommunicator comm) {
        long[] lArray = this.m_lastFailoverTime;
        synchronized (this.m_lastFailoverTime) {
            if (System.currentTimeMillis() - this.m_lastFailoverTime[0] < 10000L) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            FailoverListComposite failoverList = this.getServerFailoverList();
            if (!failoverList.hasNext()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            AgentConfiguration config = this.getConfiguration();
            String currentTransport = config.getServerTransport();
            String currentTransportParams = config.getServerTransportParams();
            FailoverListComposite.ServerEntry nextServer = failoverList.next();
            boolean ok = this.switchCommServer(comm, nextServer, currentTransport, currentTransportParams);
            if (ok) {
                failoverList.resetIndex();
                this.m_lastFailoverTime[0] = System.currentTimeMillis();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean switchCommServer(RemoteCommunicator comm, FailoverListComposite.ServerEntry newServer, String transport, String transportParams) {
        AgentConfiguration config = this.getConfiguration();
        this.unprepareAutoDiscoveryListener();
        try {
            config.setServerLocatorUri(transport, newServer.address, SecurityUtil.isTransportSecure((String)transport) ? newServer.securePort : newServer.port, transportParams);
            try {
                comm.setRemoteEndpoint(config.getServerLocatorUri());
                this.sendConnectRequestToServer(comm, false);
            }
            catch (Throwable t) {
                LOG.warn("AgentMain.failover-failed", new Object[]{t});
                boolean bl = false;
                try {
                    this.prepareAutoDiscoveryListener();
                }
                catch (Exception e) {
                    LOG.info("AgentMain.failover-discovery-start-failure", new Object[]{ThrowableUtil.getAllMessages((Throwable)e)});
                }
                return bl;
            }
        }
        catch (Throwable throwable) {
            try {
                this.prepareAutoDiscoveryListener();
            }
            catch (Exception e) {
                LOG.info("AgentMain.failover-discovery-start-failure", new Object[]{ThrowableUtil.getAllMessages((Throwable)e)});
            }
            throw throwable;
        }
        LOG.info("AgentMain.failed-over-to-server", new Object[]{config.getServerLocatorUri()});
        try {
            this.prepareAutoDiscoveryListener();
        }
        catch (Exception e) {
            LOG.info("AgentMain.failover-discovery-start-failure", new Object[]{ThrowableUtil.getAllMessages((Throwable)e)});
        }
        return true;
    }

    void sendConnectRequestToServer(RemoteCommunicator comm, boolean attemptFailover) throws Throwable {
        if (!this.m_lastSentConnectAgent.rwLock.writeLock().tryLock(120L, TimeUnit.SECONDS)) {
            throw new IllegalStateException(MSG.getMsg("AgentMain.connect-lock-timeout", new Object[0]));
        }
        try {
            if (this.m_lastSentConnectAgent.serverEndpoint.equals(comm.getRemoteEndpoint()) && System.currentTimeMillis() - this.m_lastSentConnectAgent.timestamp < 30000L) {
                LOG.info("AgentMain.not-sending-dup-connect", new Object[]{this.m_lastSentConnectAgent});
                return;
            }
            Command connectCommand = this.createConnectAgentCommand();
            this.getClientCommandSender().preprocessCommand(connectCommand);
            CommandResponse connectResponse = attemptFailover ? comm.sendWithoutInitializeCallback(connectCommand) : comm.sendWithoutCallbacks(connectCommand);
            if (!connectResponse.isSuccessful()) {
                Throwable exception = connectResponse.getException();
                if (exception != null) {
                    if (exception.getCause() instanceof AgentNotSupportedException) {
                        exception = exception.getCause();
                    }
                    throw exception;
                }
                throw new Exception("FAILED: " + connectCommand);
            }
            this.m_lastSentConnectAgent.timestamp = System.currentTimeMillis();
            this.m_lastSentConnectAgent.serverEndpoint = comm.getRemoteEndpoint();
            try {
                ConnectAgentResults results = (ConnectAgentResults)connectResponse.getResults();
                long serverTime = results.getServerTime();
                this.serverClockNotification(serverTime);
                boolean serverThinksWeAreDown = results.isDown();
                if (serverThinksWeAreDown) {
                    LOG.warn("AgentMain.server-thinks-agent-is-down", new Object[0]);
                    PluginContainer plugin_container = PluginContainer.getInstance();
                    if (plugin_container.isStarted()) {
                        plugin_container.getInventoryManager().requestFullAvailabilityReport();
                    }
                }
            }
            catch (Throwable t) {
                LOG.error("AgentMain.time-unknown", new Object[]{ThrowableUtil.getAllMessages((Throwable)t)});
            }
        }
        catch (AgentNotSupportedException anse) {
            String cause = ThrowableUtil.getAllMessages((Throwable)anse);
            LOG.fatal("AgentMain.agent-not-supported", new Object[]{cause});
            this.getOut().println(MSG.getMsg("AgentMain.agent-not-supported", new Object[]{cause}));
            AgentUpdateThread.updateAgentNow(this, false);
            this.m_lastSentConnectAgent.timestamp = 0L;
            Thread.sleep(1000L);
            throw anse;
        }
        catch (Throwable t) {
            this.m_lastSentConnectAgent.timestamp = 0L;
            throw t;
        }
        finally {
            this.m_lastSentConnectAgent.rwLock.writeLock().unlock();
        }
    }

    private Command createConnectAgentCommand() throws Exception {
        AgentConfiguration config = this.getConfiguration();
        String agentName = config.getAgentName();
        AgentVersion version = new AgentVersion(Version.getProductVersion(), Version.getBuildNumber());
        ConnectAgentRequest request = new ConnectAgentRequest(agentName, version);
        RemotePojoInvocationCommand connectCommand = new RemotePojoInvocationCommand();
        Method connectMethod = CoreServerService.class.getMethod("connectAgent", ConnectAgentRequest.class);
        NameBasedInvocation inv = new NameBasedInvocation(connectMethod, new Object[]{request});
        connectCommand.setNameBasedInvocation(inv);
        connectCommand.setTargetInterfaceName(CoreServerService.class.getName());
        return connectCommand;
    }

    public AgentRestartCounter getAgentRestartCounter() {
        return this.m_agentRestartCounter;
    }

    private void cleanPluginsDirectory() {
        try {
            File plugins_dir = this.m_configuration.getPluginContainerConfiguration().getPluginDirectory();
            if (plugins_dir.exists()) {
                LOG.info("AgentMain.clean-plugins-dir", new Object[]{plugins_dir.getAbsolutePath()});
                this.cleanFile(plugins_dir);
            }
        }
        catch (Exception e) {
            LOG.warn("AgentMain.clean-plugins-failure", new Object[]{e});
        }
    }

    private void cleanDataDirectory() {
        try {
            File comm_data_dir;
            File data_dir = this.m_configuration.getDataDirectory();
            if (data_dir.exists()) {
                LOG.info("AgentMain.clean-data-dir", new Object[]{data_dir.getAbsolutePath()});
                this.cleanFile(data_dir);
            }
            if (!(comm_data_dir = this.m_configuration.getServiceContainerPreferences().getDataDirectory()).getAbsolutePath().equals(data_dir.getAbsolutePath()) && comm_data_dir.exists()) {
                LOG.info("AgentMain.clean-data-dir", new Object[]{comm_data_dir.getAbsolutePath()});
                this.cleanFile(comm_data_dir);
            }
        }
        catch (Exception e) {
            LOG.warn("AgentMain.clean-data-dir-failure", new Object[]{e});
        }
    }

    private void cleanFile(File file) {
        File[] doomed_files = file.listFiles();
        if (doomed_files != null) {
            for (File doomed_file : doomed_files) {
                this.cleanFile(doomed_file);
            }
        }
        boolean deleted = file.delete();
        LOG.debug("AgentMain.clean-file", new Object[]{file, deleted});
    }

    private void prepareNativeSystem() {
        if (this.m_disableNativeSystem || this.m_configuration.isNativeSystemDisabled()) {
            if (!SystemInfoFactory.isNativeSystemInfoDisabled()) {
                SystemInfoFactory.disableNativeSystemInfo();
                LOG.info("AgentMain.native-system-disabled", new Object[0]);
            }
            this.m_loggedNativeSystemInfoUnavailableWarning = false;
        } else if (!SystemInfoFactory.isNativeSystemInfoAvailable()) {
            if (!this.m_loggedNativeSystemInfoUnavailableWarning) {
                Throwable t = SystemInfoFactory.getNativeLibraryLoadThrowable();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("AgentMain.native-sysinfo-unavailable-debug", new Object[]{t});
                } else {
                    LOG.warn("AgentMain.native-sysinfo-unavailable", new Object[0]);
                }
                this.m_loggedNativeSystemInfoUnavailableWarning = true;
            }
        } else {
            this.m_loggedNativeSystemInfoUnavailableWarning = false;
        }
    }

    private void startCommServices(BootstrapLatchCommandListener listener) throws Exception {
        this.assignDefaultLocationToKeystoreTruststoreFiles();
        this.m_clientSender = this.createClientCommandSender();
        this.m_commServices = new ServiceContainer();
        this.m_commServices.addServiceContainerSenderCreationListener((ServiceContainerSenderCreationListener)new SenderCreationListener());
        this.m_commServices.addCommandListener((CommandListener)listener);
        CommandListenerStateListener commandListenerStateListener = new CommandListenerStateListener();
        this.m_clientSender.addStateListener((ClientCommandSenderStateListener)commandListenerStateListener, true);
        this.prepareAutoDiscoveryListener();
        this.m_commServices.start(this.m_configuration.getPreferences(), this.m_configuration.getClientCommandSenderConfiguration());
        if (!this.isAutoDiscoveryEnabled()) {
            LOG.info("AgentMain.no-auto-detect", new Object[0]);
            this.m_clientSender.startServerPolling();
        }
    }

    private void assignDefaultLocationToKeystoreTruststoreFiles() {
        File confDir = new File("conf");
        if (!confDir.exists()) {
            return;
        }
        String[][] prefNamesFileNames = new String[][]{{"rhq.communications.connector.security.keystore.file", "keystore.dat"}, {"rhq.communications.connector.security.truststore.file", "truststore.dat"}, {"rhq.agent.client.security.keystore.file", "keystore.dat"}, {"rhq.agent.client.security.truststore.file", "truststore.dat"}};
        Preferences prefs = this.m_configuration.getPreferences();
        for (String[] prefNameFileName : prefNamesFileNames) {
            String value = prefs.get(prefNameFileName[0], null);
            if (value != null) continue;
            value = new File(confDir, prefNameFileName[1]).getAbsolutePath();
            prefs.put(prefNameFileName[0], value);
            LOG.debug("AgentConfiguration.cert-file-location", new Object[]{prefNameFileName[0], value});
        }
        try {
            prefs.flush();
        }
        catch (Exception e) {
            LOG.warn("AgentConfiguration.cannot-store-preferences", new Object[]{"keystore/truststore files", e});
        }
    }

    private boolean isAutoDiscoveryEnabled() {
        return this.m_autoDiscoveryListener != null;
    }

    private void prepareAutoDiscoveryListener() throws Exception {
        if (this.m_configuration.isServerAutoDetectionEnabled()) {
            ServiceContainerConfiguration comm_config = new ServiceContainerConfiguration(this.m_configuration.getPreferences());
            if (comm_config.isMulticastDetectorEnabled()) {
                this.m_autoDiscoveryListener = new AgentAutoDiscoveryListener(this, this.createServerRemoteCommunicator(null, false, false));
                this.m_commServices.addDiscoveryListener((AutoDiscoveryListener)this.m_autoDiscoveryListener);
                LOG.debug("AgentMain.server-auto-detect-enabled", new Object[]{this.m_configuration.getServerLocatorUri()});
            } else {
                LOG.warn("AgentMain.weird-auto-detect-config", new Object[0]);
            }
        }
    }

    private void unprepareAutoDiscoveryListener() {
        if (this.m_autoDiscoveryListener != null) {
            if (this.m_commServices != null) {
                this.m_commServices.removeDiscoveryListener((AutoDiscoveryListener)this.m_autoDiscoveryListener);
            }
            this.m_autoDiscoveryListener = null;
        }
    }

    private void startManagementServices() throws Exception {
        if (this.m_managementMBean == null && !this.m_configuration.doNotEnableManagementServices()) {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            this.m_managementMBean = new AgentManagement(this);
            ObjectName objectName = ObjectNameFactory.create((String)(AgentManagementMBean.BASE_OBJECT_NAME + "," + "name" + "=" + this.m_configuration.getAgentName()));
            mbs.registerMBean(this.m_managementMBean, objectName);
        }
    }

    private void stopManagementServices() {
        MBeanServer mbs;
        if (this.m_managementMBean != null && (mbs = this.m_managementMBean.getMBeanServer()) != null) {
            try {
                mbs.unregisterMBean(this.m_managementMBean.getObjectName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_managementMBean = null;
        }
    }

    public boolean shutdownPluginContainer() {
        boolean shutdownGracefully = PluginContainer.getInstance().shutdown();
        LOG.debug("AgentMain.plugin-container-shutdown", new Object[0]);
        return shutdownGracefully;
    }

    private void shutdownCommServices() {
        this.unprepareAutoDiscoveryListener();
        if (this.m_clientSender != null) {
            this.m_clientSender.stopServerPolling();
            this.m_clientSender.stopSending(false);
            this.m_clientSender.disableQueueThrottling();
            this.m_clientSender.disableSendThrottling();
            this.m_previouslyQueueCommands = this.m_clientSender.drainQueuedCommands();
            this.m_clientSender = null;
        }
        if (this.m_commServices != null) {
            this.m_commServices.shutdown();
        }
    }

    private void notifyServerOfShutdown() {
        try {
            ClientCommandSender sender = this.getClientCommandSender();
            if (sender.isSending()) {
                LOG.debug("AgentMain.notifying-server-of-shutdown", new Object[0]);
                String agent_name = this.getConfiguration().getAgentName();
                ClientRemotePojoFactory pojo_factory = sender.getClientRemotePojoFactory();
                pojo_factory.setSendThrottled(false);
                pojo_factory.setTimeout(Long.valueOf(10000L));
                CoreServerService remote_pojo = (CoreServerService)pojo_factory.getRemotePojo(CoreServerService.class);
                remote_pojo.agentIsShuttingDown(agent_name);
            } else {
                LOG.debug("AgentMain.not-notifying-server-of-shutdown", new Object[0]);
            }
        }
        catch (Throwable e) {
            LOG.warn("AgentMain.server-shutdown-notification-failure", new Object[]{ThrowableUtil.getAllMessages((Throwable)e)});
        }
    }

    private String getAgentSecurityToken() {
        String token = this.m_configuration.getAgentSecurityToken();
        if (token == null || token.length() == 0) {
            return null;
        }
        return token;
    }

    private void waitToBeRegistered(long wait) throws RuntimeException, AgentNotSupportedException {
        boolean notified_user = false;
        long started = System.currentTimeMillis();
        long sleep_time = 500L;
        while (!this.isRegistered()) {
            long now;
            if (!notified_user) {
                LOG.info("AgentMain.waiting-to-be-registered-begin", new Object[0]);
                this.getOut().println(MSG.getMsg("AgentMain.waiting-to-be-registered-begin", new Object[0]));
                notified_user = true;
            }
            if (wait > 0L && started + wait < (now = System.currentTimeMillis())) {
                throw new RuntimeException(MSG.getMsg("AgentMain.waiting-to-be-registered-timeout", new Object[0]));
            }
            try {
                Thread.sleep(sleep_time);
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            if (AgentUpdateThread.isUpdatingNow()) {
                throw new AgentNotSupportedException();
            }
            if ((sleep_time *= 2L) <= 60000L) continue;
            sleep_time = 60000L;
        }
        if (notified_user) {
            LOG.info("AgentMain.waiting-to-be-registered-end", new Object[0]);
            this.getOut().println(MSG.getMsg("AgentMain.waiting-to-be-registered-end", new Object[0]));
        }
    }

    private ClientCommandSender createClientCommandSender() throws Exception {
        RemoteCommunicator remote_comm = this.createServerRemoteCommunicator(null, true, true);
        ClientCommandSenderConfiguration config = this.m_configuration.getClientCommandSenderConfiguration();
        ClientCommandSender client_sender = new ClientCommandSender(remote_comm, config, this.m_previouslyQueueCommands);
        for (CommandPreprocessor preproc : client_sender.getCommandPreprocessors()) {
            if (!(preproc instanceof SecurityTokenCommandPreprocessor)) continue;
            ((SecurityTokenCommandPreprocessor)preproc).setAgentConfiguration(this.m_configuration);
        }
        return client_sender;
    }

    public RemoteCommunicator createServerRemoteCommunicator(String transport, String address, int port, String transportParams) throws Exception {
        String uri = AgentConfiguration.buildServerLocatorUri(transport, address, port, transportParams);
        return this.createServerRemoteCommunicator(uri, false, false);
    }

    private RemoteCommunicator createServerRemoteCommunicator(String uri, boolean withFailover, boolean withInitializer) throws Exception {
        if (uri == null) {
            uri = this.m_configuration.getServerLocatorUri();
        }
        HashMap<String, String> config = new HashMap<String, String>();
        if (SecurityUtil.isTransportSecure((String)uri)) {
            config.put("org.jboss.remoting.keyStore", this.m_configuration.getClientSenderSecurityKeystoreFile());
            config.put("org.jboss.remoting.keyStoreAlgorithm", this.m_configuration.getClientSenderSecurityKeystoreAlgorithm());
            config.put("org.jboss.remoting.keyStoreType", this.m_configuration.getClientSenderSecurityKeystoreType());
            config.put("org.jboss.remoting.keyStorePassword", this.m_configuration.getClientSenderSecurityKeystorePassword());
            config.put("org.jboss.remoting.keyPassword", this.m_configuration.getClientSenderSecurityKeystoreKeyPassword());
            config.put("org.jboss.remoting.trustStore", this.m_configuration.getClientSenderSecurityTruststoreFile());
            config.put("org.jboss.remoting.trustStoreAlgorithm", this.m_configuration.getClientSenderSecurityTruststoreAlgorithm());
            config.put("org.jboss.remoting.trustStoreType", this.m_configuration.getClientSenderSecurityTruststoreType());
            config.put("org.jboss.remoting.trustStorePassword", this.m_configuration.getClientSenderSecurityTruststorePassword());
            config.put("org.jboss.remoting.sslProtocol", this.m_configuration.getClientSenderSecuritySocketProtocol());
            config.put("org.jboss.remoting.keyAlias", this.m_configuration.getClientSenderSecurityKeystoreAlias());
            config.put("org.jboss.remoting.serverAuthMode", Boolean.toString(this.m_configuration.isClientSenderSecurityServerAuthMode()));
            config.put("org.jboss.remoting.socket.useClientMode", "true");
            SSLSocketBuilder dummy_sslbuilder = new SSLSocketBuilder();
            try {
                dummy_sslbuilder.setKeyStoreURL(this.m_configuration.getClientSenderSecurityKeystoreFile());
            }
            catch (Exception e) {
                SecurityUtil.createKeyStore((String)this.m_configuration.getClientSenderSecurityKeystoreFile(), (String)this.m_configuration.getClientSenderSecurityKeystoreAlias(), (String)"CN=RHQ, OU=RedHat, O=redhat.com, C=US", (String)this.m_configuration.getClientSenderSecurityKeystorePassword(), (String)this.m_configuration.getClientSenderSecurityKeystoreKeyPassword(), (String)"DSA", (int)36500);
                dummy_sslbuilder.setKeyStoreURL(this.m_configuration.getClientSenderSecurityKeystoreFile());
            }
            config.put("org.jboss.security.ignoreHttpsHost", "true");
        }
        JBossRemotingRemoteCommunicator remote_comm = new JBossRemotingRemoteCommunicator(uri, config);
        if (withFailover) {
            remote_comm.setFailureCallback((FailureCallback)new FailoverFailureCallback(this));
        }
        if (withInitializer) {
            remote_comm.setInitializeCallback((InitializeCallback)new ConnectAgentInitializeCallback(this));
        }
        return remote_comm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> testFailoverList(FailoverListComposite failoverList) {
        ArrayList<String> failedServers = new ArrayList<String>(0);
        if (failoverList != null) {
            for (int i = 0; i < failoverList.size(); ++i) {
                FailoverListComposite.ServerEntry server = failoverList.get(i);
                Socket socket = null;
                boolean connectError = true;
                try {
                    LOG.debug("AgentMain.test-failover-list-entry", new Object[]{server.address, server.port});
                    InetAddress inetAddress = InetAddress.getByName(server.address);
                    InetSocketAddress socketAddress = new InetSocketAddress(inetAddress, server.port);
                    socket = new Socket();
                    socket.setSoTimeout(5000);
                    socket.connect(socketAddress, 5000);
                    connectError = false;
                    continue;
                }
                catch (UnknownHostException e) {
                    LOG.error("AgentMain.failover-list-unknown-host", new Object[]{server.address});
                    continue;
                }
                catch (Exception e) {
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (Exception ignore) {
                            // empty catch block
                        }
                    }
                    try {
                        LOG.debug("AgentMain.test-failover-list-entry", new Object[]{server.address, server.securePort});
                        InetAddress inetAddress = InetAddress.getByName(server.address);
                        InetSocketAddress socketAddress = new InetSocketAddress(inetAddress, server.securePort);
                        socket = new Socket();
                        socket.setSoTimeout(5000);
                        socket.connect(socketAddress, 5000);
                        connectError = false;
                    }
                    catch (Exception e1) {
                        String err = ThrowableUtil.getAllMessages((Throwable)e1);
                        LOG.warn("AgentMain.failover-list-unreachable-host", new Object[]{server.address, server.port, server.securePort, err});
                    }
                    continue;
                }
                finally {
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (Exception e) {}
                    }
                    if (connectError) {
                        failedServers.add(server.toString());
                    }
                }
            }
        }
        return failedServers;
    }

    private void storeServerFailoverList(FailoverListComposite failoverList) {
        if (this.m_configuration == null) {
            LOG.warn("AgentMain.failover-list-cannot-be-persisted", new Object[]{"?", "configuration==null"});
            return;
        }
        File dataDir = this.m_configuration.getDataDirectory();
        File failoverListFile = new File(dataDir, FILENAME_SERVER_FAILOVER_LIST);
        if (failoverList == null) {
            failoverListFile.delete();
            if (!failoverListFile.exists()) {
                LOG.debug("AgentMain.failover-list-persisted-empty", new Object[]{failoverListFile});
            } else {
                LOG.warn("AgentMain.failover-list-cannot-be-deleted", new Object[]{failoverListFile});
            }
        } else {
            try {
                byte[] failoverListBytes = failoverList.writeAsText().getBytes();
                ByteArrayInputStream byteStream = new ByteArrayInputStream(failoverListBytes);
                FileOutputStream fileStream = new FileOutputStream(failoverListFile);
                StreamUtil.copy((InputStream)byteStream, (OutputStream)fileStream, (boolean)true);
                LOG.debug("AgentMain.failover-list-persisted", new Object[]{failoverListFile});
            }
            catch (Exception e) {
                LOG.warn((Throwable)e, "AgentMain.failover-list-cannot-be-persisted", new Object[]{failoverListFile, ThrowableUtil.getAllMessages((Throwable)e)});
            }
            if (!Boolean.getBoolean("rhq.hide-server-localhost-warning")) {
                int numServers = failoverList.size();
                for (int i = 0; i < numServers; ++i) {
                    String addr;
                    FailoverListComposite.ServerEntry server = failoverList.get(i);
                    String string = addr = server.address != null ? server.address : "";
                    if (!"localhost".equals(addr) && !addr.startsWith("127.0.0.") && !addr.startsWith("localhost.")) continue;
                    LOG.warn("AgentMain.failover-list-has-localhost", new Object[]{server.address});
                    this.getOut().println(MSG.getMsg("AgentMain.failover-list-has-localhost", new Object[]{server.address}));
                    break;
                }
            }
        }
    }

    private void inputLoop() {
        Runnable loop_runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    String cmd;
                    if ((cmd = !AgentMain.this.m_daemonMode || !AgentMain.this.m_stdinInput ? AgentMain.this.getUserInput(null) : null) == null) {
                        boolean[] blArray = AgentMain.this.m_started;
                        synchronized (blArray) {
                            while (AgentMain.this.m_started[0]) {
                                try {
                                    AgentMain.this.m_started.wait(60000L);
                                }
                                catch (InterruptedException e) {}
                            }
                            break;
                        }
                    }
                    try {
                        String[] cmd_args = AgentMain.this.parseCommandLine(cmd);
                        boolean can_continue = AgentMain.this.executePromptCommand(cmd_args);
                        if (can_continue) continue;
                    }
                    catch (Throwable t) {
                        AgentMain.this.m_output.println(MSG.getMsg("AgentMain.command-failure", new Object[]{cmd, ThrowableUtil.getAllMessages((Throwable)t)}));
                        LOG.debug(t, "AgentMain.command-failure-stack-trace", new Object[0]);
                        continue;
                    }
                    break;
                }
            }
        };
        this.m_inputLoopThread = new Thread(loop_runnable);
        this.m_inputLoopThread.setName(PROMPT_INPUT_THREAD_NAME);
        this.m_inputLoopThread.setDaemon(false);
        this.m_inputLoopThread.start();
    }

    private String getDefaultPrompt() {
        ClientCommandSender sender;
        String prompt = LOG.isDebugEnabled() ? ((sender = this.m_clientSender) != null && this.isStarted() ? (sender.isSending() ? PROMPT_SENDING : PROMPT_STARTED) : PROMPT_SHUTDOWN) : PROMPT_TINY;
        return prompt;
    }

    public boolean executePromptCommand(String command) throws Exception {
        String[] cmd_args = this.parseCommandLine(command);
        return this.executePromptCommand(cmd_args);
    }

    boolean executePromptCommand(String[] cmd_args) throws Exception {
        boolean can_continue = true;
        if (cmd_args.length > 0) {
            List<String> cmd_args_as_list = Arrays.asList(cmd_args);
            LOG.info("AgentMain.prompt-command-invoked", new Object[]{cmd_args_as_list});
            Class<? extends AgentPromptCommand> promptCommandClass = this.m_promptCommands.get(cmd_args[0]);
            if (promptCommandClass != null) {
                AgentPromptCommand prompt_cmd = promptCommandClass.newInstance();
                can_continue = prompt_cmd.execute(this, cmd_args);
                if (!can_continue) {
                    this.m_output.println(MSG.getMsg("AgentMain.input-done", new Object[0]));
                }
            } else {
                this.m_output.println(MSG.getMsg("AgentMain.unknown-command", new Object[]{cmd_args_as_list}));
            }
        } else {
            this.m_output.println();
        }
        return can_continue;
    }

    private void displayUsage() {
        this.m_output.println(MSG.getMsg("AgentMain.usage", new Object[]{this.getClass().getName()}));
    }

    private void processArguments(String[] args) throws Exception {
        int code;
        String sopts = "-:hdlLasntguD:i:o:c:p:e:";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("input", 1, null, 105), new LongOpt("output", 1, null, 111), new LongOpt("config", 1, null, 99), new LongOpt("pref", 1, null, 112), new LongOpt("console", 1, null, 101), new LongOpt("daemon", 0, null, 100), new LongOpt("cleanconfig", 0, null, 108), new LongOpt("fullcleanconfig", 0, null, 76), new LongOpt("advanced", 0, null, 97), new LongOpt("setup", 0, null, 115), new LongOpt("nostart", 0, null, 110), new LongOpt("nonative", 0, null, 116), new LongOpt("purgeplugins", 0, null, 103), new LongOpt("purgedata", 0, null, 117)};
        String config_file_name = null;
        boolean clean_config = false;
        boolean clean_token = false;
        boolean purge_data = false;
        boolean purge_plugins = false;
        AgentInputReaderFactory.ConsoleType console_type = null;
        Getopt getopt = new Getopt("agent", args, sopts, lopts);
        while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: 
                case 63: {
                    this.displayUsage();
                    throw new IllegalArgumentException(MSG.getMsg("AgentMain.bad-args", new Object[0]));
                }
                case 1: {
                    System.err.println(MSG.getMsg("AgentMain.unused-option", new Object[]{getopt.getOptarg()}));
                    break;
                }
                case 104: {
                    this.displayUsage();
                    throw new HelpException(MSG.getMsg("AgentMain.help-shown", new Object[0]));
                }
                case 68: {
                    String value;
                    String name;
                    String sysprop = getopt.getOptarg();
                    int i = sysprop.indexOf("=");
                    if (i == -1) {
                        name = sysprop;
                        value = "true";
                    } else {
                        name = sysprop.substring(0, i);
                        value = sysprop.substring(i + 1, sysprop.length());
                    }
                    System.setProperty(name, value);
                    LOG.debug("AgentMain.sysprop-set", new Object[]{name, value});
                    break;
                }
                case 99: {
                    config_file_name = getopt.getOptarg();
                    break;
                }
                case 108: {
                    clean_config = true;
                    purge_data = true;
                    break;
                }
                case 76: {
                    clean_config = true;
                    purge_data = true;
                    clean_token = true;
                    break;
                }
                case 117: {
                    purge_data = true;
                    break;
                }
                case 103: {
                    purge_plugins = true;
                    break;
                }
                case 97: {
                    this.m_advancedSetup = true;
                    break;
                }
                case 115: {
                    this.m_forcedSetup = true;
                    break;
                }
                case 110: {
                    this.m_startAtBoot = false;
                    break;
                }
                case 112: {
                    this.setConfigurationPreferencesNode(getopt.getOptarg());
                    break;
                }
                case 101: {
                    console_type = AgentInputReaderFactory.ConsoleType.valueOf(getopt.getOptarg());
                    break;
                }
                case 100: {
                    this.m_daemonMode = true;
                    break;
                }
                case 105: {
                    File script = new File(getopt.getOptarg());
                    try {
                        this.m_input = AgentInputReaderFactory.create(this, script);
                        this.m_stdinInput = false;
                        break;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(MSG.getMsg("AgentMain.bad-input-file", new Object[]{script, e}));
                    }
                }
                case 111: {
                    File output = new File(getopt.getOptarg());
                    try {
                        File parentDir = output.getParentFile();
                        if (parentDir != null && !parentDir.exists()) {
                            parentDir.mkdirs();
                        }
                        this.m_output = new AgentPrintWriter(new FileWriter(output), true);
                        break;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(MSG.getMsg("AgentMain.bad-output-file", new Object[]{output, e}));
                    }
                }
                case 116: {
                    this.m_disableNativeSystem = true;
                }
            }
        }
        if (this.m_daemonMode) {
            AgentInputReaderFactory.setConsoleType(AgentInputReaderFactory.ConsoleType.java);
        } else if (console_type != null) {
            AgentInputReaderFactory.setConsoleType(console_type);
        }
        if (clean_config) {
            Preferences prefsNode = this.getPreferencesNode();
            if (clean_token) {
                prefsNode.removeNode();
            } else {
                String[] prefKeys = prefsNode.keys();
                if (prefKeys != null && prefKeys.length > 0) {
                    for (String prefKey : prefKeys) {
                        if (prefKey.equals("rhq.agent.security-token")) continue;
                        prefsNode.remove(prefKey);
                    }
                }
            }
            prefsNode.flush();
        }
        if (config_file_name != null) {
            try {
                this.loadConfigurationFile(config_file_name);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(MSG.getMsg("AgentMain.load-config-file-failure", new Object[]{config_file_name, e}));
            }
        }
        this.checkInitialConfiguration();
        if (purge_data) {
            this.cleanDataDirectory();
        }
        if (purge_plugins) {
            this.cleanPluginsDirectory();
        }
        LOG.debug("AgentMain.args-processed", new Object[]{Arrays.asList(this.m_commandLineArgs)});
    }

    private void setConfigurationPreferencesNode(String node_name) throws IllegalArgumentException {
        if (node_name == null || node_name.trim().length() == 0) {
            node_name = "default";
        }
        if (node_name.indexOf(47) != -1) {
            throw new IllegalArgumentException(MSG.getMsg("AgentMain.no-slashes-allowed", new Object[]{node_name}));
        }
        this.m_agentPreferencesNodeName = node_name;
    }

    private void setupPromptCommandsMap(Map<String, Class<? extends AgentPromptCommand>> prompt_commands) {
        int i;
        prompt_commands.clear();
        AgentPromptCommand[] all_cmds = new AgentPromptCommand[]{new HelpPromptCommand(), new ExitPromptCommand(), new QuitPromptCommand(), new VersionPromptCommand(), new SetupPromptCommand(), new StartPromptCommand(), new ShutdownPromptCommand(), new GetConfigPromptCommand(), new SetConfigPromptCommand(), new ConfigPromptCommand(), new RegisterPromptCommand(), new PluginsPromptCommand(), new PluginContainerPromptCommand(), new MetricsPromptCommand(), new NativePromptCommand(), new DiscoveryPromptCommand(), new InventoryPromptCommand(), new AvailabilityPromptCommand(), new PiqlPromptCommand(), new IdentifyPromptCommand(), new LogPromptCommand(), new TimerPromptCommand(), new PingPromptCommand(), new DownloadPromptCommand(), new DumpSpoolPromptCommand(), new SenderPromptCommand(), new FailoverPromptCommand(), new UpdatePromptCommand(), new DebugPromptCommand(), new SleepPromptCommand(), new GCPromptCommand(), new SchedulesPromptCommand(), new ListDataPromptCommand()};
        StringBuilder conflicts = new StringBuilder();
        for (i = 0; i < all_cmds.length; ++i) {
            for (int j = i + 1; j < all_cmds.length; ++j) {
                String nextConflict = this.ensureUniqueNamesAndAliases(all_cmds[i], all_cmds[j]);
                if (nextConflict == null) continue;
                conflicts.append(System.getProperty("line.separator"));
                conflicts.append(nextConflict);
            }
        }
        if (conflicts.length() > 0) {
            throw new RuntimeException(conflicts.toString());
        }
        for (i = 0; i < all_cmds.length; ++i) {
            prompt_commands.put(all_cmds[i].getPromptCommandString(), all_cmds[i].getClass());
        }
    }

    private String ensureUniqueNamesAndAliases(AgentPromptCommand lefty, AgentPromptCommand righty) {
        String result = null;
        if (lefty.getPromptCommandString().equalsIgnoreCase(righty.getPromptCommandString())) {
            result = "Commands '" + lefty.getClass().getSimpleName() + "' and '" + righty.getClass().getSimpleName() + "' have overlapping prompt command names: '" + lefty.getPromptCommandString() + "'";
        }
        return result;
    }

    private String[] parseCommandLine(String cmdLine) {
        ByteArrayInputStream in = new ByteArrayInputStream(cmdLine.getBytes());
        StreamTokenizer strtok = new StreamTokenizer(new InputStreamReader(in));
        ArrayList<String> args = new ArrayList<String>();
        boolean keep_going = true;
        strtok.ordinaryChars(48, 57);
        strtok.ordinaryChar(46);
        strtok.ordinaryChar(45);
        strtok.ordinaryChar(39);
        strtok.wordChars(33, 127);
        strtok.quoteChar(34);
        while (keep_going) {
            int nextToken;
            try {
                nextToken = strtok.nextToken();
            }
            catch (IOException e) {
                nextToken = -1;
            }
            if (nextToken == -3) {
                args.add(this.safeArg(strtok.sval));
                continue;
            }
            if (nextToken == 34) {
                args.add(this.safeArg(strtok.sval));
                continue;
            }
            if (nextToken != -1 && nextToken != 10) continue;
            keep_going = false;
        }
        return args.toArray(new String[args.size()]);
    }

    private String safeArg(String arg) {
        String result = arg.startsWith("--") && arg.endsWith("=") ? arg.substring(0, arg.length() - 1) : arg;
        return result;
    }

    private Preferences getPreferencesNode() {
        Preferences topNode = Preferences.userRoot().node("rhq-agent");
        Preferences preferencesNode = topNode.node(this.m_agentPreferencesNodeName);
        return preferencesNode;
    }

    private void finishConfigurationSetup(AgentConfiguration agent_configuration) throws Exception {
        Preferences preferencesNode;
        ServiceContainerConfiguration service_container_configuration;
        Preferences prefs = agent_configuration.getPreferences();
        LOG.debug("AgentMain.preferences-schema", new Object[]{agent_configuration.getAgentConfigurationVersion()});
        LOG.debug("AgentMain.preferences-node-path", new Object[]{prefs.absolutePath()});
        if (!agent_configuration.doNotOverridePreferencesWithSystemProperties()) {
            this.overlaySystemProperties(prefs);
        }
        if ((service_container_configuration = new ServiceContainerConfiguration(preferencesNode = agent_configuration.getPreferences())).getDataDirectoryIfDefined() == null) {
            String data_dir = agent_configuration.getDataDirectory().toString();
            preferencesNode.put("rhq.communications.data-directory", data_dir);
        }
        prefs.flush();
        LOG.debug("AgentMain.configuration", new Object[]{agent_configuration});
    }

    private void checkInitialConfiguration() throws Exception {
        if (this.m_configuration == null) {
            AgentConfiguration current_config = new AgentConfiguration(this.getPreferencesNode());
            if (current_config.getAgentConfigurationVersion() == 0) {
                this.loadConfigurationFile("agent-configuration.xml");
            } else {
                this.m_configuration = current_config;
                LOG.debug("AgentMain.preferences-already-exist", new Object[0]);
            }
        }
        this.finishConfigurationSetup(this.m_configuration);
        AgentConfigurationUpgrade.upgradeToLatest(this.m_configuration.getPreferences());
    }

    private void overlaySystemProperties(Preferences prefs) {
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String name = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (!name.startsWith("rhq.communications.") && !name.startsWith("rhq.agent.")) continue;
            LOG.debug("AgentMain.overlay-sysprop", new Object[]{name, value});
            prefs.put(name, value);
        }
    }

    private void setStarted(boolean started) {
        this.m_started[0] = started;
        this.m_startTime = started ? System.currentTimeMillis() : 0L;
    }

    private boolean updatePluginsNow(ClientCommandSender sender) {
        try {
            ClientRemotePojoFactory factory = sender.getClientRemotePojoFactory();
            CoreServerService server = (CoreServerService)factory.getRemotePojo(CoreServerService.class);
            PluginContainerConfiguration pc_config = this.m_configuration.getPluginContainerConfiguration();
            PluginUpdate plugin_update = new PluginUpdate(server, pc_config);
            plugin_update.updatePlugins();
            return true;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e, "AgentMain.plugin-update-failure", new Object[0]);
            return false;
        }
    }

    private static void reconfigureJavaLogging() {
        try {
            LOG.debug("AgentMain.java-logging-start", new Object[0]);
            ClassLoader classLoader = AgentMain.class.getClassLoader();
            InputStream stream = classLoader.getResourceAsStream(JAVA_UTIL_LOGGING_PROPERTIES_RESOURCE_PATH);
            LogManager logManager = LogManager.getLogManager();
            logManager.readConfiguration(stream);
            LOG.debug("AgentMain.java-logging-done", new Object[0]);
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "AgentMain.java-logging-error", new Object[0]);
        }
    }

    static /* synthetic */ String access$400(AgentMain x0) {
        return x0.getAgentSecurityToken();
    }

    static /* synthetic */ List access$700(AgentMain x0, FailoverListComposite x1) {
        return x0.testFailoverList(x1);
    }

    static /* synthetic */ AgentRegistrationResults access$802(AgentMain x0, AgentRegistrationResults x1) {
        x0.m_registration = x1;
        return x0.m_registration;
    }

    static /* synthetic */ void access$900(AgentMain x0, FailoverListComposite x1) {
        x0.storeServerFailoverList(x1);
    }

    static /* synthetic */ FailoverListComposite access$1002(AgentMain x0, FailoverListComposite x1) {
        x0.m_serverFailoverList = x1;
        return x0.m_serverFailoverList;
    }

    static /* synthetic */ AgentRegistrationResults access$800(AgentMain x0) {
        return x0.m_registration;
    }

    private class PingExecutor
    implements Runnable {
        private PingExecutor() {
        }

        @Override
        public void run() {
            try {
                if (!AgentMain.this.m_clientSender.isSending()) {
                    if (!AgentMain.this.m_clientSender.isServerPolling() && !AgentMain.this.isAutoDiscoveryEnabled()) {
                        LOG.info("AgentMain.ping-executor.starting-polling", new Object[0]);
                        AgentMain.this.m_clientSender.startServerPolling();
                    }
                    return;
                }
                if (AgentMain.this.m_clientSender.isServerPolling()) {
                    LOG.info("AgentMain.ping-executor.stop-polling-resume-ping", new Object[0]);
                    AgentMain.this.m_clientSender.stopServerPolling();
                }
                boolean updateAvail = PluginContainer.getInstance().isStarted();
                PingRequest request = new PingRequest(AgentMain.this.getConfiguration().getAgentName(), updateAvail, true);
                ClientRemotePojoFactory factory = AgentMain.this.m_clientSender.getClientRemotePojoFactory();
                CoreServerService server = (CoreServerService)factory.getRemotePojo(CoreServerService.class);
                request = server.ping(request);
                AgentMain.this.serverClockNotification(request.getReplyServerTimestamp());
            }
            catch (Throwable t) {
                if (!AgentMain.this.m_clientSender.isServerPolling() && !AgentMain.this.isAutoDiscoveryEnabled()) {
                    LOG.info("AgentMain.ping-executor.start-polling-after-exception", new Object[]{ThrowableUtil.getAllMessages((Throwable)t)});
                    AgentMain.this.m_clientSender.startServerPolling();
                }
                LOG.warn("AgentMain.ping-executor.server-ping-failed", new Object[]{t});
            }
        }
    }

    private class LastSentConnectAgent {
        public long timestamp = 0L;
        public String serverEndpoint = "";
        public ReadWriteLock rwLock = new ReentrantReadWriteLock();

        private LastSentConnectAgent() {
        }

        public String toString() {
            return this.serverEndpoint + "@" + new Date(this.timestamp);
        }
    }

    private class HelpException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public HelpException(String msg) {
            super(msg);
        }
    }

    private class SenderCreationListener
    implements ServiceContainerSenderCreationListener {
        private SenderCreationListener() {
        }

        public void preCreate(ServiceContainer service_container, RemoteCommunicator remote_communicator, ClientCommandSenderConfiguration sender_configuration) {
        }

        public void postCreate(ServiceContainer service_container, ClientCommandSender sender) {
            for (CommandPreprocessor preproc : sender.getCommandPreprocessors()) {
                if (!(preproc instanceof SecurityTokenCommandPreprocessor)) continue;
                ((SecurityTokenCommandPreprocessor)preproc).setAgentConfiguration(AgentMain.this.m_configuration);
            }
        }
    }

    private class BootstrapLatchCommandListener
    implements CommandListener {
        private final CountDownLatch m_latch = new CountDownLatch(1);
        private final String PING_INTERFACE_NAME = Ping.class.getName();

        private BootstrapLatchCommandListener() {
        }

        public void allowAllCommands(ServiceContainer container) {
            container.removeCommandListener((CommandListener)this);
            this.m_latch.countDown();
        }

        public void receivedCommand(Command command) {
            try {
                if (!(command instanceof RemotePojoInvocationCommand) || !((RemotePojoInvocationCommand)command).getTargetInterfaceName().equals(this.PING_INTERFACE_NAME)) {
                    this.m_latch.await();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void processedCommand(Command command, CommandResponse response) {
        }
    }

    private class PluginContainerConditionalRestartListener
    implements ClientCommandSenderStateListener {
        private PluginContainerConditionalRestartListener() {
        }

        public boolean startedSending(ClientCommandSender sender) {
            try {
                InventoryManager inventoryManager = PluginContainer.getInstance().getInventoryManager();
                if (inventoryManager != null && inventoryManager.hasUpgradeMergeFailed()) {
                    AgentMain.this.m_output.println(MSG.getMsg("AgentMain.pc-conditional-restart", new Object[0]));
                    LOG.info("AgentMain.pc-conditional-restart", new Object[0]);
                    PluginContainerPromptCommand pcCommand = new PluginContainerPromptCommand();
                    pcCommand.execute(AgentMain.this, new String[]{"stop"});
                    pcCommand.execute(AgentMain.this, new String[]{"start"});
                }
            }
            catch (Exception e) {
                LOG.error("Failed to restart the plugin container when server connection established.", new Object[0]);
            }
            return true;
        }

        public boolean stoppedSending(ClientCommandSender sender) {
            return true;
        }
    }

    private class CommandListenerStateListener
    implements ClientCommandSenderStateListener,
    CommandListener {
        private ClientCommandSender senderListeningTo = null;

        private CommandListenerStateListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean startedSending(ClientCommandSender sender) {
            CommandListenerStateListener commandListenerStateListener = this;
            synchronized (commandListenerStateListener) {
                this.senderListeningTo = null;
                ServiceContainer commServices = AgentMain.this.getServiceContainer();
                if (commServices != null) {
                    commServices.removeCommandListener((CommandListener)this);
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean stoppedSending(ClientCommandSender sender) {
            CommandListenerStateListener commandListenerStateListener = this;
            synchronized (commandListenerStateListener) {
                if (this.senderListeningTo == null) {
                    this.senderListeningTo = sender;
                    ServiceContainer commServices = AgentMain.this.getServiceContainer();
                    if (commServices != null) {
                        commServices.addCommandListener((CommandListener)this);
                    }
                }
            }
            return true;
        }

        public void processedCommand(Command command, CommandResponse response) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receivedCommand(Command command) {
            ClientCommandSender clientCommandSender = this.senderListeningTo;
            synchronized (clientCommandSender) {
                boolean changed_mode;
                if (this.senderListeningTo != null && (changed_mode = this.senderListeningTo.startSending())) {
                    LOG.debug("AgentMain.received-msg-started-sender", new Object[0]);
                }
            }
        }
    }

    private class UpdatePluginsStateListener
    implements ClientCommandSenderStateListener {
        private UpdatePluginsStateListener() {
        }

        public boolean startedSending(ClientCommandSender sender) {
            AgentMain.this.updatePluginsNow(sender);
            return false;
        }

        public boolean stoppedSending(ClientCommandSender sender) {
            return true;
        }
    }

    private class RegisterStateListener
    implements ClientCommandSenderStateListener {
        private RegisterStateListener() {
        }

        public boolean startedSending(ClientCommandSender sender) {
            AgentMain.this.registerWithServer(60000L, false);
            return false;
        }

        public boolean stoppedSending(ClientCommandSender sender) {
            return true;
        }
    }
}

