/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent;

import mazz.i18n.Logger;
import org.rhq.core.domain.cloud.composite.FailoverListComposite;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.communications.command.Command;
import org.rhq.enterprise.communications.command.CommandResponse;
import org.rhq.enterprise.communications.command.client.FailureCallback;
import org.rhq.enterprise.communications.command.client.RemoteCommunicator;
import org.rhq.enterprise.communications.util.CommUtils;

public class FailoverFailureCallback
implements FailureCallback {
    private static final String FAILOVER_ATTEMPTS = "rhq.failover-attempts";
    private static final Logger LOG = AgentI18NFactory.getLogger(FailoverFailureCallback.class);
    private AgentMain agent;

    public FailoverFailureCallback(AgentMain agent) {
        this.agent = agent;
    }

    public boolean failureDetected(RemoteCommunicator remoteCommunicator, Command command, CommandResponse response, Throwable throwable) {
        int failoverAttempts;
        Throwable theProblem;
        if (throwable != null) {
            theProblem = throwable;
        } else if (response != null && response.getException() != null) {
            theProblem = response.getException();
        } else {
            return false;
        }
        boolean failoverNow = CommUtils.isExceptionFailoverable((Throwable)theProblem);
        if (!failoverNow) {
            return false;
        }
        try {
            failoverAttempts = Integer.parseInt(command.getConfiguration().getProperty(FAILOVER_ATTEMPTS, "0"));
        }
        catch (Exception e) {
            command.getConfiguration().remove(FAILOVER_ATTEMPTS);
            return false;
        }
        FailoverListComposite failoverList = this.agent.getServerFailoverList();
        if (!failoverList.hasNext()) {
            return false;
        }
        int numFailoverServers = failoverList.size();
        if (failoverAttempts >= numFailoverServers) {
            LOG.warn("AgentMain.too-many-failover-attempts", new Object[]{numFailoverServers, theProblem});
            command.getConfiguration().remove(FAILOVER_ATTEMPTS);
            return false;
        }
        command.getConfiguration().setProperty(FAILOVER_ATTEMPTS, Integer.toString(failoverAttempts + 1));
        this.agent.failoverToNewServer(remoteCommunicator);
        return true;
    }
}

