/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent;

import java.io.InputStream;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.rhq.enterprise.agent.StringUtil;

public class Version {
    public static final String PROP_PRODUCT_NAME = "Product-Name";
    public static final String PROP_PRODUCT_VERSION = "Product-Version";
    public static final String PROP_BUILD_NUMBER = "Build-Number";
    public static final String PROP_BUILD_DATE = "Build-Date";
    public static final String PROP_BUILD_JDK_VENDOR = "Build-Jdk-Vendor";
    public static final String PROP_BUILD_JDK_VERSION = "Build-Jdk";
    public static final String PROP_BUILD_OS_NAME = "Build-OS-Name";
    public static final String PROP_BUILD_OS_VERSION = "Build-OS-Version";
    private static Properties propertiesCache = null;

    public static void main(String[] args) {
        System.out.println("==========");
        if (args.length == 0) {
            System.out.println(Version.getVersionPropertiesAsString());
        } else {
            Properties props = Version.getVersionProperties();
            for (int i = 0; i < args.length; ++i) {
                Date date;
                String key = args[i];
                String value = props.getProperty(key);
                if (value == null) {
                    value = "<unknown>";
                } else if (PROP_BUILD_DATE.equals(key) && (date = Version.getVersionPropertyAsDate(value)) != null) {
                    value = date.toString();
                }
                System.out.println(key + "=" + value);
            }
        }
        System.out.println("==========");
    }

    public static String getProductNameAndVersion() {
        Properties props = Version.getVersionProperties();
        String name = props.getProperty(PROP_PRODUCT_NAME);
        String version = props.getProperty(PROP_PRODUCT_VERSION);
        return "" + name + " " + version;
    }

    public static String getProductName() {
        Properties props = Version.getVersionProperties();
        String name = props.getProperty(PROP_PRODUCT_NAME);
        return name;
    }

    public static String getProductVersion() {
        Properties props = Version.getVersionProperties();
        String version = props.getProperty(PROP_PRODUCT_VERSION);
        return version;
    }

    public static Date getBuildDate() {
        Properties props = Version.getVersionProperties();
        String build_date = props.getProperty(PROP_BUILD_DATE);
        Date date = Version.getVersionPropertyAsDate(build_date);
        return date;
    }

    public static String getBuildNumber() {
        Properties props = Version.getVersionProperties();
        String build_num = props.getProperty(PROP_BUILD_NUMBER);
        return build_num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getVersionProperties() {
        if (propertiesCache == null) {
            ClassLoader cl = Version.class.getClassLoader();
            InputStream stream = cl.getResourceAsStream("rhq-agent-version.properties");
            Properties newProps = new Properties();
            try {
                try {
                    newProps.load(stream);
                }
                finally {
                    stream.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            propertiesCache = newProps;
        }
        Properties retProps = new Properties();
        retProps.putAll((Map<?, ?>)propertiesCache);
        return retProps;
    }

    public static String getVersionPropertiesAsString() {
        Properties props = Version.getVersionProperties();
        Date date = Version.getBuildDate();
        if (date != null) {
            props.setProperty(PROP_BUILD_DATE, date.toString());
        }
        return StringUtil.justifyKeyValueStrings(props);
    }

    public static Date getVersionPropertyAsDate(String date_string) {
        Date ret_date = null;
        if (date_string != null) {
            SimpleDateFormat format = new SimpleDateFormat("dd.MMM.yyyy HH.mm.ss z", Locale.US);
            ret_date = format.parse(date_string, new ParsePosition(0));
        }
        return ret_date;
    }
}

