/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import java.io.PrintWriter;
import java.util.prefs.Preferences;
import mazz.i18n.Msg;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.AgentPrintWriter;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;

public class SetConfigPromptCommand
implements AgentPromptCommand {
    private static final Msg MSG = AgentI18NFactory.getMsg();

    @Override
    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.setconfig", new Object[0]);
    }

    @Override
    public boolean execute(AgentMain agent, String[] args) {
        AgentPrintWriter out = agent.getOut();
        if (args.length != 2) {
            out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
        } else {
            String prop = args[1];
            int i = prop.indexOf("=");
            Preferences prefs = agent.getConfiguration().getPreferences();
            if (i == -1) {
                String name = prop;
                System.getProperties().remove(name);
                prefs.remove(name);
                out.println(MSG.getMsg("PromptCommand.setconfig.removed", new Object[]{name}));
            } else {
                String name = prop.substring(0, i);
                String value = prop.substring(i + 1, prop.length());
                System.setProperty(name, value);
                prefs.put(name, value);
                out.println(MSG.getMsg("PromptCommand.setconfig.set", new Object[]{name, value}));
            }
            this.flush(prefs, out);
        }
        return true;
    }

    @Override
    public String getSyntax() {
        return MSG.getMsg("PromptCommand.setconfig.syntax", new Object[0]);
    }

    @Override
    public String getHelp() {
        return MSG.getMsg("PromptCommand.setconfig.help", new Object[0]);
    }

    @Override
    public String getDetailedHelp() {
        return MSG.getMsg("PromptCommand.setconfig.detailed-help", new Object[0]);
    }

    private void flush(Preferences prefsToFlush, PrintWriter out) {
        try {
            prefsToFlush.flush();
        }
        catch (Exception e) {
            out.println(MSG.getMsg("PromptCommand.setconfig.flush-failed", new Object[]{ThrowableUtil.getAllMessages((Throwable)e)}));
        }
    }
}

