/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import mazz.i18n.Msg;
import org.rhq.enterprise.agent.AgentConfiguration;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.AgentPromptInfo;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.i18n.AgentSetupInstructions;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;
import org.rhq.enterprise.communications.util.SecurityUtil;
import org.rhq.enterprise.communications.util.prefs.BooleanSetupValidityChecker;
import org.rhq.enterprise.communications.util.prefs.DefaultSetupInstruction;
import org.rhq.enterprise.communications.util.prefs.FloatSetupValidityChecker;
import org.rhq.enterprise.communications.util.prefs.InetAddressSetupValidityChecker;
import org.rhq.enterprise.communications.util.prefs.IntegerSetupValidityChecker;
import org.rhq.enterprise.communications.util.prefs.LocalInetAddressNoDefaultSetupInstruction;
import org.rhq.enterprise.communications.util.prefs.LocalInetHostnameSetupInstruction;
import org.rhq.enterprise.communications.util.prefs.LongSetupValidityChecker;
import org.rhq.enterprise.communications.util.prefs.PromptIfEnabledSetupInstruction;
import org.rhq.enterprise.communications.util.prefs.PromptInput;
import org.rhq.enterprise.communications.util.prefs.RegexSetupValidityChecker;
import org.rhq.enterprise.communications.util.prefs.RemotingLocatorUriParamsValidityChecker;
import org.rhq.enterprise.communications.util.prefs.Setup;
import org.rhq.enterprise.communications.util.prefs.SetupInstruction;
import org.rhq.enterprise.communications.util.prefs.SetupValidityChecker;
import org.rhq.enterprise.communications.util.prefs.UrlSetupValidityChecker;

public class SetupPromptCommand
implements AgentPromptCommand {
    private static final Msg MSG = AgentI18NFactory.getMsg();
    private static final Msg SETUPMSG = new Msg(AgentSetupInstructions.BASE_BUNDLE_NAME);

    @Override
    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.setup", new Object[0]);
    }

    @Override
    public boolean execute(AgentMain agent, String[] args) {
        if (agent.isStarted()) {
            agent.getOut().println(MSG.getMsg("PromptCommand.setup.must-be-stopped", new Object[0]));
        } else if (args.length == 1) {
            this.performBasicSetup(agent.getConfiguration().getPreferences(), new AgentPromptInfo(agent), agent.getOut());
        } else if (args.length == 2 && args[1].equals(MSG.getMsg("PromptCommand.setup.advanced", new Object[0]))) {
            this.performAdvancedSetup(agent.getConfiguration().getPreferences(), new AgentPromptInfo(agent), agent.getOut());
        } else if (args.length == 2 && args[1].equals(MSG.getMsg("PromptCommand.setup.all", new Object[0]))) {
            this.performAllSetup(agent.getConfiguration().getPreferences(), new AgentPromptInfo(agent), agent.getOut());
        } else {
            agent.getOut().println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
        }
        return true;
    }

    public void performBasicSetup(Preferences prefs, PromptInput in, PrintWriter out) {
        Setup setup = new Setup(prefs, MSG.getMsg("PromptCommand.setup.intro", new Object[0]), this.createBasicSetupInstructions(), in, out);
        if (setup.setup()) {
            prefs.putBoolean("rhq.agent.configuration-setup-flag", true);
        }
    }

    public void performAdvancedSetup(Preferences prefs, PromptInput in, PrintWriter out) {
        Setup setup = new Setup(prefs, MSG.getMsg("PromptCommand.setup.intro-advanced", new Object[0]), this.createAdvancedSetupInstructions(), in, out);
        if (setup.setup()) {
            prefs.putBoolean("rhq.agent.configuration-setup-flag", true);
        }
    }

    public void performAllSetup(Preferences prefs, PromptInput in, PrintWriter out) {
        Setup setup = new Setup(prefs, MSG.getMsg("PromptCommand.setup.intro-all", new Object[0]), this.createAllSetupInstructions(), in, out);
        if (setup.setup()) {
            prefs.putBoolean("rhq.agent.configuration-setup-flag", true);
        }
    }

    @Override
    public String getSyntax() {
        return MSG.getMsg("PromptCommand.setup.prefix", new Object[0]);
    }

    @Override
    public String getHelp() {
        return MSG.getMsg("PromptCommand.setup.help", new Object[0]);
    }

    @Override
    public String getDetailedHelp() {
        return this.getHelp();
    }

    private List<SetupInstruction> createBasicSetupInstructions() {
        ArrayList<SetupInstruction> instr = new ArrayList<SetupInstruction>();
        instr.add((SetupInstruction)new LocalInetHostnameSetupInstruction("rhq.agent.name", null, SETUPMSG.getMsg("PromptCommand.setup.instruction.agentname.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.agentname.help", new Object[0])));
        instr.add((SetupInstruction)new LocalInetAddressNoDefaultSetupInstruction("rhq.communications.connector.bind-address", SETUPMSG.getMsg("PromptCommand.setup.instruction.connector.bindaddr.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.connector.bindaddr.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.communications.connector.bind-port", AgentSetupInstructions.SETUP_INSTRUCTION_CONNECTORPORT_DEFAULT, (SetupValidityChecker)new IntegerSetupValidityChecker(Integer.valueOf(1), Integer.valueOf(65535)), SETUPMSG.getMsg("PromptCommand.setup.instruction.connector.bindport.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.connector.bindport.help", new Object[0])));
        instr.add((SetupInstruction)new ServerAddressSetupInstruction("rhq.agent.server.bind-address", "127.0.0.1", new InetAddressSetupValidityChecker(), SETUPMSG.getMsg("PromptCommand.setup.instruction.serveruri.bindaddr.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.serveruri.bindaddr.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.server.bind-port", AgentSetupInstructions.SETUP_INSTRUCTION_SERVERPORT_DEFAULT, (SetupValidityChecker)new IntegerSetupValidityChecker(Integer.valueOf(1), Integer.valueOf(65535)), SETUPMSG.getMsg("PromptCommand.setup.instruction.serveruri.bindport.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.serveruri.bindport.help", new Object[0])));
        return instr;
    }

    private List<SetupInstruction> createAdvancedSetupInstructions() {
        ArrayList<SetupInstruction> instr = new ArrayList<SetupInstruction>();
        instr.addAll(this.createBasicSetupInstructions());
        String MIN_KEYSTORE_PASSWORD_LENGTH = ".{6,}";
        String VALID_SERVER_TRANSPORTS_REGEX = "servlet|sslservlet|socket|sslsocket";
        instr.add(3, (SetupInstruction)new DefaultSetupInstruction("rhq.communications.connector.transport", "socket", null, SETUPMSG.getMsg("PromptCommand.setup.instruction.connector.transport.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.connector.transport.help", new Object[0])));
        instr.add(4, (SetupInstruction)new DefaultSetupInstruction("rhq.communications.connector.transport-params", "numAcceptThreads=1&maxPoolSize=303&clientMaxPoolSize=304&socketTimeout=60000&enableTcpNoDelay=true&backlog=200", (SetupValidityChecker)new RemotingLocatorUriParamsValidityChecker(), SETUPMSG.getMsg("PromptCommand.setup.instruction.connector.transportparams.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.connector.transportparams.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.server.transport", "servlet", (SetupValidityChecker)new RegexSetupValidityChecker("servlet|sslservlet|socket|sslsocket", "Setup.not-servlet-transport", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.serveruri.transport.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.serveruri.transport.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.server.transport-params", "/jboss-remoting-servlet-invoker/ServerInvokerServlet", (SetupValidityChecker)new RemotingLocatorUriParamsValidityChecker(), SETUPMSG.getMsg("PromptCommand.setup.instruction.serveruri.transportparams.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.serveruri.transportparams.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.server.alias", AgentSetupInstructions.SETUP_INSTRUCTION_SERVERALIAS_DEFAULT, null, SETUPMSG.getMsg("PromptCommand.setup.instruction.serveralias.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.serveralias.help", new Object[0])));
        instr.add((SetupInstruction)new SecurityEnabledSetupInstruction("rhq.communications.connector.transport", "rhq.communications.connector.security.client-auth-mode", "none", new ClientAuthModeSetupValidityChecker(), SETUPMSG.getMsg("PromptCommand.setup.instruction.server-client-auth-mode.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.server-client-auth-mode.help", new Object[0])));
        instr.add((SetupInstruction)new SecurityEnabledSetupInstruction("rhq.agent.server.transport", "rhq.agent.client.security.server-auth-mode-enabled", AgentSetupInstructions.SETUP_INSTRUCTION_CLIENTSERVERAUTHMODEENABLED_DEFAULT, (SetupValidityChecker)new BooleanSetupValidityChecker(), SETUPMSG.getMsg("PromptCommand.setup.instruction.client-server-auth-mode-enabled.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.client-server-auth-mode-enabled.help", new Object[0])));
        instr.add((SetupInstruction)new SecurityEnabledSetupInstruction("rhq.communications.connector.transport", "rhq.communications.connector.security.secure-socket-protocol", "TLS", null, SETUPMSG.getMsg("PromptCommand.setup.instruction.server-secure-protocol.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.server-secure-protocol.help", new Object[0])));
        instr.add((SetupInstruction)new SecurityDataFileSetupInstruction("rhq.communications.connector.transport", "rhq.communications.connector.security.keystore.file", "keystore.dat", null, SETUPMSG.getMsg("PromptCommand.setup.instruction.server-keystore-file.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.server-keystore-file.help", new Object[0])));
        instr.add((SetupInstruction)new SecurityEnabledSetupInstruction("rhq.communications.connector.transport", "rhq.communications.connector.security.keystore.algorithm", AgentSetupInstructions.SETUP_INSTRUCTION_SERVERKEYSTOREALGORITHM_DEFAULT, null, SETUPMSG.getMsg("PromptCommand.setup.instruction.server-keystore-alg.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.server-keystore-alg.help", new Object[0])));
        instr.add((SetupInstruction)new SecurityEnabledSetupInstruction("rhq.communications.connector.transport", "rhq.communications.connector.security.keystore.type", "JKS", null, SETUPMSG.getMsg("PromptCommand.setup.instruction.server-keystore-type.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.server-keystore-type.help", new Object[0])));
        instr.add((SetupInstruction)new SecurityEnabledSetupInstruction("rhq.communications.connector.transport", "rhq.communications.connector.security.keystore.password", "rhqpwd", (SetupValidityChecker)new RegexSetupValidityChecker(".{6,}", "SecurityUtil.keystore-password-min-length", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.server-keystore-pw.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.server-keystore-pw.help", new Object[0]), true));
        instr.add((SetupInstruction)new SecurityEnabledSetupInstruction("rhq.communications.connector.transport", "rhq.communications.connector.security.keystore.key-password", "rhqpwd", (SetupValidityChecker)new RegexSetupValidityChecker(".{6,}", "SecurityUtil.keystore-password-min-length", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.server-keystore-key-pw.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.server-keystore-key-pw.help", new Object[0]), true));
        instr.add((SetupInstruction)new SecurityEnabledSetupInstruction("rhq.communications.connector.transport", "rhq.communications.connector.security.keystore.alias", "rhq", null, SETUPMSG.getMsg("PromptCommand.setup.instruction.server-keystore-alias.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.server-keystore-alias.help", new Object[0])));
        instr.add((SetupInstruction)new SecurityDataFileSetupInstruction("rhq.communications.connector.transport", "rhq.communications.connector.security.truststore.file", "truststore.dat", null, SETUPMSG.getMsg("PromptCommand.setup.instruction.server-truststore-file.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.server-truststore-file.help", new Object[0])));
        instr.add((SetupInstruction)new SecurityEnabledSetupInstruction("rhq.communications.connector.transport", "rhq.communications.connector.security.truststore.algorithm", AgentSetupInstructions.SETUP_INSTRUCTION_SERVERTRUSTSTOREALGORITHM_DEFAULT, null, SETUPMSG.getMsg("PromptCommand.setup.instruction.server-truststore-alg.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.server-truststore-alg.help", new Object[0])));
        instr.add((SetupInstruction)new SecurityEnabledSetupInstruction("rhq.communications.connector.transport", "rhq.communications.connector.security.truststore.type", "JKS", null, SETUPMSG.getMsg("PromptCommand.setup.instruction.server-truststore-type.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.server-truststore-type.help", new Object[0])));
        instr.add((SetupInstruction)new SecurityEnabledSetupInstruction("rhq.communications.connector.transport", "rhq.communications.connector.security.truststore.password", "", (SetupValidityChecker)new RegexSetupValidityChecker(".{6,}", "SecurityUtil.keystore-password-min-length", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.server-truststore-pw.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.server-truststore-pw.help", new Object[0]), true));
        instr.add((SetupInstruction)new SecurityEnabledSetupInstruction("rhq.agent.server.transport", "rhq.agent.client.security.secure-socket-protocol", "TLS", null, SETUPMSG.getMsg("PromptCommand.setup.instruction.client-secure-protocol.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.client-secure-protocol.help", new Object[0])));
        instr.add((SetupInstruction)new SecurityDataFileSetupInstruction("rhq.agent.server.transport", "rhq.agent.client.security.keystore.file", "keystore.dat", null, SETUPMSG.getMsg("PromptCommand.setup.instruction.client-keystore-file.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.client-keystore-file.help", new Object[0])));
        instr.add((SetupInstruction)new SecurityEnabledSetupInstruction("rhq.agent.server.transport", "rhq.agent.client.security.keystore.algorithm", AgentSetupInstructions.SETUP_INSTRUCTION_CLIENTKEYSTOREALGORITHM_DEFAULT, null, SETUPMSG.getMsg("PromptCommand.setup.instruction.client-keystore-alg.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.client-keystore-alg.help", new Object[0])));
        instr.add((SetupInstruction)new SecurityEnabledSetupInstruction("rhq.agent.server.transport", "rhq.agent.client.security.keystore.type", "JKS", null, SETUPMSG.getMsg("PromptCommand.setup.instruction.client-keystore-type.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.client-keystore-type.help", new Object[0])));
        instr.add((SetupInstruction)new SecurityEnabledSetupInstruction("rhq.agent.server.transport", "rhq.agent.client.security.keystore.password", "rhqpwd", (SetupValidityChecker)new RegexSetupValidityChecker(".{6,}", "SecurityUtil.keystore-password-min-length", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.client-keystore-pw.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.client-keystore-pw.help", new Object[0]), true));
        instr.add((SetupInstruction)new SecurityEnabledSetupInstruction("rhq.agent.server.transport", "rhq.agent.client.security.keystore.key-password", "rhqpwd", (SetupValidityChecker)new RegexSetupValidityChecker(".{6,}", "SecurityUtil.keystore-password-min-length", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.client-keystore-key-pw.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.client-keystore-key-pw.help", new Object[0]), true));
        instr.add((SetupInstruction)new SecurityEnabledSetupInstruction("rhq.agent.server.transport", "rhq.agent.client.security.keystore.alias", "rhq", null, SETUPMSG.getMsg("PromptCommand.setup.instruction.client-keystore-alias.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.client-keystore-alias.help", new Object[0])));
        instr.add((SetupInstruction)new SecurityDataFileSetupInstruction("rhq.agent.server.transport", "rhq.agent.client.security.truststore.file", "truststore.dat", null, SETUPMSG.getMsg("PromptCommand.setup.instruction.client-truststore-file.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.client-truststore-file.help", new Object[0])));
        instr.add((SetupInstruction)new SecurityEnabledSetupInstruction("rhq.agent.server.transport", "rhq.agent.client.security.truststore.algorithm", AgentSetupInstructions.SETUP_INSTRUCTION_CLIENTTRUSTSTOREALGORITHM_DEFAULT, null, SETUPMSG.getMsg("PromptCommand.setup.instruction.client-truststore-alg.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.client-truststore-alg.help", new Object[0])));
        instr.add((SetupInstruction)new SecurityEnabledSetupInstruction("rhq.agent.server.transport", "rhq.agent.client.security.truststore.type", "JKS", null, SETUPMSG.getMsg("PromptCommand.setup.instruction.client-truststore-type.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.client-truststore-type.help", new Object[0])));
        instr.add((SetupInstruction)new SecurityEnabledSetupInstruction("rhq.agent.server.transport", "rhq.agent.client.security.truststore.password", "", (SetupValidityChecker)new RegexSetupValidityChecker(".{6,}", "SecurityUtil.keystore-password-min-length", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.client-truststore-pw.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.client-truststore-pw.help", new Object[0]), true));
        return instr;
    }

    private List<SetupInstruction> createAllSetupInstructions() {
        ArrayList<SetupInstruction> instr = new ArrayList<SetupInstruction>();
        instr.addAll(this.createAdvancedSetupInstructions());
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.client.server-polling-interval-msecs", AgentSetupInstructions.SETUP_INSTRUCTION_SERVERPOLLING_DEFAULT, (SetupValidityChecker)new LongSetupValidityChecker(Long.valueOf(0L), null), SETUPMSG.getMsg("PromptCommand.setup.instruction.serverpolling.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.serverpolling.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.server-auto-detection", AgentSetupInstructions.SETUP_INSTRUCTION_SERVERAUTODETECT_DEFAULT, (SetupValidityChecker)new BooleanSetupValidityChecker(), SETUPMSG.getMsg("PromptCommand.setup.instruction.serverautodetect.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.serverautodetect.help", new Object[0])));
        instr.add(new MulticastDetectorEnabledSetupInstruction());
        instr.add((SetupInstruction)new PromptIfEnabledSetupInstruction("rhq.communications.multicast-detector.multicast-address", "224.16.16.16", (SetupValidityChecker)new InetAddressSetupValidityChecker(), SETUPMSG.getMsg("PromptCommand.setup.instruction.multicastdetector-mcaddr.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.multicastdetector-mcaddr.help", new Object[0]), "rhq.communications.multicast-detector.enabled", false));
        instr.add((SetupInstruction)new PromptIfEnabledSetupInstruction("rhq.communications.multicast-detector.bind-address", "127.0.0.1", (SetupValidityChecker)new InetAddressSetupValidityChecker(), SETUPMSG.getMsg("PromptCommand.setup.instruction.multicastdetector-bindaddr.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.multicastdetector-bindaddr.help", new Object[0]), "rhq.communications.multicast-detector.enabled", false));
        instr.add((SetupInstruction)new PromptIfEnabledSetupInstruction("rhq.communications.multicast-detector.port", "16162", (SetupValidityChecker)new IntegerSetupValidityChecker(Integer.valueOf(1), Integer.valueOf(65535)), SETUPMSG.getMsg("PromptCommand.setup.instruction.multicastdetector-port.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.multicastdetector-port.help", new Object[0]), "rhq.communications.multicast-detector.enabled", false));
        instr.add((SetupInstruction)new PromptIfEnabledSetupInstruction("rhq.communications.multicast-detector.default-time-delay", "5000", (SetupValidityChecker)new LongSetupValidityChecker(Long.valueOf(1000L), null), SETUPMSG.getMsg("PromptCommand.setup.instruction.multicastdetector-defaulttimedelay.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.multicastdetector-defaulttimedelay.help", new Object[0]), "rhq.communications.multicast-detector.enabled", false));
        instr.add((SetupInstruction)new PromptIfEnabledSetupInstruction("rhq.communications.multicast-detector.heartbeat-time-delay", "1000", (SetupValidityChecker)new LongSetupValidityChecker(Long.valueOf(1000L), null), SETUPMSG.getMsg("PromptCommand.setup.instruction.multicastdetector-heartbeattimedelay.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.multicastdetector-heartbeattimedelay.help", new Object[0]), "rhq.communications.multicast-detector.enabled", false));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.update-plugins-at-startup", AgentSetupInstructions.SETUP_INSTRUCTION_UPDATEPLUGINSATSTARTUP_DEFAULT, (SetupValidityChecker)new BooleanSetupValidityChecker(), SETUPMSG.getMsg("PromptCommand.setup.instruction.updateplugins.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.updateplugins.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.test-failover-list-at-startup", AgentSetupInstructions.SETUP_INSTRUCTION_TESTFAILOVERLISTATSTARTUP_DEFAULT, (SetupValidityChecker)new BooleanSetupValidityChecker(), SETUPMSG.getMsg("PromptCommand.setup.instruction.testfailoverlist.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.testfailoverlist.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.agent-update.enabled", AgentSetupInstructions.SETUP_INSTRUCTION_AGENTUPDATEENABLED_DEFAULT, (SetupValidityChecker)new BooleanSetupValidityChecker(), SETUPMSG.getMsg("PromptCommand.setup.instruction.agentupdateenabled.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.agentupdateenabled.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.agent-update.version-url", AgentSetupInstructions.SETUP_INSTRUCTION_AGENTUPDATEVERSIONURL_DEFAULT, (SetupValidityChecker)new UrlSetupValidityChecker(), SETUPMSG.getMsg("PromptCommand.setup.instruction.agentupdateversionurl.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.agentupdateversionurl.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.agent-update.download-url", AgentSetupInstructions.SETUP_INSTRUCTION_AGENTUPDATEDOWNLOADURL_DEFAULT, (SetupValidityChecker)new UrlSetupValidityChecker(), SETUPMSG.getMsg("PromptCommand.setup.instruction.agentupdatedownloadurl.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.agentupdatedownloadurl.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.register-with-server-at-startup", AgentSetupInstructions.SETUP_INSTRUCTION_REGISTERWITHSERVERATSTARTUP_DEFAULT, (SetupValidityChecker)new BooleanSetupValidityChecker(), SETUPMSG.getMsg("PromptCommand.setup.instruction.registerwithserver.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.registerwithserver.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.wait-for-server-at-startup-msecs", AgentSetupInstructions.SETUP_INSTRUCTION_WAITFORSERVERATSTARTUPMSECS_DEFAULT, (SetupValidityChecker)new LongSetupValidityChecker(Long.valueOf(0L), null), SETUPMSG.getMsg("PromptCommand.setup.instruction.waitforservermsecs.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.waitforservermsecs.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.primary-server-switchover-check-interval-msecs", AgentSetupInstructions.SETUP_INSTRUCTION_PRIMARYSERVERSWITCHOVERCHECKINTERVAL_DEFAULT, (SetupValidityChecker)new LongSetupValidityChecker(Long.valueOf(0L), null), SETUPMSG.getMsg("PromptCommand.setup.instruction.primaryserverswitchovercheckinterval.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.primaryserverswitchovercheckinterval.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.disable-native-system", AgentSetupInstructions.SETUP_INSTRUCTION_DISABLENATIVESYSTEM_DEFAULT, (SetupValidityChecker)new BooleanSetupValidityChecker(), SETUPMSG.getMsg("PromptCommand.setup.instruction.disablenativesystem.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.disablenativesystem.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.plugins.server-discovery.period-secs", AgentSetupInstructions.SETUP_INSTRUCTION_PLUGINSSERVERDISCOVERYPERIOD_DEFAULT, (SetupValidityChecker)new LongSetupValidityChecker(Long.valueOf(1L), null), SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.server-discovery-period.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.server-discovery-period.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.plugins.server-discovery.initial-delay-secs", AgentSetupInstructions.SETUP_INSTRUCTION_PLUGINSSERVERDISCOVERYINITIALDELAY_DEFAULT, (SetupValidityChecker)new LongSetupValidityChecker(Long.valueOf(1L), null), SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.server-discovery-initialdelay.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.server-discovery-initialdelay.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.plugins.service-discovery.period-secs", AgentSetupInstructions.SETUP_INSTRUCTION_PLUGINSSERVICEDISCOVERYPERIOD_DEFAULT, (SetupValidityChecker)new LongSetupValidityChecker(Long.valueOf(1L), null), SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.service-discovery-period.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.service-discovery-period.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.plugins.service-discovery.initial-delay-secs", AgentSetupInstructions.SETUP_INSTRUCTION_PLUGINSSERVICEDISCOVERYINITIALDELAY_DEFAULT, (SetupValidityChecker)new LongSetupValidityChecker(Long.valueOf(1L), null), SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.service-discovery-initialdelay.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.service-discovery-initialdelay.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.plugins.availability-scan.period-secs", AgentSetupInstructions.SETUP_INSTRUCTION_PLUGINSAVAILSCANPERIOD_DEFAULT, (SetupValidityChecker)new LongSetupValidityChecker(Long.valueOf(1L), null), SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.avail-scan-period.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.avail-scan-period.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.plugins.availability-scan.initial-delay-secs", AgentSetupInstructions.SETUP_INSTRUCTION_PLUGINSAVAILSCANINITIALDELAY_DEFAULT, (SetupValidityChecker)new LongSetupValidityChecker(Long.valueOf(1L), null), SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.avail-scan-initialdelay.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.avail-scan-initialdelay.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.plugins.measurement-collection.initial-delay-secs", AgentSetupInstructions.SETUP_INSTRUCTION_PLUGINSMEASUREMENTCOLLINITIALDELAY_DEFAULT, (SetupValidityChecker)new LongSetupValidityChecker(Long.valueOf(1L), null), SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.meas-coll-initialdelay.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.meas-coll-initialdelay.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.plugins.measurement-collection.threadpool-size", AgentSetupInstructions.SETUP_INSTRUCTION_PCMEASUREMENTTHREADCOUNT_DEFAULT, (SetupValidityChecker)new IntegerSetupValidityChecker(Integer.valueOf(1), null), SETUPMSG.getMsg("PromptCommand.setup.instruction.measurementthreadcount.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.measurementthreadcount.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.plugins.operation-invoker.threadpool-size", AgentSetupInstructions.SETUP_INSTRUCTION_PCOPERATIONTHREADCOUNT_DEFAULT, (SetupValidityChecker)new IntegerSetupValidityChecker(Integer.valueOf(1), null), SETUPMSG.getMsg("PromptCommand.setup.instruction.operationthreadcount.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.operationthreadcount.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.plugins.operation-invocation-timeout-secs", AgentSetupInstructions.SETUP_INSTRUCTION_PCOPINVOCATIONTIMEOUT_DEFAULT, (SetupValidityChecker)new LongSetupValidityChecker(Long.valueOf(1L), null), SETUPMSG.getMsg("PromptCommand.setup.instruction.opinvocationtimeout.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.opinvocationtimeout.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.plugins.drift-detection.period-secs", AgentSetupInstructions.SETUP_INSTRUCTION_PLUGINSDRIFTDETECTIONPERIOD_DEFAULT, (SetupValidityChecker)new LongSetupValidityChecker(Long.valueOf(0L), null), SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.driftdetection-period.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.driftdiscovery-period.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.plugins.drift-detection.initial-delay-secs", AgentSetupInstructions.SETUP_INSTRUCTION_PLUGINSDRIFTDETECTIONINITIALDELAY_DEFAULT, (SetupValidityChecker)new LongSetupValidityChecker(Long.valueOf(1L), null), SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.driftdetection-initialdelay.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.driftdetection-initialdelay.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.plugins.content-discovery.period-secs", AgentSetupInstructions.SETUP_INSTRUCTION_PLUGINSCONTENTDISCOVERYPERIOD_DEFAULT, (SetupValidityChecker)new LongSetupValidityChecker(Long.valueOf(0L), null), SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.contentdiscovery-period.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.contentdiscovery-period.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.plugins.content-discovery.initial-delay-secs", AgentSetupInstructions.SETUP_INSTRUCTION_PLUGINSCONTENTDISCOVERYINITIALDELAY_DEFAULT, (SetupValidityChecker)new LongSetupValidityChecker(Long.valueOf(1L), null), SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.contentdiscovery-initialdelay.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.contentdiscovery-initialdelay.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.plugins.content-discovery.threadpool-size", AgentSetupInstructions.SETUP_INSTRUCTION_PLUGINSCONTENTDISCOVERYTHREADCOUNT_DEFAULT, (SetupValidityChecker)new IntegerSetupValidityChecker(Integer.valueOf(1), null), SETUPMSG.getMsg("PromptCommand.setup.instruction.contentdiscoverythreadcount.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.contentdiscoverythreadcount.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.plugins.configuration-discovery.period-secs", AgentSetupInstructions.SETUP_INSTRUCTION_PLUGINSCONFIGURATIONDISCOVERYPERIOD_DEFAULT, (SetupValidityChecker)new LongSetupValidityChecker(Long.valueOf(0L), null), SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.configurationdiscovery-period.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.configurationdiscovery-period.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.plugins.configuration-discovery.initial-delay-secs", AgentSetupInstructions.SETUP_INSTRUCTION_PLUGINSCONFIGURATIONDISCOVERYINITIALDELAY_DEFAULT, (SetupValidityChecker)new LongSetupValidityChecker(Long.valueOf(1L), null), SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.configurationdiscovery-initialdelay.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.configurationdiscovery-initialdelay.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.plugins.event-sender.period-secs", AgentSetupInstructions.SETUP_INSTRUCTION_PLUGINSEVENTSENDERPERIOD_DEFAULT, (SetupValidityChecker)new LongSetupValidityChecker(Long.valueOf(30L), null), SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.eventsender-period.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.eventsender-period.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.plugins.event-sender.initial-delay-secs", AgentSetupInstructions.SETUP_INSTRUCTION_PLUGINSEVENTSENDERINITIALDELAY_DEFAULT, (SetupValidityChecker)new LongSetupValidityChecker(Long.valueOf(30L), null), SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.eventsender-initialdelay.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.eventsender-initialdelay.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.plugins.event-report.max-per-source", AgentSetupInstructions.SETUP_INSTRUCTION_PLUGINSEVENTREPORTMAXPERSRC_DEFAULT, (SetupValidityChecker)new IntegerSetupValidityChecker(Integer.valueOf(0), null), SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.eventreport-maxpersrc.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.eventreport-maxpersrc.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.plugins.event-report.max-total", AgentSetupInstructions.SETUP_INSTRUCTION_PLUGINSEVENTREPORTMAXTOTAL_DEFAULT, (SetupValidityChecker)new IntegerSetupValidityChecker(Integer.valueOf(0), null), SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.eventreport-maxtotal.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.eventreport-maxtotal.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.vm-health-check.interval-msecs", AgentSetupInstructions.SETUP_INSTRUCTION_VMHEALTHCHECKINTERVAL_DEFAULT, (SetupValidityChecker)new LongSetupValidityChecker(Long.valueOf(0L), null), SETUPMSG.getMsg("PromptCommand.setup.instruction.vm-health-check.interval.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.vm-health-check.interval.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.vm-health-check.low-heap-mem-threshold", AgentSetupInstructions.SETUP_INSTRUCTION_VMHEALTHCHECKLOWHEAPMEMTHRESHOLD_DEFAULT, (SetupValidityChecker)new FloatSetupValidityChecker(Float.valueOf(0.0f), Float.valueOf(1.0f)), SETUPMSG.getMsg("PromptCommand.setup.instruction.vm-health-check.low-heap-mem-threshold.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.vm-health-check.low-heap-mem-threshold.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.vm-health-check.low-nonheap-mem-threshold", AgentSetupInstructions.SETUP_INSTRUCTION_VMHEALTHCHECKLOWNONHEAPMEMTHRESHOLD_DEFAULT, (SetupValidityChecker)new FloatSetupValidityChecker(Float.valueOf(0.0f), Float.valueOf(1.0f)), SETUPMSG.getMsg("PromptCommand.setup.instruction.vm-health-check.low-nonheap-mem-threshold.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.vm-health-check.low-nonheap-mem-threshold.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.client.command-timeout-msecs", AgentSetupInstructions.SETUP_INSTRUCTION_CLIENTSENDERTIMEOUT_DEFAULT, (SetupValidityChecker)new LongSetupValidityChecker(Long.valueOf(-1L), null), SETUPMSG.getMsg("PromptCommand.setup.instruction.sender.timeout.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.sender.timeout.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.client.retry-interval-msecs", AgentSetupInstructions.SETUP_INSTRUCTION_CLIENTSENDERRETRYINTERVAL_DEFAULT, (SetupValidityChecker)new LongSetupValidityChecker(Long.valueOf(1000L), null), SETUPMSG.getMsg("PromptCommand.setup.instruction.sender.retry.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.sender.retry.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.client.max-retries", AgentSetupInstructions.SETUP_INSTRUCTION_CLIENTSENDERMAXRETRIES_DEFAULT, (SetupValidityChecker)new IntegerSetupValidityChecker(Integer.valueOf(0), null), SETUPMSG.getMsg("PromptCommand.setup.instruction.sender.maxretries.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.sender.maxretries.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.client.max-concurrent", AgentSetupInstructions.SETUP_INSTRUCTION_CLIENTSENDERMAXCONCURRENT_DEFAULT, (SetupValidityChecker)new LongSetupValidityChecker(Long.valueOf(1L), null), SETUPMSG.getMsg("PromptCommand.setup.instruction.sender.maxconcurrent.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.sender.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.client.queue-size", AgentSetupInstructions.SETUP_INSTRUCTION_CLIENTSENDERQSIZE_DEFAULT, (SetupValidityChecker)new LongSetupValidityChecker(Long.valueOf(100L), null), SETUPMSG.getMsg("PromptCommand.setup.instruction.sender.qsize.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.sender.qsize.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.client.queue-throttling", "50:5000", (SetupValidityChecker)new ParametersSetupValidityChecker(ParametersType.QUEUE_THROTTLING_PARAMS), SETUPMSG.getMsg("PromptCommand.setup.instruction.sender.qthrottling.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.sender.qthrottling.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.client.send-throttling", "100:1000", (SetupValidityChecker)new ParametersSetupValidityChecker(ParametersType.SEND_THROTTLING_PARAMS), SETUPMSG.getMsg("PromptCommand.setup.instruction.sender.sendthrottling.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.sender.sendthrottling.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.communications.remote-stream-max-idle-time-msecs", AgentSetupInstructions.SETUP_INSTRUCTION_STREAMIDLE_DEFAULT, (SetupValidityChecker)new LongSetupValidityChecker(Long.valueOf(5000L), Long.valueOf(3600000L)), SETUPMSG.getMsg("PromptCommand.setup.instruction.streamidle.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.streamidle.help", new Object[0])));
        instr.add(new DataDirectorySetupInstruction("rhq.agent.data-directory", "data", null, SETUPMSG.getMsg("PromptCommand.setup.instruction.datadir.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.datadir.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.plugins.directory", "plugins", null, SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.directory.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.plugins.directory.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.client.command-spool-file.params", "10000000:75", (SetupValidityChecker)new ParametersSetupValidityChecker(ParametersType.COMMAND_SPOOL_PARAMS), SETUPMSG.getMsg("PromptCommand.setup.instruction.sender.spoolfileparams.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.sender.spoolfileparams.help", new Object[0])));
        instr.add((SetupInstruction)new DefaultSetupInstruction("rhq.agent.client.command-spool-file.compressed", AgentSetupInstructions.SETUP_INSTRUCTION_CLIENTSENDERCOMPRESSSPOOL_DEFAULT, (SetupValidityChecker)new BooleanSetupValidityChecker(), SETUPMSG.getMsg("PromptCommand.setup.instruction.sender.compressspool.prompt", new Object[0]), SETUPMSG.getMsg("PromptCommand.setup.instruction.sender.compressspool.help", new Object[0])));
        return instr;
    }

    private class ServerAddressSetupInstruction
    extends DefaultSetupInstruction {
        public ServerAddressSetupInstruction(String pref_name, String default_value, InetAddressSetupValidityChecker validity_checker, String prompt_msg, String help) {
            super(pref_name, default_value, (SetupValidityChecker)validity_checker, prompt_msg, help, false);
        }

        public void preProcess() {
            String address = new AgentConfiguration(this.getPreferences()).getServerBindAddress();
            if (address != null) {
                this.setDefaultValue(address);
            } else {
                super.preProcess();
            }
        }
    }

    private class SecurityDataFileSetupInstruction
    extends SecurityEnabledSetupInstruction {
        public SecurityDataFileSetupInstruction(String security_preference_name, String preference_name, String default_value, SetupValidityChecker validity_checker, String prompt_message, String help_message) throws IllegalArgumentException {
            super(security_preference_name, preference_name, default_value, validity_checker, prompt_message, help_message);
        }

        @Override
        public void preProcess() {
            String data_dir = new AgentConfiguration(this.getPreferences()).getDataDirectoryIfDefined();
            String default_file = this.getDefaultValue();
            if (data_dir != null && default_file != null) {
                this.setDefaultValue(new File(data_dir, default_file).getPath());
            }
            super.preProcess();
        }
    }

    private class SecurityEnabledSetupInstruction
    extends DefaultSetupInstruction {
        private String m_securityPreferenceName;

        public SecurityEnabledSetupInstruction(String security_preference_name, String preference_name, String default_value, SetupValidityChecker validity_checker, String prompt_message, String help_message, boolean no_echo) throws IllegalArgumentException {
            super(preference_name, default_value, validity_checker, prompt_message, help_message, no_echo);
            this.m_securityPreferenceName = security_preference_name;
        }

        public SecurityEnabledSetupInstruction(String security_preference_name, String preference_name, String default_value, SetupValidityChecker validity_checker, String prompt_message, String help_message) throws IllegalArgumentException {
            this(security_preference_name, preference_name, default_value, validity_checker, prompt_message, help_message, false);
        }

        public void preProcess() {
            super.preProcess();
            if (!SecurityUtil.isTransportSecure((String)this.getPreferences().get(this.m_securityPreferenceName, ""))) {
                this.setPromptMessage(null);
            }
        }
    }

    private class ClientAuthModeSetupValidityChecker
    implements SetupValidityChecker {
        private ClientAuthModeSetupValidityChecker() {
        }

        public boolean checkValidity(String pref_name, String value_to_check, Preferences preferences, PrintWriter out) {
            boolean is_valid;
            String none = "none";
            String want = "want";
            String need = "need";
            boolean bl = is_valid = none.equals(value_to_check) || want.equals(value_to_check) || need.equals(value_to_check);
            if (!is_valid) {
                out.println(MSG.getMsg("PromptCommand.setup.bad-client-auth-mode", new Object[]{value_to_check, none, want, need}));
            }
            return is_valid;
        }
    }

    private class ParametersSetupValidityChecker
    implements SetupValidityChecker {
        private final ParametersType m_paramsType;

        ParametersSetupValidityChecker(ParametersType params_id) {
            this.m_paramsType = params_id;
        }

        public boolean checkValidity(String pref_name, String value_to_check, Preferences preferences, PrintWriter out) {
            boolean is_valid = true;
            String err_msg_key = null;
            if (value_to_check != null) {
                AgentConfiguration agent_config = new AgentConfiguration(preferences);
                if (this.m_paramsType.equals((Object)ParametersType.QUEUE_THROTTLING_PARAMS)) {
                    err_msg_key = "PromptCommand.setup.bad-queue-throttling-params";
                    is_valid = null != agent_config.isClientSenderQueueThrottlingValueValid(value_to_check);
                } else if (this.m_paramsType.equals((Object)ParametersType.SEND_THROTTLING_PARAMS)) {
                    err_msg_key = "PromptCommand.setup.bad-send-throttling-params";
                    is_valid = null != agent_config.isClientSenderSendThrottlingValueValid(value_to_check);
                } else if (this.m_paramsType.equals((Object)ParametersType.COMMAND_SPOOL_PARAMS)) {
                    err_msg_key = "PromptCommand.setup.bad-command-spool-params";
                    boolean bl = is_valid = null != agent_config.isClientSenderCommandSpoolFileParamsValueValid(value_to_check);
                }
            }
            if (!is_valid) {
                out.println(MSG.getMsg(err_msg_key, new Object[]{value_to_check}));
            }
            return is_valid;
        }
    }

    private static enum ParametersType {
        QUEUE_THROTTLING_PARAMS,
        SEND_THROTTLING_PARAMS,
        COMMAND_SPOOL_PARAMS;

    }

    private class DataDirectorySetupInstruction
    extends SetupInstruction {
        public DataDirectorySetupInstruction(String preference_name, String default_value, SetupValidityChecker validity_checker, String prompt_message, String help_message) throws IllegalArgumentException {
            super(preference_name, default_value, validity_checker, prompt_message, help_message, false);
        }

        public void postProcess() {
            super.postProcess();
            Preferences preferences = this.getPreferences();
            AgentConfiguration agent_config = new AgentConfiguration(preferences);
            File agent_dir = agent_config.getDataDirectory();
            preferences.put("rhq.agent.data-directory", agent_dir.getPath());
            preferences.put("rhq.communications.data-directory", agent_dir.getPath());
        }
    }

    private class MulticastDetectorEnabledSetupInstruction
    extends SetupInstruction {
        public MulticastDetectorEnabledSetupInstruction() {
            super("rhq.communications.multicast-detector.enabled", null, null, null, SETUPMSG.getMsg("PromptCommand.setup.instruction.multicastdetector.help", new Object[0]), false);
        }

        public void preProcess() {
            super.preProcess();
            if (this.getPreferences().getBoolean("rhq.agent.server-auto-detection", false)) {
                this.setDefaultValue(Boolean.TRUE.toString());
            } else {
                this.setDefaultValue(Boolean.FALSE.toString());
            }
        }
    }
}

