/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security;

import java.io.IOException;
import java.security.CodeSource;
import javax.security.jacc.PolicyContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.jboss.logging.Logger;
import org.jboss.metadata.WebMetaData;
import org.jboss.web.tomcat.security.HttpServletRequestPolicyContextHandler;
import org.jboss.web.tomcat.security.SecurityAssociationActions;

public class JaccContextValve
extends ValveBase {
    private static Logger log = Logger.getLogger(JaccContextValve.class);
    public static ThreadLocal activeCS = new ThreadLocal();
    public static ThreadLocal activeWebMetaData = new ThreadLocal();
    private String contextID;
    private CodeSource warCS;
    private boolean trace;
    private WebMetaData webMetaData;

    public JaccContextValve(String contextID, CodeSource cs) {
        this.contextID = contextID;
        this.warCS = cs;
        this.trace = log.isTraceEnabled();
    }

    public void setWebMetaData(WebMetaData wmd) {
        this.webMetaData = wmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        activeCS.set(this.warCS);
        activeWebMetaData.set(this.webMetaData);
        HttpServletRequest httpRequest = request.getRequest();
        try {
            PolicyContext.setContextID((String)this.contextID);
            HttpServletRequestPolicyContextHandler.setRequest(httpRequest);
            this.getNext().invoke(request, response);
        }
        finally {
            SecurityAssociationActions.clear();
            activeCS.set(null);
            activeWebMetaData.set(null);
            HttpServletRequestPolicyContextHandler.setRequest(null);
        }
    }
}

