/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.clientapi.util.units;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.rhq.core.clientapi.util.units.FormatSpecifics;
import org.rhq.core.clientapi.util.units.FormattedNumber;
import org.rhq.core.clientapi.util.units.Formatter;
import org.rhq.core.clientapi.util.units.ParseSpecifics;
import org.rhq.core.clientapi.util.units.ScaleConstants;
import org.rhq.core.clientapi.util.units.UnitNumber;
import org.rhq.core.clientapi.util.units.UnitsConstants;

public class TemperatureFormatter
implements Formatter {
    public FormattedNumber format(UnitNumber val, Locale locale, FormatSpecifics format) {
        BigDecimal celsius = this.convert(val.getBaseValue(), val.getScale());
        return new FormattedNumber(this.getSpecificFormatter().format(celsius.doubleValue()), "C");
    }

    private BigDecimal convert(BigDecimal val, ScaleConstants scale) {
        BigDecimal celsius = null;
        switch (scale) {
            case SCALE_KELVIN: {
                celsius = val.subtract(new BigDecimal(273.15));
                break;
            }
            case SCALE_CELSIUS: {
                celsius = val;
                break;
            }
            case SCALE_FAHRENHEIT: {
                celsius = val.subtract(new BigDecimal(32)).divide(new BigDecimal(5).divide(new BigDecimal(9)));
            }
        }
        return celsius;
    }

    public FormattedNumber[] formatSame(double[] values, UnitsConstants unitType, ScaleConstants scale, Locale locale, FormatSpecifics format) {
        FormattedNumber[] numbers = new FormattedNumber[values.length];
        int i = 0;
        for (double val : values) {
            numbers[i] = this.format(new UnitNumber(values[i], unitType, scale), locale, format);
            ++i;
        }
        return numbers;
    }

    public BigDecimal getBaseValue(double value, ScaleConstants scale) {
        return new BigDecimal(value);
    }

    public BigDecimal getScaledValue(BigDecimal value, ScaleConstants targScale) {
        return this.convert(value, targScale);
    }

    public UnitNumber parse(String val, Locale locale, ParseSpecifics specifics) throws ParseException {
        return null;
    }

    private NumberFormat getSpecificFormatter() {
        NumberFormat res = NumberFormat.getInstance();
        res.setMaximumFractionDigits(1);
        res.setMinimumFractionDigits(1);
        return res;
    }
}

