/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.clientapi.descriptor;

import java.io.IOException;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.rhq.core.clientapi.descriptor.PluginTransformException;
import org.rhq.core.clientapi.descriptor.plugin.Help;
import org.rhq.core.clientapi.descriptor.plugin.PluginDescriptor;
import org.rhq.core.domain.plugin.Plugin;
import org.rhq.core.util.MessageDigestGenerator;

public class PluginTransformer {
    public Plugin toPlugin(PluginDescriptor pluginDescriptor, URL pluginURL) {
        try {
            Plugin plugin = new Plugin();
            plugin.setName(pluginDescriptor.getName());
            if (pluginDescriptor.getDisplayName() == null) {
                plugin.setDisplayName(pluginDescriptor.getName());
            } else {
                plugin.setDisplayName(pluginDescriptor.getDisplayName());
            }
            plugin.setAmpsVersion(this.getAmpsVersion(pluginDescriptor));
            plugin.setDescription(pluginDescriptor.getDescription());
            plugin.setPath(pluginURL.getPath());
            plugin.setMtime(pluginURL.openConnection().getLastModified());
            plugin.setHelp(this.getHelp(pluginDescriptor));
            plugin.setMd5(this.getMd5(pluginURL));
            plugin.setVersion(this.getVersion(pluginDescriptor, pluginURL));
            return plugin;
        }
        catch (IOException e) {
            throw new PluginTransformException("Failed to create plugin.", e);
        }
    }

    private String getAmpsVersion(PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor.getAmpsVersion() == null) {
            return "2.0";
        }
        return pluginDescriptor.getAmpsVersion();
    }

    private String getHelp(PluginDescriptor pluginDescriptor) {
        Help help = pluginDescriptor.getHelp();
        if (help == null || help.getContent().isEmpty()) {
            return null;
        }
        return help.getContent().get(0).toString();
    }

    private String getMd5(URL pluginURL) throws IOException {
        return MessageDigestGenerator.getDigestString((URL)pluginURL);
    }

    String getVersion(PluginDescriptor pluginDescriptor, URL pluginURL) throws IOException {
        String version = pluginDescriptor.getVersion();
        if (version == null) {
            version = this.getVersionFromPluginJarManifest(pluginURL);
        }
        if (version == null) {
            throw new PluginTransformException("No version is defined for plugin jar [" + pluginURL + "]. A version must be defined either via the MANIFEST.MF '" + Attributes.Name.IMPLEMENTATION_VERSION + "' attribute or via the plugin descriptor 'version' attribute.");
        }
        return version;
    }

    private String getVersionFromPluginJarManifest(URL pluginJarUrl) throws IOException {
        JarInputStream jarInputStream = new JarInputStream(pluginJarUrl.openStream());
        jarInputStream.close();
        Manifest manifest = jarInputStream.getManifest();
        if (manifest != null) {
            Attributes attributes = manifest.getMainAttributes();
            return attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        }
        return null;
    }
}

