/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import mazz.i18n.Logger;
import org.rhq.enterprise.agent.AgentInputReader;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.JLineAgentInputReader;
import org.rhq.enterprise.agent.JavaAgentInputReader;
import org.rhq.enterprise.agent.SigarAgentInputReader;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;

public class AgentInputReaderFactory {
    private static final Logger LOG = AgentI18NFactory.getLogger(AgentInputReaderFactory.class);
    private static ConsoleType consoleType = ConsoleType.jline;

    public static AgentInputReader create(AgentMain agent) throws IOException {
        AgentInputReader input = null;
        try {
            switch (consoleType) {
                case java: {
                    input = new JavaAgentInputReader();
                    break;
                }
                case sigar: {
                    input = new SigarAgentInputReader(agent);
                    break;
                }
                case jline: {
                    input = new JLineAgentInputReader(agent);
                }
            }
        }
        catch (Exception e) {
            input = null;
            LOG.warn((Throwable)e, "AgentMain.input-reader-factory-error", new Object[]{consoleType});
        }
        if (input == null) {
            input = new JavaAgentInputReader();
        }
        return input;
    }

    public static AgentInputReader create(AgentMain agent, File file) throws IOException {
        AgentInputReader input = null;
        try {
            switch (consoleType) {
                case java: {
                    input = new JavaAgentInputReader(new FileReader(file));
                    break;
                }
                case sigar: {
                    input = new SigarAgentInputReader(agent, new FileReader(file));
                    break;
                }
                case jline: {
                    input = new JLineAgentInputReader(agent, new FileInputStream(file));
                }
            }
        }
        catch (Exception e) {
            input = null;
            LOG.warn((Throwable)e, "AgentMain.input-reader-factory-error", new Object[]{consoleType});
        }
        if (input == null) {
            input = new JavaAgentInputReader(new FileReader(file));
        }
        return input;
    }

    public static ConsoleType getConsoleType() {
        return consoleType;
    }

    public static void setConsoleType(ConsoleType type) {
        consoleType = type;
    }

    public static void setConsoleType(String typeStr) {
        try {
            AgentInputReaderFactory.setConsoleType(ConsoleType.valueOf(typeStr));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(LOG.getMsgString("AgentMain.input-reader-factory-bad-type", new Object[]{typeStr}));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConsoleType {
        java,
        sigar,
        jline;

    }
}

