/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class AgentPrintWriter
extends PrintWriter {
    private List<Writer> listeners = new ArrayList<Writer>();
    private String lineSeparator;

    public AgentPrintWriter(PrintStream out, boolean b) {
        super(out, b);
        this.determineLineSeparator();
    }

    public AgentPrintWriter(FileWriter fileWriter, boolean b) {
        super((Writer)fileWriter, b);
        this.determineLineSeparator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Writer listener) {
        List<Writer> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Writer listener) {
        List<Writer> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] buf, int off, int len) {
        List<Writer> list = this.listeners;
        synchronized (list) {
            for (Writer listener : this.listeners) {
                try {
                    listener.write(buf, off, len);
                }
                catch (IOException e) {}
            }
        }
        super.write(buf, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int c) {
        List<Writer> list = this.listeners;
        synchronized (list) {
            for (Writer listener : this.listeners) {
                try {
                    listener.write(c);
                }
                catch (IOException e) {}
            }
        }
        super.write(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String s, int off, int len) {
        List<Writer> list = this.listeners;
        synchronized (list) {
            for (Writer listener : this.listeners) {
                try {
                    listener.write(s, off, len);
                }
                catch (IOException e) {}
            }
        }
        super.write(s, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println() {
        List<Writer> list = this.listeners;
        synchronized (list) {
            for (Writer listener : this.listeners) {
                try {
                    listener.write(this.lineSeparator);
                }
                catch (IOException e) {}
            }
        }
        super.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        List<Writer> list = this.listeners;
        synchronized (list) {
            for (Writer listener : this.listeners) {
                try {
                    listener.flush();
                }
                catch (IOException e) {}
            }
        }
        super.flush();
    }

    private void determineLineSeparator() {
        this.lineSeparator = System.getProperty("line.separator");
    }
}

