/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import mazz.i18n.Msg;
import org.rhq.core.clientapi.server.core.AgentRegistrationResults;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.AgentPrintWriter;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;

public class RegisterPromptCommand
implements AgentPromptCommand {
    private static final Msg MSG = AgentI18NFactory.getMsg();

    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.register", new Object[0]);
    }

    public boolean execute(AgentMain agent, String[] args) {
        if (!agent.isStarted()) {
            agent.getOut().println(MSG.getMsg("PromptCommand.register.must-be-started", new Object[0]));
            return true;
        }
        AgentPrintWriter out = agent.getOut();
        long wait = 30L;
        boolean regenerate = false;
        if (args.length > 3) {
            out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
            return true;
        }
        if (args.length == 2 || args.length == 3) {
            try {
                Long wait_arg = this.getWait(args[1]);
                boolean bl = regenerate = wait_arg == null;
                if (args.length == 3) {
                    if (wait_arg == null) {
                        wait_arg = this.getWait(args[2]);
                    } else {
                        regenerate = this.getRegenerate(args[2]);
                    }
                }
                if (wait_arg != null) {
                    wait = wait_arg;
                }
            }
            catch (NumberFormatException nfe) {
                out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
                return true;
            }
        }
        out.println(MSG.getMsg("PromptCommand.register.sent-request", new Object[]{regenerate}));
        out.println(MSG.getMsg("PromptCommand.register.waiting", new Object[]{wait}));
        agent.registerWithServer(wait * 1000L, regenerate);
        AgentRegistrationResults registration = agent.getAgentRegistration();
        if (registration == null) {
            out.println(MSG.getMsg("PromptCommand.register.failed", new Object[0]));
        } else {
            out.println(MSG.getMsg("PromptCommand.register.registered", new Object[]{registration}));
        }
        return true;
    }

    public String getSyntax() {
        return MSG.getMsg("PromptCommand.register.syntax", new Object[0]);
    }

    public String getHelp() {
        return MSG.getMsg("PromptCommand.register.help", new Object[0]);
    }

    public String getDetailedHelp() {
        return MSG.getMsg("PromptCommand.register.detailed-help", new Object[0]);
    }

    private boolean getRegenerate(String arg) {
        return arg.equalsIgnoreCase(MSG.getMsg("PromptCommand.register.regenerate", new Object[0]));
    }

    private Long getWait(String arg) throws NumberFormatException {
        try {
            Long wait = Long.valueOf(arg);
            if (wait <= 0L) {
                wait = 30L;
            }
            return wait;
        }
        catch (NumberFormatException nfe) {
            if (!this.getRegenerate(arg)) {
                throw nfe;
            }
            return null;
        }
    }
}

