/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.socket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimerTask;
import javax.net.ServerSocketFactory;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.transport.socket.LRUPool;
import org.jboss.remoting.transport.socket.ServerSocketWrapper;
import org.jboss.remoting.transport.socket.ServerThread;
import org.jboss.remoting.transport.socket.SocketServerInvokerMBean;
import org.jboss.remoting.util.TimerUtil;
import org.jboss.util.propertyeditor.PropertyEditors;

public class SocketServerInvoker
extends ServerInvoker
implements Runnable,
SocketServerInvokerMBean {
    private static final Logger log = Logger.getLogger((Class)SocketServerInvoker.class);
    private static boolean trace = log.isTraceEnabled();
    static int clientCount = 0;
    private Properties props = new Properties();
    private static int BACKLOG_DEFAULT = 200;
    protected static int MAX_POOL_SIZE_DEFAULT = 300;
    public static final String CHECK_CONNECTION_KEY = "socket.check_connection";
    public static final String SERVER_SOCKET_CLASS_FLAG = "serverSocketClass";
    protected String serverSocketClass = ServerSocketWrapper.class.getName();
    protected ServerSocket serverSocket = null;
    protected boolean running = false;
    protected int backlog = BACKLOG_DEFAULT;
    protected Thread[] acceptThreads;
    protected int numAcceptThreads = 1;
    protected int maxPoolSize = MAX_POOL_SIZE_DEFAULT;
    protected LRUPool clientpool;
    protected LinkedList threadpool;
    protected boolean newServerSocketFactory = false;
    protected Object serverSocketFactoryLock = new Object();
    protected boolean reuseAddress = true;
    protected int idleTimeout = -1;
    protected IdleTimerTask idleTimerTask = null;

    public SocketServerInvoker(InvokerLocator locator) {
        super(locator);
    }

    public SocketServerInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNewServerSocketFactory(ServerSocketFactory serverSocketFactory) {
        log.trace((Object)"entering setNewServerSocketFactory()");
        Object object = this.serverSocketFactoryLock;
        synchronized (object) {
            this.newServerSocketFactory = true;
            this.setServerSocketFactory(serverSocketFactory);
            this.serverSocketFactoryLock.notify();
            log.info((Object)"ServerSocketFactory has been updated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshServerSocket() throws IOException {
        log.trace((Object)"entering refreshServerSocket()");
        Object object = this.serverSocketFactoryLock;
        synchronized (object) {
            this.newServerSocketFactory = false;
            ServerSocket oldServerSocket = this.serverSocket;
            this.serverSocket = null;
            oldServerSocket.close();
            InetAddress bindAddress = InetAddress.getByName(this.getServerBindAddress());
            ServerSocket newServerSocket = this.createServerSocket(this.getServerBindPort(), this.backlog, bindAddress);
            newServerSocket.setReuseAddress(this.reuseAddress);
            this.serverSocket = newServerSocket;
            log.info((Object)"ServerSocket has been updated");
        }
        log.trace((Object)"leavinging refreshServerSocket()");
    }

    protected void setup() throws Exception {
        this.props.putAll((Map<?, ?>)this.getConfiguration());
        PropertyEditors.mapJavaBeanProperties((Object)this, (Properties)this.props, (boolean)false);
        super.setup();
        String ssclass = this.props.getProperty(SERVER_SOCKET_CLASS_FLAG);
        if (ssclass != null) {
            this.serverSocketClass = ssclass;
        }
    }

    protected void finalize() throws Throwable {
        this.stop();
        super.finalize();
    }

    public synchronized void start() throws IOException {
        if (!this.running) {
            log.debug((Object)(this + " starting"));
            InetAddress bindAddress = InetAddress.getByName(this.getServerBindAddress());
            if (this.maxPoolSize <= 0) {
                this.maxPoolSize = MAX_POOL_SIZE_DEFAULT;
            }
            try {
                this.serverSocket = this.createServerSocket(this.getServerBindPort(), this.backlog, bindAddress);
                this.serverSocket.setReuseAddress(this.reuseAddress);
            }
            catch (IOException e) {
                log.error((Object)("Error starting ServerSocket.  Bind port: " + this.getServerBindPort() + ", bind address: " + bindAddress));
                throw e;
            }
            this.clientpool = new LRUPool(2, this.maxPoolSize);
            this.clientpool.create();
            this.threadpool = new LinkedList();
            this.acceptThreads = new Thread[this.numAcceptThreads];
            for (int i = 0; i < this.numAcceptThreads; ++i) {
                if (trace) {
                    log.trace((Object)(this + " creating another AcceptThread"));
                }
                String name = this.getThreadName(i);
                this.acceptThreads[i] = new Thread((Runnable)this, name);
                if (!trace) continue;
                log.trace((Object)(this + " created and registered " + this.acceptThreads[i]));
            }
        }
        try {
            super.start();
        }
        catch (IOException e) {
            log.error((Object)"Error starting SocketServerInvoker.", (Throwable)e);
            this.cleanup();
        }
        if (!this.running) {
            this.running = true;
            for (int i = 0; i < this.numAcceptThreads; ++i) {
                this.acceptThreads[i].start();
            }
        }
        if (this.idleTimeout > 0) {
            if (this.idleTimerTask != null) {
                this.idleTimerTask.cancel();
            }
            this.idleTimerTask = new IdleTimerTask();
            TimerUtil.schedule(this.idleTimerTask, this.idleTimeout * 1000);
        } else if (this.idleTimerTask != null) {
            this.idleTimerTask.cancel();
        }
        log.debug((Object)(this + " started"));
    }

    protected ServerSocket createServerSocket(int serverBindPort, int backlog, InetAddress bindAddress) throws IOException {
        return this.getServerSocketFactory().createServerSocket(serverBindPort, backlog, bindAddress);
    }

    protected String getThreadName(int i) {
        return "AcceptorThread#" + i + ":" + this.getServerBindPort();
    }

    public void destroy() {
        if (this.clientpool != null) {
            this.clientpool.destroy();
        }
        super.destroy();
    }

    public synchronized void stop() {
        if (this.running) {
            this.cleanup();
        }
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup() {
        this.running = false;
        this.maxPoolSize = 0;
        if (this.acceptThreads != null) {
            for (int i = 0; i < this.acceptThreads.length; ++i) {
                try {
                    this.acceptThreads[i].interrupt();
                    continue;
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
        }
        if (this.clientpool != null) {
            LRUPool i = this.clientpool;
            synchronized (i) {
                Set svrThreads = this.clientpool.getContents();
                Iterator itr = svrThreads.iterator();
                while (itr.hasNext()) {
                    Object o = itr.next();
                    ServerThread st = (ServerThread)o;
                    st.shutdown();
                }
                this.clientpool.flush();
                this.clientpool.stop();
                if (this.threadpool != null) {
                    LinkedList linkedList = this.threadpool;
                    synchronized (linkedList) {
                        int threadsToShutdown = this.threadpool.size();
                        for (int i2 = 0; i2 < threadsToShutdown; ++i2) {
                            ServerThread thread = (ServerThread)this.threadpool.removeFirst();
                            thread.shutdown();
                        }
                    }
                }
            }
        }
        try {
            this.serverSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean getReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuse) {
        this.reuseAddress = reuse;
    }

    public int getCurrentThreadPoolSize() {
        return this.threadpool.size();
    }

    public int getCurrentClientPoolSize() {
        return this.clientpool.size();
    }

    public int getNumAcceptThreads() {
        return this.numAcceptThreads;
    }

    public void setNumAcceptThreads(int size) {
        this.numAcceptThreads = size;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog < 0 ? BACKLOG_DEFAULT : backlog;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
        if (this.isStarted()) {
            if (idleTimeout > 0) {
                if (this.idleTimerTask != null) {
                    this.idleTimerTask.cancel();
                }
                this.idleTimerTask = new IdleTimerTask();
                TimerUtil.schedule(this.idleTimerTask, idleTimeout * 1000);
            } else if (this.idleTimerTask != null) {
                this.idleTimerTask.cancel();
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processInvocation(Socket socket) throws Exception {
        Object object;
        ServerThread worker = null;
        boolean newThread = false;
        while (worker == null) {
            if (trace) {
                log.trace((Object)(this + " trying to get a worker thread from threadpool for processing"));
            }
            object = this.threadpool;
            synchronized (object) {
                if (this.threadpool.size() > 0) {
                    worker = (ServerThread)this.threadpool.removeFirst();
                    if (trace) {
                        log.trace((Object)(this + (worker == null ? " found NO threads in threadpool" : " got " + worker + " from threadpool")));
                    }
                } else if (trace) {
                    log.trace((Object)(this + " has an empty threadpool"));
                }
            }
            if (worker != null) continue;
            object = this.clientpool;
            synchronized (object) {
                if (this.clientpool.size() < this.maxPoolSize) {
                    if (trace) {
                        log.trace((Object)(this + " creating new worker thread"));
                    }
                    worker = new ServerThread(socket, this, this.clientpool, this.threadpool, this.getTimeout(), this.serverSocketClass);
                    if (trace) {
                        log.trace((Object)(this + " created " + worker));
                    }
                    newThread = true;
                }
                if (worker == null) {
                    if (trace) {
                        log.trace((Object)(this + " trying to evict a thread from clientpool"));
                    }
                    this.clientpool.evict();
                    if (trace) {
                        log.trace((Object)(this + " waiting for a thread from clientpool"));
                    }
                    ((Object)((Object)this.clientpool)).wait();
                    if (trace) {
                        log.trace((Object)(this + " notified of clientpool thread availability"));
                    }
                }
            }
        }
        object = this.clientpool;
        synchronized (object) {
            this.clientpool.insert(worker, worker);
        }
        if (newThread) {
            if (trace) {
                log.trace((Object)(this + " starting " + worker));
            }
            worker.start();
        } else {
            if (trace) {
                log.trace((Object)(this + " reusing " + worker));
            }
            worker.wakeup(socket, this.getTimeout(), this);
        }
    }

    public boolean isTransportBiDirectional() {
        return true;
    }

    public String toString() {
        return "SocketServerInvoker[" + (this.serverSocket == null ? "UNINITIALIZED" : this.serverSocket.getInetAddress().getHostAddress() + ":" + this.serverSocket.getLocalPort()) + "]";
    }

    protected String getDefaultDataType() {
        return "serializable";
    }

    public class IdleTimerTask
    extends TimerTask {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long idleTimeout;
            long idleTime;
            ServerThread svrThread;
            int x;
            Object[] svrThreadArray = null;
            LRUPool lRUPool = SocketServerInvoker.this.clientpool;
            synchronized (lRUPool) {
                Set svrThreads = SocketServerInvoker.this.clientpool.getContents();
                svrThreadArray = svrThreads.toArray();
            }
            if (trace && svrThreadArray != null) {
                log.trace((Object)("Idle timer task fired.  Number of ServerThreads = " + svrThreadArray.length));
            }
            if (svrThreadArray != null) {
                long currentTime = System.currentTimeMillis();
                for (x = 0; x < svrThreadArray.length; ++x) {
                    svrThread = (ServerThread)svrThreadArray[x];
                    idleTime = currentTime - svrThread.getLastRequestTimestamp();
                    if (trace) {
                        log.trace((Object)("Idle time for ServerThread (" + svrThread + ") is " + idleTime));
                    }
                    if (idleTime <= (idleTimeout = (long)(SocketServerInvoker.this.getIdleTimeout() * 1000))) continue;
                    if (trace) {
                        log.trace((Object)("Idle timeout reached for ServerThread (" + svrThread + ") and will be evicted."));
                    }
                    SocketServerInvoker.this.clientpool.remove(svrThread);
                    svrThread.shutdown();
                    svrThread.unblock();
                }
            }
            svrThreadArray = null;
            LinkedList currentTime = SocketServerInvoker.this.threadpool;
            synchronized (currentTime) {
                if (SocketServerInvoker.this.threadpool.size() > 0) {
                    svrThreadArray = SocketServerInvoker.this.threadpool.toArray();
                }
            }
            if (trace && svrThreadArray != null) {
                log.trace((Object)("Number of ServerThread in thead pool = " + svrThreadArray.length));
            }
            if (svrThreadArray != null) {
                long currentTime2 = System.currentTimeMillis();
                for (x = 0; x < svrThreadArray.length; ++x) {
                    svrThread = (ServerThread)svrThreadArray[x];
                    idleTime = currentTime2 - svrThread.getLastRequestTimestamp();
                    if (trace) {
                        log.trace((Object)("Idle time for ServerThread (" + svrThread + ") is " + idleTime));
                    }
                    if (idleTime <= (idleTimeout = (long)(SocketServerInvoker.this.getIdleTimeout() * 1000))) continue;
                    if (trace) {
                        log.trace((Object)("Idle timeout reached for ServerThread (" + svrThread + ") and will be removed from thread pool."));
                    }
                    SocketServerInvoker.this.threadpool.remove(svrThread);
                    svrThread.shutdown();
                }
            }
        }
    }

    public class ServerSocketRefresh
    extends Thread {
        private boolean running;

        public ServerSocketRefresh() {
            super("ServerSocketRefresh");
            this.running = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.running) {
                Object object = SocketServerInvoker.this.serverSocketFactoryLock;
                synchronized (object) {
                    if (SocketServerInvoker.this.newServerSocketFactory) {
                        log.debug((Object)"got notice about new ServerSocketFactory");
                        try {
                            log.debug((Object)"refreshing server socket");
                            SocketServerInvoker.this.refreshServerSocket();
                        }
                        catch (IOException e) {
                            log.debug((Object)"could not refresh server socket");
                            log.debug((Object)("message is: " + e.getMessage()));
                        }
                        log.debug((Object)"server socket refreshed");
                    }
                    try {
                        SocketServerInvoker.this.serverSocketFactoryLock.wait();
                        log.trace((Object)"ServerSocketRefresh thread woke up");
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() throws ServerInvoker.InvalidStateException {
            Object object = SocketServerInvoker.this.serverSocketFactoryLock;
            synchronized (object) {
                if (SocketServerInvoker.this.serverSocket == null) {
                    throw new ServerInvoker.InvalidStateException("error refreshing ServerSocket");
                }
                log.trace((Object)"passed through ServerSocketRefresh.release()");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.running = false;
            Object object = SocketServerInvoker.this.serverSocketFactoryLock;
            synchronized (object) {
                SocketServerInvoker.this.serverSocketFactoryLock.notify();
            }
        }
    }
}

