/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.FeatureNotSupportedException;

public abstract class SQLServerDatabaseType
extends DatabaseType {
    public static final String SEQ_SUFFIX = "_ID_SEQ";
    public static final String BAD_SEQ_NAME = "Sequences named must end in _ID_SEQ";
    public static final String SEQ_ERROR_MSG = "SQL Server does not support sequences, use identifier columns instead";
    public static final String VENDOR_NAME = "sqlserver";

    public String getVendor() {
        return VENDOR_NAME;
    }

    public String getHibernateDialect() {
        return "org.hibernate.dialect.SQLServerDialect";
    }

    public boolean isTableNotFoundException(SQLException e) {
        String msg = e.getMessage();
        msg = msg == null ? "" : msg.trim().toLowerCase();
        return msg.contains("invalid object name");
    }

    public int getSequenceValue(Connection conn, String table, String key) throws SQLException {
        throw new FeatureNotSupportedException(SEQ_ERROR_MSG);
    }

    public int getNextSequenceValue(Connection conn, String table, String key) throws SQLException {
        throw new FeatureNotSupportedException(SEQ_ERROR_MSG);
    }

    public void createSequence(Connection conn, String name, String initial, String increment) throws SQLException {
        if (!(name = name.toUpperCase()).endsWith(SEQ_SUFFIX)) {
            throw new FeatureNotSupportedException(SEQ_ERROR_MSG);
        }
        String tableName = name.substring(0, name.length() - SEQ_SUFFIX.length());
        String alterTableStatement = "ALTER TABLE " + tableName + " ALTER COLUMN ID IDENTITY(" + initial + ", " + increment + ")";
        this.executeSql(conn, alterTableStatement);
    }

    public void alterColumn(Connection conn, String table, String column, String generic_column_type, String default_value, String precision, Boolean nullable, Boolean reindex) throws SQLException {
        String db_column_type = null;
        ArrayList<String> sql_list = new ArrayList<String>();
        if (generic_column_type != null) {
            db_column_type = this.getDBTypeFromGenericType(generic_column_type);
            if (precision != null) {
                db_column_type = db_column_type + " (" + precision + ")";
            }
            sql_list.add("ALTER TABLE " + table + " ALTER COLUMN " + column + " " + db_column_type);
        }
        if (default_value != null) {
            sql_list.add("ALTER TABLE " + table + " ALTER COLUMN " + column + " SET DEFAULT '" + default_value + "'");
        }
        if (nullable != null) {
            if (nullable.booleanValue()) {
                sql_list.add("ALTER TABLE " + table + " ALTER " + column + " SET NULL");
            } else {
                sql_list.add("ALTER TABLE " + table + " ALTER " + column + " SET NOT NULL");
            }
        }
        this.executeSql(conn, sql_list);
        if (reindex != null && reindex.booleanValue()) {
            this.reindexTable(conn, table);
        }
    }

    public void reindexTable(Connection conn, String table) throws SQLException {
        String reindexSql = "DBCC DBREINDEX (\"" + table + "\", \" \", 0)";
        this.executeSql(conn, reindexSql);
    }

    public boolean supportsSelfReferringCascade() {
        return false;
    }
}

