/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.hosts;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.augeas.AugeasConfigurationDiscoveryComponent;
import org.rhq.plugins.platform.PlatformComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostsDiscoveryComponent
extends AugeasConfigurationDiscoveryComponent<PlatformComponent> {
    private static final boolean IS_WINDOWS = File.separatorChar == '\\';
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public Set discoverResources(ResourceDiscoveryContext<PlatformComponent> discoveryContext) throws InvalidPluginConfigurationException, Exception {
        return super.discoverResources(discoveryContext);
    }

    public DiscoveredResourceDetails discoverResource(Configuration pluginConfig, ResourceDiscoveryContext discoveryContext) throws InvalidPluginConfigurationException {
        return super.discoverResource(pluginConfig, discoveryContext);
    }

    protected List<String> determineIncludeGlobs(ResourceDiscoveryContext<PlatformComponent> discoveryContext) {
        File hostsFile;
        Configuration defaultPluginConfig = discoveryContext.getDefaultPluginConfiguration();
        String includeGlobs = defaultPluginConfig.getSimpleValue("configurationFilesInclusionPatterns", null);
        if (includeGlobs != null) {
            return super.determineIncludeGlobs(discoveryContext);
        }
        if (IS_WINDOWS) {
            File windowsDir = this.getWindowsDir(discoveryContext);
            hostsFile = new File(windowsDir, "system32/drivers/etc/hosts");
        } else {
            hostsFile = new File("/etc/hosts");
        }
        return Collections.singletonList(hostsFile.getPath());
    }

    private File getWindowsDir(ResourceDiscoveryContext<PlatformComponent> discoveryContext) {
        File windowsDir = null;
        String windowsDirPath = System.getenv().get("SystemRoot");
        if (!(windowsDirPath == null || (windowsDir = new File(windowsDirPath)).isDirectory() || (windowsDirPath = System.getenv().get("WinDir")) == null || (windowsDir = new File(windowsDirPath)).isDirectory() || (windowsDir = new File("C:\\WINDOWS")).isDirectory() || (windowsDir = new File("C:\\WINNT")).isDirectory())) {
            windowsDir = null;
        }
        if (windowsDir == null) {
            throw new IllegalStateException("Failed to determine Windows directory.");
        }
        this.log.debug((Object)("Windows directory: " + windowsDir));
        return windowsDir;
    }
}

