/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.hosts.helper;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedHashSet;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.plugins.hosts.HostsComponent;
import org.rhq.plugins.hosts.helper.Hosts;
import org.rhq.plugins.hosts.helper.HostsEntry;

public class NonAugeasHostsConfigurationDelegate
implements ConfigurationFacet {
    private HostsComponent hostsComponent;

    public NonAugeasHostsConfigurationDelegate(HostsComponent hostsComponent) {
        this.hostsComponent = hostsComponent;
    }

    public Configuration loadResourceConfiguration() throws Exception {
        Configuration resourceConfig = new Configuration();
        File hostsFile = (File)this.hostsComponent.getConfigurationFiles().get(0);
        Hosts hosts = Hosts.load(hostsFile);
        resourceConfig.setNotes("Loaded at " + new Date());
        PropertyList entriesProp = new PropertyList(".");
        resourceConfig.put((Property)entriesProp);
        for (HostsEntry entry : hosts.getEntries()) {
            PropertyMap entryProp = new PropertyMap("*[canonical]");
            entriesProp.add((Property)entryProp);
            entryProp.put((Property)new PropertySimple("ipaddr", (Object)entry.getIpAddress()));
            entryProp.put((Property)new PropertySimple("canonical", (Object)entry.getCanonicalName()));
            StringBuilder aliasPropValue = new StringBuilder();
            for (String alias : entry.getAliases()) {
                aliasPropValue.append(alias).append("\n");
            }
            if (!entry.getAliases().isEmpty()) {
                aliasPropValue.deleteCharAt(aliasPropValue.length() - 1);
            }
            entryProp.put((Property)new PropertySimple("alias", (Object)aliasPropValue));
        }
        return resourceConfig;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        Configuration resourceConfig = report.getConfiguration();
        Hosts newHosts = new Hosts();
        PropertyList entriesProp = resourceConfig.getList(".");
        for (Property entryProp : entriesProp.getList()) {
            LinkedHashSet<String> aliasSet;
            PropertyMap entryPropMap = (PropertyMap)entryProp;
            String ipAddress = entryPropMap.getSimple("ipaddr").getStringValue();
            String canonicalName = entryPropMap.getSimple("canonical").getStringValue();
            String aliases = entryPropMap.getSimpleValue("alias", null);
            if (aliases == null) {
                aliasSet = null;
            } else {
                String[] aliasArray = aliases.trim().split("\\s+");
                aliasSet = new LinkedHashSet<String>(aliasArray.length);
                for (String alias : aliasArray) {
                    aliasSet.add(alias);
                }
            }
            HostsEntry entry = new HostsEntry(ipAddress, canonicalName, aliasSet);
            newHosts.addEntry(entry);
        }
        File hostsFile = (File)this.hostsComponent.getConfigurationFiles().get(0);
        try {
            Hosts.store(newHosts, hostsFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write hosts file [" + hostsFile + "].", e);
        }
        report.setStatus(ConfigurationUpdateStatus.SUCCESS);
    }
}

