/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache.augeas;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.augeas.Augeas;
import org.rhq.augeas.config.AugeasModuleConfig;
import org.rhq.augeas.node.AugeasNode;
import org.rhq.augeas.tree.AugeasTree;
import org.rhq.augeas.tree.AugeasTreeException;
import org.rhq.augeas.tree.impl.AugeasTreeLazy;
import org.rhq.plugins.apache.augeas.ApacheAugeasNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheAugeasTree
extends AugeasTreeLazy {
    private Map<AugeasNode, List<String>> includes;
    private List<String> includeGlobs;

    public ApacheAugeasTree(String serverRootPath, Augeas ag, AugeasModuleConfig moduleConfig) {
        super(ag, moduleConfig);
        this.includeGlobs = this.initIncludeGlobs(serverRootPath);
    }

    protected AugeasNode instantiateNode(String fullPath) {
        return new ApacheAugeasNode(fullPath, (AugeasTree)this);
    }

    public Map<AugeasNode, List<String>> getIncludes() {
        return this.includes;
    }

    public void setIncludes(Map<AugeasNode, List<String>> includes) {
        this.includes = includes;
    }

    public List<AugeasNode> match(String expression) throws AugeasTreeException {
        if (!expression.startsWith("/files")) {
            expression = "/files" + expression;
        }
        return this.matchInternal(expression);
    }

    public List<AugeasNode> matchRelative(AugeasNode node, String expression) throws AugeasTreeException {
        try {
            if (expression.indexOf(47) == 0) {
                expression = expression.substring(1);
            }
            return this.parseExpr(node, expression);
        }
        catch (Exception e) {
            throw new AugeasTreeException(e.getMessage());
        }
    }

    protected List<String> getIncludeGlobs() {
        return this.includeGlobs;
    }

    private int subExpressionIndex(String expr) {
        int idx;
        int state = 0;
        boolean found = false;
        block23: for (idx = 0; !found && idx < expr.length(); ++idx) {
            char currentChar = expr.charAt(idx);
            block0 : switch (state) {
                case 0: {
                    switch (currentChar) {
                        case '[': {
                            state = 1;
                            break;
                        }
                        case '/': {
                            found = true;
                        }
                    }
                    continue block23;
                }
                case 1: {
                    switch (currentChar) {
                        case ']': {
                            state = 0;
                            break;
                        }
                        case '\"': {
                            state = 2;
                            break;
                        }
                        case '\'': {
                            state = 3;
                        }
                    }
                    continue block23;
                }
                case 2: {
                    switch (currentChar) {
                        case '\"': {
                            state = 1;
                            break;
                        }
                        case '\\': {
                            ++idx;
                        }
                    }
                    continue block23;
                }
                case 3: {
                    switch (currentChar) {
                        case '\'': {
                            state = 1;
                            break block0;
                        }
                        case '\\': {
                            ++idx;
                        }
                    }
                }
            }
        }
        return idx == expr.length() ? -1 : idx;
    }

    private List<AugeasNode> parseExpr(AugeasNode nd, String expr) throws Exception {
        int index = this.subExpressionIndex(expr);
        if (index == -1) {
            return this.search(nd, expr);
        }
        String subExpr = expr.substring(0, index - 1);
        List<AugeasNode> nodes = this.search(nd, subExpr);
        ArrayList<AugeasNode> nds = new ArrayList<AugeasNode>();
        for (AugeasNode node : nodes) {
            List<AugeasNode> tempNodes = this.parseExpr(node, expr.substring(index));
            if (tempNodes == null) continue;
            nds.addAll(tempNodes);
        }
        return nds;
    }

    private List<AugeasNode> search(AugeasNode nd, String expr) throws Exception {
        String fullExpr = nd.getFullPath() + '/' + expr;
        List<AugeasNode> nodes = this.matchInternal(fullExpr);
        if (this.includes.containsKey(nd)) {
            List<String> files = this.includes.get(nd);
            for (String fileName : files) {
                List<AugeasNode> nds = this.matchInternal(fileName + '/' + expr);
                for (AugeasNode node : nds) {
                    if (nodes.contains(node)) continue;
                    nodes.add(node);
                }
            }
        }
        return nodes;
    }

    private List<AugeasNode> matchInternal(String expression) throws AugeasTreeException {
        if (!expression.startsWith("/files")) {
            expression = "/files" + expression;
        }
        List res = this.getAugeas().match(expression);
        ArrayList<AugeasNode> nodes = new ArrayList<AugeasNode>();
        for (String name : res) {
            nodes.add(this.getNode(name));
        }
        return nodes;
    }

    private List<String> initIncludeGlobs(String serverRootPath) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String glob : this.getModuleConfig().getIncludedGlobs()) {
            File f = new File(glob);
            if (f.isAbsolute()) {
                ret.add(glob);
                continue;
            }
            ret.add(new File(serverRootPath, glob).getPath());
        }
        return ret;
    }
}

