/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5;

import java.io.File;
import java.net.URI;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.KnownDeploymentTypes;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.deployers.spi.management.deploy.DeploymentProgress;
import org.jboss.deployers.spi.management.deploy.DeploymentStatus;
import org.jboss.deployers.spi.management.deploy.ProgressEvent;
import org.jboss.deployers.spi.management.deploy.ProgressListener;
import org.jboss.managed.api.DeploymentState;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.jbossas5.AbstractManagedComponent;
import org.rhq.plugins.jbossas5.ProfileServiceComponent;
import org.rhq.plugins.jbossas5.WarMeasurementFacetDelegate;
import org.rhq.plugins.jbossas5.util.DeploymentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractManagedDeploymentComponent
extends AbstractManagedComponent
implements MeasurementFacet,
OperationFacet,
ProgressListener {
    public static final String DEPLOYMENT_NAME_PROPERTY = "deploymentName";
    public static final String DEPLOYMENT_TYPE_NAME_PROPERTY = "deploymentTypeName";
    public static final String EXTENSION_PROPERTY = "extension";
    private static final boolean IS_WINDOWS = File.separatorChar == '\\';
    private final Log log = LogFactory.getLog(this.getClass());
    protected String deploymentName;
    protected KnownDeploymentTypes deploymentType;
    protected File deploymentFile;

    @Override
    public void start(ResourceContext<ProfileServiceComponent> resourceContext) throws Exception {
        super.start(resourceContext);
        Configuration pluginConfig = this.getResourceContext().getPluginConfiguration();
        this.deploymentName = pluginConfig.getSimple(DEPLOYMENT_NAME_PROPERTY).getStringValue();
        this.deploymentFile = this.getDeploymentFile();
        String deploymentTypeName = pluginConfig.getSimple(DEPLOYMENT_TYPE_NAME_PROPERTY).getStringValue();
        this.deploymentType = KnownDeploymentTypes.valueOf((String)deploymentTypeName);
        this.log.trace((Object)("Started ResourceComponent for " + this.getResourceDescription() + ", managing " + this.deploymentType + " deployment '" + this.deploymentName + "' with path '" + this.deploymentFile + "'."));
        try {
            this.getManagedDeployment();
        }
        catch (Exception e) {
            this.log.warn((Object)("The underlying file [" + this.deploymentFile + "] no longer exists. It may have been deleted from the filesystem external to Jopr. If you wish to remove this Resource from inventory, you may add &debug=true to the URL for the Browse Resources > Services page and then click the UNINVENTORY button next to this Resource"));
        }
    }

    public AvailabilityType getAvailability() {
        DeploymentState deploymentState = null;
        try {
            deploymentState = this.getManagedDeployment().getDeploymentState();
        }
        catch (NoSuchDeploymentException e) {
            this.log.warn((Object)(this.deploymentType + " deployment '" + this.deploymentName + "' not found. Cause: " + e.getLocalizedMessage()));
            return AvailabilityType.DOWN;
        }
        catch (Throwable t) {
            this.log.debug((Object)"Could not get deployment state, cause: ", t);
            return AvailabilityType.DOWN;
        }
        if (deploymentState == DeploymentState.STARTED) {
            return AvailabilityType.UP;
        }
        this.log.debug((Object)("Deployment was not STARTED, state was: " + deploymentState));
        return AvailabilityType.DOWN;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        if (this.deploymentType == KnownDeploymentTypes.JavaEEWebApplication) {
            WarMeasurementFacetDelegate warMeasurementFacetDelegate = new WarMeasurementFacetDelegate(this);
            warMeasurementFacetDelegate.getValues(report, requests);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        DeploymentProgress progress;
        DeploymentManager deploymentManager = this.getConnection().getDeploymentManager();
        if (name.equals("start")) {
            if (this.getAvailability() == AvailabilityType.UP) {
                this.log.warn((Object)("Operation '" + name + "' on " + this.getResourceDescription() + " failed because the Resource is already started."));
                OperationResult result = new OperationResult();
                result.setErrorMessage(this.deploymentFile.getName() + " is already started.");
                return result;
            }
            progress = deploymentManager.start(new String[]{this.deploymentName});
        } else if (name.equals("stop")) {
            progress = deploymentManager.stop(new String[]{this.deploymentName});
        } else {
            if (!name.equals("restart")) {
                throw new UnsupportedOperationException(name);
            }
            progress = deploymentManager.stop(new String[]{this.deploymentName});
            DeploymentStatus stopStatus = DeploymentUtils.run(progress);
            progress = deploymentManager.start(new String[]{this.deploymentName});
        }
        DeploymentStatus status = DeploymentUtils.run(progress);
        this.log.debug((Object)("Operation '" + name + "' on " + this.getResourceDescription() + " returned status [" + status + "]."));
        if (status.isFailed()) {
            throw status.getFailure();
        }
        return new OperationResult();
    }

    public void progressEvent(ProgressEvent event) {
        this.log.debug((Object)event);
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public KnownDeploymentTypes getDeploymentType() {
        return this.deploymentType;
    }

    protected ManagedDeployment getManagedDeployment() throws NoSuchDeploymentException {
        ManagementView managementView = this.getConnection().getManagementView();
        managementView.load();
        return managementView.getDeployment(this.deploymentName);
    }

    private File getDeploymentFile() {
        URI vfsURI = URI.create(this.deploymentName);
        String path = vfsURI.getPath();
        if (IS_WINDOWS && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return new File(path);
    }
}

