/*
 * Decompiled with CFR 0.152.
 */
package churchillobjects.rss4j.generator;

import churchillobjects.rss4j.RssChannel;
import churchillobjects.rss4j.RssChannelImage;
import churchillobjects.rss4j.RssChannelItem;
import churchillobjects.rss4j.RssChannelTextInput;
import churchillobjects.rss4j.RssDocument;
import churchillobjects.rss4j.generator.RssGenerationException;
import churchillobjects.rss4j.generator.RssGenerator;
import java.util.Enumeration;
import org.w3c.dom.Element;

class RssGeneratorImpl090
extends RssGenerator {
    RssGeneratorImpl090() throws RssGenerationException {
    }

    protected void setMaxLengths() {
        this.channelTitleMax = 40;
        this.channelDescriptionMax = 500;
        this.channelLinkMax = 500;
        this.imageTitleMax = 40;
        this.imageUrlMax = 500;
        this.imageLinkMax = 500;
        this.itemTitleMax = 100;
        this.itemLinkMax = 500;
        this.textInputTitleMax = 40;
        this.textInputDescriptionMax = 100;
        this.textInputNameMax = 500;
        this.textInputLinkMax = 500;
    }

    protected void finishDocument() throws RssGenerationException {
    }

    protected void createRssDocument(RssDocument data) {
        this.doc = this.domImpl.createDocument("http://my.netscape.com/rdf/simple/0.9/", "rdf:RDF", null);
        this.rootElement = this.doc.getDocumentElement();
        this.rootElement.setAttribute("xmlns:rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.rootElement.setAttribute("xmlns", "http://my.netscape.com/rdf/simple/0.9/");
    }

    protected void handleChannel(RssChannel channel) throws RssGenerationException {
        Element channelElement = this.doc.createElement("channel");
        this.rootElement.appendChild(channelElement);
        this.handleChannelTitle(channel, channelElement);
        this.handleChannelDescription(channel, channelElement);
        this.handleChannelLink(channel, channelElement);
        this.handleTextInput(channel, channelElement);
        this.handleImage(channel, channelElement);
        this.handleItems(channel, channelElement);
    }

    private void handleImage(RssChannel channel, Element channelElement) throws RssGenerationException {
        RssChannelImage image = channel.getChannelImage();
        if (image != null) {
            Element imageElement = this.doc.createElement("image");
            this.handleImageTitle(image, imageElement);
            this.handleImageUrl(image, imageElement);
            this.handleImageLink(image, imageElement);
            channelElement.appendChild(imageElement);
        }
    }

    private void handleItems(RssChannel channel, Element channelElement) throws RssGenerationException {
        if (channel.getItemCount() > 15) {
            throw new RssGenerationException("Channel in 0.91 RSS cannot have more than 15 items");
        }
        Enumeration enumeration = channel.items();
        while (enumeration.hasMoreElements()) {
            RssChannelItem item = (RssChannelItem)enumeration.nextElement();
            if (item == null) continue;
            Element itemElement = this.doc.createElement("item");
            this.handleItemTitle(item, itemElement);
            this.handleItemLink(item, itemElement);
            channelElement.appendChild(itemElement);
        }
    }

    private void handleTextInput(RssChannel channel, Element channelElement) throws RssGenerationException {
        RssChannelTextInput textInput = channel.getChannelTextInput();
        if (textInput != null) {
            Element textInputElement = this.doc.createElement("textInput");
            this.handleTextInputTitle(textInput, textInputElement);
            this.handleTextInputDescription(textInput, textInputElement);
            this.handleTextInputName(textInput, textInputElement);
            this.handleTextInputLink(textInput, textInputElement);
            channelElement.appendChild(textInputElement);
        }
    }

    protected void handleChannelTitle(RssChannel channel, Element channelElement) throws RssGenerationException {
        String title = channel.getChannelTitle();
        title = this.truncate(title, this.channelTitleMax);
        this.validateValueRequired(title, "Channel title", this.channelTitleMax);
        this.add(channelElement, "title", title);
    }

    protected void handleChannelDescription(RssChannel channel, Element channelElement) throws RssGenerationException {
        String description = channel.getChannelDescription();
        description = this.truncate(description, this.channelDescriptionMax);
        this.validateValueRequired(description, "Channel description", this.channelDescriptionMax);
        this.add(channelElement, "description", description);
    }

    protected void handleChannelLink(RssChannel channel, Element channelElement) throws RssGenerationException {
        String link = channel.getChannelLink();
        this.validateUri(link);
        this.validateValueRequired(link, "Channel link", this.channelLinkMax);
        this.add(channelElement, "link", link);
    }

    protected void handleImageTitle(RssChannelImage image, Element imageElement) throws RssGenerationException {
        String title = image.getImageTitle();
        title = this.truncate(title, this.imageTitleMax);
        this.validateValueRequired(title, "Image title", this.imageTitleMax);
        this.add(imageElement, "title", title);
    }

    protected void handleImageUrl(RssChannelImage image, Element imageElement) throws RssGenerationException {
        String url = image.getImageUrl();
        this.validateUri(url);
        this.validateValueRequired(url, "Image URL", this.imageUrlMax);
        this.add(imageElement, "url", url);
    }

    protected void handleImageLink(RssChannelImage image, Element imageElement) throws RssGenerationException {
        String link = image.getImageLink();
        this.validateUri(link);
        this.validateValueRequired(link, "Image link", this.imageLinkMax);
        this.add(imageElement, "link", link);
    }

    protected void handleItemTitle(RssChannelItem item, Element itemElement) throws RssGenerationException {
        String title = item.getItemTitle();
        title = this.truncate(title, this.itemTitleMax);
        this.validateValueRequired(title, "Item title", this.itemTitleMax);
        this.add(itemElement, "title", title);
    }

    protected void handleItemLink(RssChannelItem item, Element itemElement) throws RssGenerationException {
        String link = item.getItemLink();
        this.validateUri(link);
        this.validateValueRequired(link, "Item link", this.itemLinkMax);
        this.add(itemElement, "link", link);
    }

    protected void handleTextInputTitle(RssChannelTextInput textInput, Element textInputElement) throws RssGenerationException {
        String title = textInput.getInputTitle();
        title = this.truncate(title, this.textInputTitleMax);
        this.validateValueRequired(title, "Text input title", this.textInputTitleMax);
        this.add(textInputElement, "title", title);
    }

    protected void handleTextInputDescription(RssChannelTextInput textInput, Element textInputElement) throws RssGenerationException {
        String description = textInput.getInputDescription();
        description = this.truncate(description, this.textInputDescriptionMax);
        this.validateValueRequired(description, "Text input description", this.textInputDescriptionMax);
        this.add(textInputElement, "description", description);
    }

    protected void handleTextInputName(RssChannelTextInput textInput, Element textInputElement) throws RssGenerationException {
        String name = textInput.getInputName();
        this.validateValueRequired(name, "Text input name", this.textInputNameMax);
        this.add(textInputElement, "name", name);
    }

    protected void handleTextInputLink(RssChannelTextInput textInput, Element textInputElement) throws RssGenerationException {
        String link = textInput.getInputLink();
        this.validateUri(link);
        this.validateValueRequired(link, "Text input link", this.textInputLinkMax);
        this.add(textInputElement, "link", link);
    }
}

