/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.alertSubject;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSender;
import org.rhq.enterprise.server.plugin.pc.alert.CustomAlertSenderBackingBean;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubjectsBackingBean
extends CustomAlertSenderBackingBean {
    private Map<String, String> available;
    private List<String> currentSubjects;
    private static final String SUBJECT_ID = "subjectId";

    public void loadView() {
        PageList allSubjects = LookupUtil.getSubjectManager().findAllSubjects(new PageControl());
        this.available = new HashMap<String, String>();
        for (Subject subject : allSubjects) {
            String subjectId = String.valueOf(subject.getId());
            this.available.put(subject.getName(), subjectId);
        }
        String subjectString = this.alertParameters.getSimpleValue(SUBJECT_ID, "");
        this.currentSubjects = AlertSender.unfence((String)subjectString, String.class);
    }

    public void saveView() {
        String subjectIds = AlertSender.fence(this.currentSubjects);
        PropertySimple p = this.alertParameters.getSimple(SUBJECT_ID);
        if (p == null) {
            p = new PropertySimple(SUBJECT_ID, (Object)subjectIds);
            this.alertParameters.put((Property)p);
        } else {
            p.setStringValue(subjectIds);
        }
        this.alertParameters = this.persistConfiguration(this.alertParameters);
    }

    public List<String> getCurrentSubjects() {
        return this.currentSubjects;
    }

    public void setCurrentSubjects(List<String> currentSubjects) {
        this.currentSubjects = currentSubjects;
    }

    public Map<String, String> getAvailableSubjectsMap() {
        return this.available;
    }
}

