/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore.oracle;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.sql.BLOB;
import org.apache.commons.logging.Log;
import org.quartz.Calendar;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.jdbcjobstore.StdJDBCDelegate;

public class OracleDelegate
extends StdJDBCDelegate {
    public static final String UPDATE_ORACLE_JOB_DETAIL = "UPDATE {0}JOB_DETAILS SET DESCRIPTION = ?, JOB_CLASS_NAME = ?, IS_DURABLE = ?, IS_VOLATILE = ?, IS_STATEFUL = ?, REQUESTS_RECOVERY = ?  WHERE JOB_NAME = ? AND JOB_GROUP = ?";
    public static final String UPDATE_ORACLE_JOB_DETAIL_BLOB = "UPDATE {0}JOB_DETAILS SET JOB_DATA = ?  WHERE JOB_NAME = ? AND JOB_GROUP = ?";
    public static final String UPDATE_ORACLE_JOB_DETAIL_EMPTY_BLOB = "UPDATE {0}JOB_DETAILS SET JOB_DATA = EMPTY_BLOB()  WHERE JOB_NAME = ? AND JOB_GROUP = ?";
    public static final String SELECT_ORACLE_JOB_DETAIL_BLOB = "SELECT JOB_DATA FROM {0}JOB_DETAILS WHERE JOB_NAME = ? AND JOB_GROUP = ? FOR UPDATE";
    public static final String UPDATE_ORACLE_TRIGGER = "UPDATE {0}TRIGGERS SET JOB_NAME = ?, JOB_GROUP = ?, IS_VOLATILE = ?, DESCRIPTION = ?, NEXT_FIRE_TIME = ?, PREV_FIRE_TIME = ?, TRIGGER_STATE = ?, TRIGGER_TYPE = ?, START_TIME = ?, END_TIME = ?, CALENDAR_NAME = ?, MISFIRE_INSTR = ?, PRIORITY = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?";
    public static final String SELECT_ORACLE_TRIGGER_JOB_DETAIL_BLOB = "SELECT JOB_DATA FROM {0}TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ? FOR UPDATE";
    public static final String UPDATE_ORACLE_TRIGGER_JOB_DETAIL_BLOB = "UPDATE {0}TRIGGERS SET JOB_DATA = ?  WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?";
    public static final String UPDATE_ORACLE_TRIGGER_JOB_DETAIL_EMPTY_BLOB = "UPDATE {0}TRIGGERS SET JOB_DATA = EMPTY_BLOB()  WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?";
    public static final String INSERT_ORACLE_CALENDAR = "INSERT INTO {0}CALENDARS (CALENDAR_NAME, CALENDAR)  VALUES(?, EMPTY_BLOB())";
    public static final String SELECT_ORACLE_CALENDAR_BLOB = "SELECT CALENDAR FROM {0}CALENDARS WHERE CALENDAR_NAME = ? FOR UPDATE";
    public static final String UPDATE_ORACLE_CALENDAR_BLOB = "UPDATE {0}CALENDARS SET CALENDAR = ?  WHERE CALENDAR_NAME = ?";

    public OracleDelegate(Log logger, String tablePrefix, String instanceId) {
        super(logger, tablePrefix, instanceId);
    }

    public OracleDelegate(Log logger, String tablePrefix, String instanceId, Boolean useProperties) {
        super(logger, tablePrefix, instanceId, useProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getObjectFromBlob(ResultSet rs, String colName) throws ClassNotFoundException, IOException, SQLException {
        Object obj = null;
        InputStream binaryInput = rs.getBinaryStream(colName);
        if (binaryInput != null) {
            ObjectInputStream in = new ObjectInputStream(binaryInput);
            try {
                obj = in.readObject();
            }
            finally {
                in.close();
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertJobDetail(Connection conn, JobDetail job) throws IOException, SQLException {
        int n;
        Blob dbBlob;
        int res;
        ResultSet rs;
        PreparedStatement ps;
        block6: {
            ByteArrayOutputStream baos = this.serializeJobData(job.getJobDataMap());
            byte[] data = baos.toByteArray();
            ps = null;
            rs = null;
            ps = conn.prepareStatement(this.rtp("INSERT INTO {0}JOB_DETAILS (JOB_NAME, JOB_GROUP, DESCRIPTION, JOB_CLASS_NAME, IS_DURABLE, IS_VOLATILE, IS_STATEFUL, REQUESTS_RECOVERY, JOB_DATA)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)"));
            ps.setString(1, job.getName());
            ps.setString(2, job.getGroup());
            ps.setString(3, job.getDescription());
            ps.setString(4, job.getJobClass().getName());
            this.setBoolean(ps, 5, job.isDurable());
            this.setBoolean(ps, 6, job.isVolatile());
            this.setBoolean(ps, 7, job.isStateful());
            this.setBoolean(ps, 8, job.requestsRecovery());
            ps.setBinaryStream(9, (InputStream)null, 0);
            ps.executeUpdate();
            ps.close();
            ps = conn.prepareStatement(this.rtp(UPDATE_ORACLE_JOB_DETAIL_EMPTY_BLOB));
            ps.setString(1, job.getName());
            ps.setString(2, job.getGroup());
            ps.executeUpdate();
            ps.close();
            ps = conn.prepareStatement(this.rtp(SELECT_ORACLE_JOB_DETAIL_BLOB));
            ps.setString(1, job.getName());
            ps.setString(2, job.getGroup());
            rs = ps.executeQuery();
            res = 0;
            dbBlob = null;
            if (rs.next()) {
                dbBlob = this.writeDataToBlob(rs, 1, data);
                break block6;
            }
            int n2 = res;
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return n2;
        }
        try {
            rs.close();
            ps.close();
            ps = conn.prepareStatement(this.rtp(UPDATE_ORACLE_JOB_DETAIL_BLOB));
            ps.setBlob(1, dbBlob);
            ps.setString(2, job.getName());
            ps.setString(3, job.getGroup());
            res = ps.executeUpdate();
            if (res > 0) {
                String[] jobListeners = job.getJobListenerNames();
                for (int i = 0; jobListeners != null && i < jobListeners.length; ++i) {
                    this.insertJobListener(conn, job, jobListeners[i]);
                }
            }
            n = res;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
        this.closeResultSet(rs);
        this.closeStatement(ps);
        return n;
    }

    protected Object getJobDetailFromBlob(ResultSet rs, String colName) throws ClassNotFoundException, IOException, SQLException {
        if (this.canUseProperties()) {
            InputStream binaryInput = rs.getBinaryStream(colName);
            return binaryInput;
        }
        return this.getObjectFromBlob(rs, colName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateJobDetail(Connection conn, JobDetail job) throws IOException, SQLException {
        int n;
        ByteArrayOutputStream baos = this.serializeJobData(job.getJobDataMap());
        byte[] data = baos.toByteArray();
        PreparedStatement ps = null;
        PreparedStatement ps2 = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(this.rtp(UPDATE_ORACLE_JOB_DETAIL));
            ps.setString(1, job.getDescription());
            ps.setString(2, job.getJobClass().getName());
            this.setBoolean(ps, 3, job.isDurable());
            this.setBoolean(ps, 4, job.isVolatile());
            this.setBoolean(ps, 5, job.isStateful());
            this.setBoolean(ps, 6, job.requestsRecovery());
            ps.setString(7, job.getName());
            ps.setString(8, job.getGroup());
            ps.executeUpdate();
            ps.close();
            ps = conn.prepareStatement(this.rtp(UPDATE_ORACLE_JOB_DETAIL_EMPTY_BLOB));
            ps.setString(1, job.getName());
            ps.setString(2, job.getGroup());
            ps.executeUpdate();
            ps.close();
            ps = conn.prepareStatement(this.rtp(SELECT_ORACLE_JOB_DETAIL_BLOB));
            ps.setString(1, job.getName());
            ps.setString(2, job.getGroup());
            rs = ps.executeQuery();
            int res = 0;
            if (rs.next()) {
                Blob dbBlob = this.writeDataToBlob(rs, 1, data);
                ps2 = conn.prepareStatement(this.rtp(UPDATE_ORACLE_JOB_DETAIL_BLOB));
                ps2.setBlob(1, dbBlob);
                ps2.setString(2, job.getName());
                ps2.setString(3, job.getGroup());
                res = ps2.executeUpdate();
            }
            if (res > 0) {
                this.deleteJobListeners(conn, job.getName(), job.getGroup());
                String[] jobListeners = job.getJobListenerNames();
                for (int i = 0; jobListeners != null && i < jobListeners.length; ++i) {
                    this.insertJobListener(conn, job, jobListeners[i]);
                }
            }
            n = res;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            this.closeStatement(ps2);
            throw throwable;
        }
        this.closeResultSet(rs);
        this.closeStatement(ps);
        this.closeStatement(ps2);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertTrigger(Connection conn, Trigger trigger, String state, JobDetail jobDetail) throws SQLException, IOException {
        int insertResult;
        block14: {
            Blob dbBlob;
            ResultSet rs;
            PreparedStatement ps;
            block15: {
                byte[] data = null;
                if (trigger.getJobDataMap().size() > 0) {
                    data = this.serializeJobData(trigger.getJobDataMap()).toByteArray();
                }
                ps = null;
                rs = null;
                insertResult = 0;
                ps = conn.prepareStatement(this.rtp("INSERT INTO {0}TRIGGERS (TRIGGER_NAME, TRIGGER_GROUP, JOB_NAME, JOB_GROUP, IS_VOLATILE, DESCRIPTION, NEXT_FIRE_TIME, PREV_FIRE_TIME, TRIGGER_STATE, TRIGGER_TYPE, START_TIME, END_TIME, CALENDAR_NAME, MISFIRE_INSTR, JOB_DATA, PRIORITY)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"));
                ps.setString(1, trigger.getName());
                ps.setString(2, trigger.getGroup());
                ps.setString(3, trigger.getJobName());
                ps.setString(4, trigger.getJobGroup());
                this.setBoolean(ps, 5, trigger.isVolatile());
                ps.setString(6, trigger.getDescription());
                ps.setBigDecimal(7, new BigDecimal(String.valueOf(trigger.getNextFireTime().getTime())));
                long prevFireTime = -1L;
                if (trigger.getPreviousFireTime() != null) {
                    prevFireTime = trigger.getPreviousFireTime().getTime();
                }
                ps.setBigDecimal(8, new BigDecimal(String.valueOf(prevFireTime)));
                ps.setString(9, state);
                if (trigger instanceof SimpleTrigger && !((SimpleTrigger)trigger).hasAdditionalProperties()) {
                    ps.setString(10, "SIMPLE");
                } else if (trigger instanceof CronTrigger && !((CronTrigger)trigger).hasAdditionalProperties()) {
                    ps.setString(10, "CRON");
                } else {
                    ps.setString(10, "BLOB");
                }
                ps.setBigDecimal(11, new BigDecimal(String.valueOf(trigger.getStartTime().getTime())));
                long endTime = 0L;
                if (trigger.getEndTime() != null) {
                    endTime = trigger.getEndTime().getTime();
                }
                ps.setBigDecimal(12, new BigDecimal(String.valueOf(endTime)));
                ps.setString(13, trigger.getCalendarName());
                ps.setInt(14, trigger.getMisfireInstruction());
                ps.setBinaryStream(15, (InputStream)null, 0);
                ps.setInt(16, trigger.getPriority());
                insertResult = ps.executeUpdate();
                if (data == null) break block14;
                ps.close();
                ps = conn.prepareStatement(this.rtp(UPDATE_ORACLE_TRIGGER_JOB_DETAIL_EMPTY_BLOB));
                ps.setString(1, trigger.getName());
                ps.setString(2, trigger.getGroup());
                ps.executeUpdate();
                ps.close();
                ps = conn.prepareStatement(this.rtp(SELECT_ORACLE_TRIGGER_JOB_DETAIL_BLOB));
                ps.setString(1, trigger.getName());
                ps.setString(2, trigger.getGroup());
                rs = ps.executeQuery();
                int res = 0;
                dbBlob = null;
                if (rs.next()) {
                    dbBlob = this.writeDataToBlob(rs, 1, data);
                    break block15;
                }
                int n = res;
                this.closeResultSet(rs);
                this.closeStatement(ps);
                return n;
            }
            try {
                rs.close();
                ps.close();
                ps = conn.prepareStatement(this.rtp(UPDATE_ORACLE_TRIGGER_JOB_DETAIL_BLOB));
                ps.setBlob(1, dbBlob);
                ps.setString(2, trigger.getName());
                ps.setString(3, trigger.getGroup());
                ps.executeUpdate();
            }
            finally {
                this.closeResultSet(rs);
                this.closeStatement(ps);
            }
        }
        if (insertResult > 0) {
            String[] trigListeners = trigger.getTriggerListenerNames();
            for (int i = 0; trigListeners != null && i < trigListeners.length; ++i) {
                this.insertTriggerListener(conn, trigger, trigListeners[i]);
            }
        }
        return insertResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateTrigger(Connection conn, Trigger trigger, String state, JobDetail jobDetail) throws SQLException, IOException {
        boolean updateJobData = trigger.getJobDataMap().isDirty();
        byte[] data = null;
        if (updateJobData && trigger.getJobDataMap().size() > 0) {
            data = this.serializeJobData(trigger.getJobDataMap()).toByteArray();
        }
        PreparedStatement ps = null;
        PreparedStatement ps2 = null;
        ResultSet rs = null;
        int insertResult = 0;
        try {
            ps = conn.prepareStatement(this.rtp(UPDATE_ORACLE_TRIGGER));
            ps.setString(1, trigger.getJobName());
            ps.setString(2, trigger.getJobGroup());
            this.setBoolean(ps, 3, trigger.isVolatile());
            ps.setString(4, trigger.getDescription());
            long nextFireTime = -1L;
            if (trigger.getNextFireTime() != null) {
                nextFireTime = trigger.getNextFireTime().getTime();
            }
            ps.setBigDecimal(5, new BigDecimal(String.valueOf(nextFireTime)));
            long prevFireTime = -1L;
            if (trigger.getPreviousFireTime() != null) {
                prevFireTime = trigger.getPreviousFireTime().getTime();
            }
            ps.setBigDecimal(6, new BigDecimal(String.valueOf(prevFireTime)));
            ps.setString(7, state);
            if (trigger instanceof SimpleTrigger && !((SimpleTrigger)trigger).hasAdditionalProperties()) {
                ps.setString(8, "SIMPLE");
            } else if (trigger instanceof CronTrigger && !((CronTrigger)trigger).hasAdditionalProperties()) {
                ps.setString(8, "CRON");
            } else {
                ps.setString(8, "BLOB");
            }
            ps.setBigDecimal(9, new BigDecimal(String.valueOf(trigger.getStartTime().getTime())));
            long endTime = 0L;
            if (trigger.getEndTime() != null) {
                endTime = trigger.getEndTime().getTime();
            }
            ps.setBigDecimal(10, new BigDecimal(String.valueOf(endTime)));
            ps.setString(11, trigger.getCalendarName());
            ps.setInt(12, trigger.getMisfireInstruction());
            ps.setInt(13, trigger.getPriority());
            ps.setString(14, trigger.getName());
            ps.setString(15, trigger.getGroup());
            insertResult = ps.executeUpdate();
            if (updateJobData) {
                ps.close();
                ps = conn.prepareStatement(this.rtp(UPDATE_ORACLE_TRIGGER_JOB_DETAIL_EMPTY_BLOB));
                ps.setString(1, trigger.getName());
                ps.setString(2, trigger.getGroup());
                ps.executeUpdate();
                ps.close();
                ps = conn.prepareStatement(this.rtp(SELECT_ORACLE_TRIGGER_JOB_DETAIL_BLOB));
                ps.setString(1, trigger.getName());
                ps.setString(2, trigger.getGroup());
                rs = ps.executeQuery();
                boolean res = false;
                if (rs.next()) {
                    Blob dbBlob = this.writeDataToBlob(rs, 1, data);
                    ps2 = conn.prepareStatement(this.rtp(UPDATE_ORACLE_TRIGGER_JOB_DETAIL_BLOB));
                    ps2.setBlob(1, dbBlob);
                    ps2.setString(2, trigger.getName());
                    ps2.setString(3, trigger.getGroup());
                    ps2.executeUpdate();
                }
            }
        }
        finally {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            this.closeStatement(ps2);
        }
        if (insertResult > 0) {
            this.deleteTriggerListeners(conn, trigger.getName(), trigger.getGroup());
            String[] trigListeners = trigger.getTriggerListenerNames();
            for (int i = 0; trigListeners != null && i < trigListeners.length; ++i) {
                this.insertTriggerListener(conn, trigger, trigListeners[i]);
            }
        }
        return insertResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertCalendar(Connection conn, String calendarName, Calendar calendar) throws IOException, SQLException {
        ResultSet rs;
        PreparedStatement ps2;
        PreparedStatement ps;
        block3: {
            int n;
            ByteArrayOutputStream baos = this.serializeObject(calendar);
            ps = null;
            ps2 = null;
            rs = null;
            try {
                ps = conn.prepareStatement(this.rtp(INSERT_ORACLE_CALENDAR));
                ps.setString(1, calendarName);
                ps.executeUpdate();
                ps.close();
                ps = conn.prepareStatement(this.rtp(SELECT_ORACLE_CALENDAR_BLOB));
                ps.setString(1, calendarName);
                rs = ps.executeQuery();
                if (!rs.next()) break block3;
                Blob dbBlob = this.writeDataToBlob(rs, 1, baos.toByteArray());
                ps2 = conn.prepareStatement(this.rtp(UPDATE_ORACLE_CALENDAR_BLOB));
                ps2.setBlob(1, dbBlob);
                ps2.setString(2, calendarName);
                n = ps2.executeUpdate();
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(ps);
                this.closeStatement(ps2);
                throw throwable;
            }
            this.closeResultSet(rs);
            this.closeStatement(ps);
            this.closeStatement(ps2);
            return n;
        }
        int n = 0;
        this.closeResultSet(rs);
        this.closeStatement(ps);
        this.closeStatement(ps2);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateCalendar(Connection conn, String calendarName, Calendar calendar) throws IOException, SQLException {
        ResultSet rs;
        PreparedStatement ps2;
        PreparedStatement ps;
        block3: {
            int n;
            ByteArrayOutputStream baos = this.serializeObject(calendar);
            ps = null;
            ps2 = null;
            rs = null;
            try {
                ps = conn.prepareStatement(this.rtp(SELECT_ORACLE_CALENDAR_BLOB));
                ps.setString(1, calendarName);
                rs = ps.executeQuery();
                if (!rs.next()) break block3;
                Blob dbBlob = this.writeDataToBlob(rs, 1, baos.toByteArray());
                ps2 = conn.prepareStatement(this.rtp(UPDATE_ORACLE_CALENDAR_BLOB));
                ps2.setBlob(1, dbBlob);
                ps2.setString(2, calendarName);
                n = ps2.executeUpdate();
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(ps);
                this.closeStatement(ps2);
                throw throwable;
            }
            this.closeResultSet(rs);
            this.closeStatement(ps);
            this.closeStatement(ps2);
            return n;
        }
        int n = 0;
        this.closeResultSet(rs);
        this.closeStatement(ps);
        this.closeStatement(ps2);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateJobData(Connection conn, JobDetail job) throws IOException, SQLException {
        int n;
        ByteArrayOutputStream baos = this.serializeJobData(job.getJobDataMap());
        byte[] data = baos.toByteArray();
        PreparedStatement ps = null;
        PreparedStatement ps2 = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(this.rtp(SELECT_ORACLE_JOB_DETAIL_BLOB));
            ps.setString(1, job.getName());
            ps.setString(2, job.getGroup());
            rs = ps.executeQuery();
            int res = 0;
            if (rs.next()) {
                Blob dbBlob = this.writeDataToBlob(rs, 1, data);
                ps2 = conn.prepareStatement(this.rtp(UPDATE_ORACLE_JOB_DETAIL_BLOB));
                ps2.setBlob(1, dbBlob);
                ps2.setString(2, job.getName());
                ps2.setString(3, job.getGroup());
                res = ps2.executeUpdate();
            }
            n = res;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            this.closeStatement(ps2);
            throw throwable;
        }
        this.closeResultSet(rs);
        this.closeStatement(ps);
        this.closeStatement(ps2);
        return n;
    }

    protected Blob writeDataToBlob(ResultSet rs, int column, byte[] data) throws SQLException {
        Blob blob = rs.getBlob(column);
        if (blob == null) {
            throw new SQLException("Driver's Blob representation is null!");
        }
        if (blob instanceof BLOB) {
            ((BLOB)blob).putBytes(1L, data);
            return blob;
        }
        throw new SQLException("Driver's Blob representation is of an unsupported type: " + blob.getClass().getName());
    }
}

