/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import mazz.i18n.Logger;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;
import org.rhq.enterprise.communications.util.NotPermittedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrencyManager {
    private static final Logger LOG = CommI18NFactory.getLogger(ConcurrencyManager.class);
    private static final int DEFAULT_PERMITS = 50;
    private final Map<String, Integer> numPermitsAllowed = new HashMap<String, Integer>();
    private final Map<String, Semaphore> semaphores = new HashMap<String, Semaphore>();
    private final Map<String, AtomicInteger> deniedCounts = new HashMap<String, AtomicInteger>();

    public ConcurrencyManager(Map<String, Integer> newPermitsAllowed) {
        if (newPermitsAllowed != null) {
            this.numPermitsAllowed.putAll(newPermitsAllowed);
        }
    }

    public Permit getPermit(String name) throws NotPermittedException {
        Permit permit = new Permit();
        permit.name = name;
        permit.managerId = this.hashCode();
        if (name == null) {
            return permit;
        }
        Semaphore semaphore = this.getSemaphore(name);
        if (semaphore == null) {
            permit.name = null;
            return permit;
        }
        boolean permitted = semaphore.tryAcquire();
        if (!permitted) {
            int deniedCount = this.getDeniedCount(name).incrementAndGet();
            long sleepBeforeRetry = this.getSleepBeforeRetryHint(deniedCount);
            throw new NotPermittedException(sleepBeforeRetry);
        }
        return permit;
    }

    public void releasePermit(Permit permit) {
        if (permit != null && permit.name != null && permit.managerId == this.hashCode()) {
            Semaphore semaphore = this.getSemaphore(permit.name);
            if (semaphore != null) {
                semaphore.release();
            }
            this.getDeniedCount(permit.name).set(0);
        }
    }

    public Map<String, Integer> getAllConfiguredNumberOfPermitsAllowed() {
        return new HashMap<String, Integer>(this.numPermitsAllowed);
    }

    public int getConfiguredNumberOfPermitsAllowed(String name) {
        Integer number = this.numPermitsAllowed.get(name);
        if (number == null) {
            number = 50;
            String numberString = System.getProperty(name);
            if (numberString != null) {
                try {
                    number = Integer.parseInt(numberString);
                }
                catch (NumberFormatException e) {
                    LOG.warn("ConcurrencyManager.invalid-permits-config", new Object[]{numberString, name, number});
                }
            }
        }
        return number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Semaphore getSemaphore(String name) {
        Semaphore semaphore;
        Map<String, Semaphore> map = this.semaphores;
        synchronized (map) {
            int permits;
            semaphore = this.semaphores.get(name);
            if (semaphore == null && (permits = this.getConfiguredNumberOfPermitsAllowed(name)) > 0) {
                semaphore = new Semaphore(permits, false);
                this.semaphores.put(name, semaphore);
            }
        }
        return semaphore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AtomicInteger getDeniedCount(String name) {
        AtomicInteger deniedCount;
        Map<String, AtomicInteger> map = this.deniedCounts;
        synchronized (map) {
            deniedCount = this.deniedCounts.get(name);
            if (deniedCount == null) {
                deniedCount = new AtomicInteger(0);
                this.deniedCounts.put(name, deniedCount);
            }
        }
        return deniedCount;
    }

    private long getSleepBeforeRetryHint(int deniedCount) {
        if (deniedCount > 100) {
            return 15000L;
        }
        return 5000L + (long)(deniedCount / 10) * 1000L;
    }

    public static class Permit {
        private String name;
        private int managerId;
    }
}

