/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command.param;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mazz.i18n.Logger;
import org.rhq.enterprise.communications.command.param.InvalidParameterValueException;
import org.rhq.enterprise.communications.command.param.OptionListRenderingInformation;
import org.rhq.enterprise.communications.command.param.ParameterDefinition;
import org.rhq.enterprise.communications.command.param.ParameterRenderingInformation;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedValuesParameterDefinition
extends ParameterDefinition {
    private static final Logger LOG = CommI18NFactory.getLogger(FixedValuesParameterDefinition.class);
    private static final long serialVersionUID = 1L;
    private List<Object> m_allowedValues;

    public FixedValuesParameterDefinition(String name, String type, boolean required, boolean nullable, boolean hidden, Object[] allowed, String description) throws IllegalArgumentException {
        this(name, type, required, nullable, hidden, allowed != null ? Arrays.asList(allowed) : null, description, null);
    }

    public FixedValuesParameterDefinition(String name, String type, boolean hidden, List<Object> allowed, String description) throws IllegalArgumentException {
        this(name, type, hidden, allowed, description, (ParameterRenderingInformation)null);
    }

    public FixedValuesParameterDefinition(String name, String type, boolean hidden, List<Object> allowed, String description, ParameterRenderingInformation renderingInfo) throws IllegalArgumentException {
        this(name, type, false, true, hidden, allowed, description, renderingInfo);
    }

    public FixedValuesParameterDefinition(String name, String type, boolean required, boolean nullable, boolean hidden, List<Object> allowed, String description) throws IllegalArgumentException {
        this(name, type, required, nullable, hidden, allowed, description, null);
    }

    public FixedValuesParameterDefinition(String name, String type, boolean required, boolean nullable, boolean hidden, List<Object> allowed, String description, ParameterRenderingInformation renderingInfo) throws IllegalArgumentException {
        super(name, type, required, nullable, hidden, description, renderingInfo);
        try {
            Class<?> typeClass = Class.forName(type);
            if (typeClass.isArray()) {
                throw new IllegalArgumentException(LOG.getMsgString("FixedValuesParameterDefinition.no-array-types-allowed", new Object[0]));
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException(LOG.getMsgString("FixedValuesParameterDefinition.invalid-param-type", new Object[]{type, cnfe}));
        }
        this.setAllowedValues(allowed);
    }

    public List<Object> getAllowedValues() {
        return new ArrayList<Object>(this.m_allowedValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAllowedValues(List<Object> newAllowedValues) throws IllegalArgumentException {
        if (!(newAllowedValues != null && newAllowedValues.size() != 0 || this.allowZeroFixedValues())) {
            throw new IllegalArgumentException(LOG.getMsgString("FixedValuesParameterDefinition.need-at-least-one", new Object[]{this.getName()}));
        }
        this.m_allowedValues = null;
        ArrayList convertedAllowedValues = null;
        try {
            try {
                convertedAllowedValues = this.convertAllowedValues(newAllowedValues);
            }
            catch (InvalidParameterValueException ipve) {
                throw new IllegalArgumentException(LOG.getMsgString("FixedValuesParameterDefinition.allowed-value-invalid-type", new Object[]{this.getType(), ipve}));
            }
            this.m_allowedValues = convertedAllowedValues != null ? convertedAllowedValues : new ArrayList();
        }
        catch (Throwable throwable) {
            this.m_allowedValues = convertedAllowedValues != null ? convertedAllowedValues : new ArrayList();
            throw throwable;
        }
    }

    @Override
    public boolean isValidValue(Object valueToCheck) {
        boolean retValid = super.isValidValue(valueToCheck);
        if (retValid && valueToCheck != null && this.m_allowedValues != null) {
            retValid = this.m_allowedValues.contains(valueToCheck);
        }
        return retValid;
    }

    @Override
    public Object convertObject(Object objectToConvert) throws InvalidParameterValueException {
        Object convertedObject = super.convertObject(objectToConvert);
        if (!this.isValidValue(convertedObject)) {
            throw new InvalidParameterValueException(LOG.getMsgString("FixedValuesParameterDefinition.invalid-value", new Object[]{this.getName(), this.m_allowedValues}));
        }
        return convertedObject;
    }

    @Override
    public String toString() {
        StringBuffer strBuf = new StringBuffer(super.toString());
        strBuf.append("; allowed-values=[");
        strBuf.append(this.m_allowedValues);
        strBuf.append("]");
        return strBuf.toString();
    }

    @Override
    protected ParameterRenderingInformation getDefaultRenderingInfo() {
        OptionListRenderingInformation renderingInfo = new OptionListRenderingInformation();
        this.setDefaultRenderingAttributes(renderingInfo);
        return renderingInfo;
    }

    protected boolean allowZeroFixedValues() {
        return false;
    }

    private List<Object> convertAllowedValues(List<Object> allowed) throws InvalidParameterValueException {
        ArrayList<Object> convertedAllowed = new ArrayList<Object>();
        if (allowed != null) {
            for (Object element : allowed) {
                convertedAllowed.add(super.convertObject(element));
            }
        }
        return convertedAllowed;
    }
}

