/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.interfaces;

import org.jboss.ha.framework.interfaces.FamilyClusterInfo;
import org.jboss.ha.framework.interfaces.HARMIClient;
import org.jboss.ha.framework.interfaces.LoadBalancePolicy;
import org.jboss.invocation.Invocation;
import org.jboss.logging.Logger;

public class TransactionSticky
implements LoadBalancePolicy {
    private static final long serialVersionUID = -8750524198817324850L;
    private static final Logger log = Logger.getLogger(TransactionSticky.class);
    private transient boolean trace;
    private final LoadBalancePolicy delegateLoadBalancePolicy;

    public TransactionSticky(LoadBalancePolicy delegate) {
        this.delegateLoadBalancePolicy = delegate;
        if (this.trace) {
            log.trace("transaction sticky load balance policy delegates to: " + this.delegateLoadBalancePolicy);
        }
    }

    public Object chooseTarget(FamilyClusterInfo clusterFamily, Invocation routingDecision) {
        this.trace = log.isTraceEnabled();
        Object txStickyTarget = routingDecision.getTransientValue("TX_STICKY_TARGET");
        if (txStickyTarget != null && clusterFamily.getTargets().contains(txStickyTarget)) {
            if (this.trace) {
                log.trace("transaction bound target exists: " + txStickyTarget);
            }
            return txStickyTarget;
        }
        return this.chooseNewTarget(clusterFamily, routingDecision);
    }

    public void init(HARMIClient father) {
        this.delegateLoadBalancePolicy.init(father);
    }

    public Object chooseTarget(FamilyClusterInfo clusterFamily) {
        return this.delegateLoadBalancePolicy.chooseTarget(clusterFamily);
    }

    protected Object chooseNewTarget(FamilyClusterInfo familyClusterInfo, Invocation invocation) {
        Object newTarget = this.delegateLoadBalancePolicy.chooseTarget(familyClusterInfo, invocation);
        if (this.trace) {
            log.trace("new target chosen: " + newTarget);
        }
        invocation.getTransientPayload().put("TX_STICKY_TARGET", newTarget);
        return newTarget;
    }
}

