/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection.lang.reflect;

import java.lang.reflect.Field;
import org.jboss.injection.lang.reflect.AbstractAccessibleObjectBeanProperty;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldBeanProperty
extends AbstractAccessibleObjectBeanProperty<Field> {
    private static final Logger log = Logger.getLogger(FieldBeanProperty.class);

    public FieldBeanProperty(Field field) {
        super(field);
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.getField().getDeclaringClass();
    }

    protected Field getField() {
        return (Field)this.getAccessibleObject();
    }

    @Override
    public String getName() {
        return this.getField().getName();
    }

    @Override
    public Class<?> getType() {
        return this.getField().getType();
    }

    @Override
    public void set(Object instance, Object value) {
        Field field = this.getField();
        try {
            field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            log.fatal("illegal access on field " + field, e);
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            String msg = "failed to set value " + value + " on field " + field;
            log.error(msg, e);
            throw new IllegalArgumentException(msg);
        }
    }
}

