/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.helpers.rtfilter.util;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServletUtility {
    private static final Log LOG = LogFactory.getLog((Class)ServletUtility.class);
    private static final String EAR_CONTENTS = ".ear-contents";
    private static final String SEPARATOR = System.getProperty("file.separator");

    private ServletUtility() {
    }

    public static String getContextRoot(ServletContext servletContext) {
        String ctxName;
        int major = servletContext.getMajorVersion();
        int minor = servletContext.getMinorVersion();
        if (major == 2 && minor >= 5 || major >= 3) {
            ctxName = ServletUtility.getContextRootFromSpec25(servletContext);
        } else {
            ctxName = ServletUtility.getContextRootFromJbossWebXml(servletContext);
            if (ctxName == null) {
                ctxName = ServletUtility.getContextRootFromApplicationXml(servletContext);
            }
            if (ctxName == null) {
                ctxName = ServletUtility.getContextRootFromWarFileName(servletContext);
            }
            if (ctxName == null || "".equals(ctxName)) {
                ctxName = "__unknown";
            }
        }
        if (ctxName.startsWith(SEPARATOR) || ctxName.startsWith("/")) {
            ctxName = ctxName.substring(1);
        }
        return ctxName;
    }

    private static String getContextRootFromWarFileName(ServletContext servletContext) {
        String ctxName = servletContext.getRealPath("/");
        if (null == ctxName) {
            return null;
        }
        if (ctxName.endsWith(SEPARATOR)) {
            ctxName = ctxName.substring(0, ctxName.length() - 1);
        }
        if ((ctxName = ctxName.substring(ctxName.lastIndexOf(SEPARATOR), ctxName.length() - (ctxName.endsWith(".war") ? 4 : 0))).endsWith("-exp")) {
            ctxName = ctxName.substring(0, ctxName.length() - 4);
        }
        return ctxName;
    }

    private static String getContextRootFromApplicationXml(ServletContext servletContext) {
        String ctxRoot = null;
        String path = servletContext.getRealPath("/");
        if (null == path || !path.toLowerCase().contains(EAR_CONTENTS)) {
            return null;
        }
        path = path.substring(0, path.lastIndexOf(EAR_CONTENTS) + EAR_CONTENTS.length());
        File file = new File(path = path + SEPARATOR + "META-INF" + SEPARATOR + "application.xml");
        if (file == null || !file.canRead()) {
            LOG.debug((Object)(path + " is not readable"));
            return null;
        }
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = db.parse(file);
            Element root = doc.getDocumentElement();
            NodeList modules = root.getChildNodes();
            for (int i = 0; i < modules.getLength(); ++i) {
                Node module = modules.item(i);
                NodeList moduleChildren = module.getChildNodes();
                block3: for (int j = 0; j < moduleChildren.getLength(); ++j) {
                    Node child = moduleChildren.item(j);
                    if (!(child instanceof Element) || !child.getNodeName().equals("web")) continue;
                    NodeList webChildren = child.getChildNodes();
                    for (int k = 0; k < webChildren.getLength(); ++k) {
                        Node textNode;
                        Node webChild = webChildren.item(k);
                        if (!webChild.getNodeName().equals("context-root") || (textNode = webChild.getFirstChild()) == null) continue;
                        ctxRoot = textNode.getNodeValue();
                        continue block3;
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.debug((Object)e);
            ctxRoot = null;
        }
        LOG.debug((Object)("CtxRoot from application.xml: " + ctxRoot));
        return ctxRoot;
    }

    private static String getContextRootFromJbossWebXml(ServletContext servletContext) {
        String ctxName;
        block4: {
            ctxName = null;
            try {
                String path = SEPARATOR + "WEB-INF" + SEPARATOR + "jboss-web.xml";
                InputStream jbossWeb = servletContext.getResourceAsStream(path);
                if (jbossWeb == null) break block4;
                DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = db.parse(jbossWeb);
                Element root = doc.getDocumentElement();
                NodeList children = root.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    String name;
                    Node node = children.item(i);
                    if (!(node instanceof Element) || !(name = node.getNodeName()).equals("context-root")) continue;
                    Node textNode = node.getFirstChild();
                    if (textNode != null) {
                        ctxName = textNode.getNodeValue();
                        LOG.debug((Object)("CtxName from jboss-web.xml: " + ctxName));
                    }
                    break;
                }
            }
            catch (Exception e) {
                LOG.debug((Object)("Can not get contextRoot from jboss-web.xml: " + e));
            }
        }
        return ctxName;
    }

    private static String getContextRootFromSpec25(ServletContext servletContext) {
        String ret = null;
        try {
            Method meth = ServletContext.class.getMethod("getContextPath", null);
            Object o = meth.invoke((Object)servletContext, (Object[])null);
            ret = (String)o;
            if ("".equals(ret)) {
                ret = "ROOT";
            }
            LOG.debug((Object)("ctxPath from servlet spec 2.5: " + ret));
        }
        catch (Exception e) {
            LOG.warn((Object)("Container says it is at least servlet 2.5, but getting the contextPath failed: " + e.getMessage()));
        }
        return ret;
    }
}

