/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas.util;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.mc4j.ems.connection.bean.operation.EmsOperation;
import org.rhq.plugins.jbossas.util.WarDeploymentInformation;
import org.rhq.plugins.jbossas.util.WarDiscoveryHelper;
import org.rhq.plugins.jmx.ObjectNameQueryUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentUtility {
    private static Log log = LogFactory.getLog(DeploymentUtility.class);
    protected static final String MAIN_DEPLOYER = "jboss.system:service=MainDeployer";
    private static final String LIST_DEPLOYED_MODULES_OP_NAME = "listDeployedModules";
    private static final String LIST_DEPLOYED_OP_NAME = "listDeployed";
    private static final String JBOSS_WEB_MBEAN_NAME_TEMPLATE = "jboss.web:J2EEApplication=none,J2EEServer=none,j2eeType=WebModule,name=%s";

    protected static EmsOperation getListDeployedOperation(EmsConnection connection) {
        EmsBean bean = connection.getBean(MAIN_DEPLOYER);
        EmsOperation retOperation = bean.getOperation(LIST_DEPLOYED_MODULES_OP_NAME);
        if (retOperation == null) {
            retOperation = bean.getOperation(LIST_DEPLOYED_OP_NAME);
        }
        return retOperation;
    }

    public static File getDescriptorFile(EmsConnection connection, String objectName) {
        Collection deployed;
        File retDescriptorFile = null;
        try {
            deployed = DeploymentUtility.getDeploymentInformations(connection);
        }
        catch (Exception e) {
            return null;
        }
        Object ourObjectName = connection.buildObjectName(objectName);
        String testScriptObjectNameVariable = "ourObjectName";
        String testScriptContainsOurObjectName = "sdi.mbeans.contains(" + testScriptObjectNameVariable + ")";
        Interpreter i = new Interpreter();
        Iterator it = deployed.iterator();
        while (it.hasNext() && retDescriptorFile == null) {
            Object sdi = it.next();
            try {
                i.set("sdi", sdi);
                String file = i.eval("sdi.watch").toString();
                if (file.startsWith("file:/")) {
                    file = file.substring(5);
                }
                i.set(testScriptObjectNameVariable, ourObjectName);
                Boolean b = (Boolean)i.eval(testScriptContainsOurObjectName);
                if (!b.booleanValue()) continue;
                retDescriptorFile = new File(file);
                break;
            }
            catch (EvalError evalError) {
                log.warn((Object)"Failed to determine if a deployment contains our mbean", (Throwable)evalError);
            }
        }
        log.debug((Object)("Descriptor file for [" + objectName + "] is [" + retDescriptorFile + " ]."));
        return retDescriptorFile;
    }

    public static Map<String, List<WarDeploymentInformation>> getWarDeploymentInformation(EmsConnection connection, List<String> jbossManMBeanNames) {
        Collection deploymentInfos;
        HashMap<String, List<WarDeploymentInformation>> retDeploymentInformationMap = new HashMap<String, List<WarDeploymentInformation>>();
        try {
            deploymentInfos = DeploymentUtility.getDeploymentInformations(connection);
        }
        catch (Exception e) {
            return null;
        }
        String separator = System.getProperty("file.separator");
        boolean isOnWin = separator.equals("\\");
        for (Object deploymentInfo : deploymentInfos) {
            try {
                ObjectName jbossWebObjectName = DeploymentUtility.getFieldValue(deploymentInfo, "deployedObject", ObjectName.class);
                if (jbossWebObjectName == null) continue;
                String shortName = DeploymentUtility.getFieldValue(deploymentInfo, "shortName", String.class);
                for (String jbossManMBeanName : jbossManMBeanNames) {
                    ObjectName jbossManObjectName = new ObjectName(jbossManMBeanName);
                    String jbossManWarName = jbossManObjectName.getKeyProperty("name");
                    if (!shortName.equals(jbossManWarName)) continue;
                    log.debug((Object)("Found DeploymentInfo for WAR " + shortName + "."));
                    List servletObjectNames = DeploymentUtility.getFieldValue(deploymentInfo, "mbeans", List.class);
                    HashSet<String> webModuleNames = new HashSet<String>();
                    for (Object servletObjectName : servletObjectNames) {
                        Class<?> objectNameClass = servletObjectName.getClass();
                        Method getKeyPropertyMethod = objectNameClass.getMethod("getKeyProperty", String.class);
                        String webModuleName = (String)getKeyPropertyMethod.invoke(servletObjectName, "WebModule");
                        webModuleNames.add(webModuleName);
                    }
                    log.debug((Object)("Found " + webModuleNames.size() + " Web modules for WAR " + shortName + ": " + webModuleNames));
                    String path = DeploymentUtility.getPath(isOnWin, deploymentInfo);
                    ArrayList<WarDeploymentInformation> infos = new ArrayList<WarDeploymentInformation>();
                    for (String webModuleName : webModuleNames) {
                        WebModule webModule = DeploymentUtility.parseWebModuleName(webModuleName);
                        WarDeploymentInformation deploymentInformation = new WarDeploymentInformation();
                        deploymentInformation.setVHost(webModule.vhost);
                        deploymentInformation.setFileName(path);
                        deploymentInformation.setContextRoot(webModule.contextRoot);
                        String jbossWebMBeanName = String.format(JBOSS_WEB_MBEAN_NAME_TEMPLATE, webModuleName);
                        jbossWebObjectName = ObjectName.getInstance(jbossWebMBeanName);
                        jbossWebMBeanName = jbossWebObjectName.getCanonicalName();
                        deploymentInformation.setJbossWebModuleMBeanObjectName(jbossWebMBeanName);
                        infos.add(deploymentInformation);
                    }
                    retDeploymentInformationMap.put(jbossManMBeanName, infos);
                }
            }
            catch (Exception evalError) {
                log.warn((Object)"Failed to determine if a deployment contains our MBean", (Throwable)evalError);
            }
        }
        return retDeploymentInformationMap;
    }

    private static String getPath(boolean onWin, Object deploymentInfo) throws IOException {
        String path;
        String url = DeploymentUtility.getFieldValue(deploymentInfo, "url", URL.class).toString();
        if (url.startsWith("file:/")) {
            if (onWin) {
                path = url.substring(6);
                File file = new File(path);
                path = file.getCanonicalPath();
            } else {
                path = url.substring(5);
            }
        } else {
            path = url;
        }
        return path;
    }

    private static WebModule parseWebModuleName(String name) {
        WebModule webModule = new WebModule();
        if (name.startsWith("//")) {
            int firstSlashIndex = (name = name.substring(2)).indexOf("/");
            if (firstSlashIndex > -1) {
                webModule.vhost = name.substring(0, firstSlashIndex);
                webModule.contextRoot = name.substring(firstSlashIndex);
            }
            if (webModule.contextRoot.length() > 1) {
                webModule.contextRoot = webModule.contextRoot.substring(1);
            }
        } else {
            int lastSlashIndex = name.lastIndexOf("/");
            if (lastSlashIndex > 0) {
                int lastIndex = name.length() - 1;
                name = lastSlashIndex == lastIndex ? "/" : name.substring(lastSlashIndex + 1);
            }
        }
        return webModule;
    }

    public static Map<String, String> getEarDeploymentPath(EmsConnection connection, List<String> fileNames) {
        Collection deploymentInfos = null;
        String separator = System.getProperty("file.separator");
        boolean isOnWin = separator.equals("\\");
        HashMap<String, String> results = new HashMap<String, String>(fileNames.size());
        try {
            deploymentInfos = DeploymentUtility.getDeploymentInformations(connection);
            for (Object sdi : deploymentInfos) {
                String file = DeploymentUtility.getFieldValue(sdi, "url", URL.class).toString();
                for (String earName : fileNames) {
                    if (!file.endsWith(earName)) continue;
                    if (file.startsWith("file:/")) {
                        if (isOnWin) {
                            file = file.substring(6);
                            File tmp = new File(file);
                            file = tmp.getCanonicalPath();
                        } else {
                            file = file.substring(5);
                        }
                    }
                    results.put(earName, file);
                }
            }
        }
        catch (Exception e) {
            return new HashMap<String, String>();
        }
        return results;
    }

    public static boolean isDuplicateJndiName(EmsConnection connection, String mbeanType, String jndiName) {
        if (jndiName != null && mbeanType != null) {
            String name = mbeanType + ",name=" + jndiName;
            EmsBean bean = connection.getBean(name);
            if (bean == null) {
                return false;
            }
            return bean.isRegistered();
        }
        return false;
    }

    public static String getJndiNameBinding(EmsBean bean) {
        String jndiNameBinding = "";
        if (bean != null) {
            EmsAttribute attribute = bean.getAttribute("JNDIName");
            attribute.refresh();
            jndiNameBinding = String.valueOf(attribute.getValue());
        }
        return jndiNameBinding;
    }

    private static Collection getDeploymentInformations(EmsConnection connection) throws Exception {
        Collection deploymentInfos;
        block6: {
            deploymentInfos = null;
            EmsOperation operation = null;
            try {
                operation = DeploymentUtility.getListDeployedOperation(connection);
                if (operation == null) {
                    throw new UnsupportedOperationException("This JBossAS instance is unsupported; its MainDeployer MBean doesn't have a listDeployedModules or listDeployed operation.");
                }
                deploymentInfos = (Collection)operation.invoke(new Object[0]);
            }
            catch (RuntimeException re) {
                if (operation != null && operation.getName().equals(LIST_DEPLOYED_MODULES_OP_NAME)) {
                    EmsBean mainDeployerMBean = connection.getBean(MAIN_DEPLOYER);
                    operation = mainDeployerMBean.getOperation(LIST_DEPLOYED_OP_NAME);
                    try {
                        deploymentInfos = (Collection)operation.invoke(new Object[0]);
                    }
                    catch (RuntimeException re2) {
                        deploymentInfos = null;
                    }
                }
                if (deploymentInfos != null) break block6;
                log.warn((Object)("Cannot determine deployed modules - cause: " + re));
                throw new Exception(re);
            }
        }
        return deploymentInfos;
    }

    private static <T> T getFieldValue(Object target, String name, Class<T> T) {
        Object ret;
        if (target == null) {
            return null;
        }
        try {
            Field field = target.getClass().getField(name);
            ret = field.get(target);
            if (T == ObjectName.class && ret != null) {
                ret = new ObjectName(ret.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return (T)ret;
    }

    public static List<EmsBean> getVHostsFromLocalManager(String contextRoot, EmsConnection emsConnection) {
        String contextPath = WarDiscoveryHelper.getContextPath(contextRoot);
        String pattern = "jboss.web:host=%host%,path=" + contextPath + ",type=Manager";
        ObjectNameQueryUtility queryUtil = new ObjectNameQueryUtility(pattern);
        List managerMBeans = emsConnection.queryBeans(queryUtil.getTranslatedQuery());
        return managerMBeans;
    }

    public static List<EmsBean> getVHostsFromClusterManager(String contextRoot, EmsConnection emsConnection) {
        String contextPath = WarDiscoveryHelper.getContextPath(contextRoot);
        String pattern = "jboss.web:service=ClusterManager,WebModule=%webModule%";
        ObjectNameQueryUtility queryUtil = new ObjectNameQueryUtility(pattern);
        List clusterManagerMBeans = emsConnection.queryBeans(queryUtil.getTranslatedQuery());
        return clusterManagerMBeans;
    }

    static class WebModule {
        String vhost;
        String contextRoot;

        WebModule() {
        }
    }
}

