/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas.util;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.on.common.jbossas.AbstractJBossASContentFacetDelegate;
import org.jboss.on.common.jbossas.JBPMWorkflowManager;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.plugins.jbossas.util.FileContentDelegate;
import org.rhq.plugins.jbossas.util.JarContentDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossASContentFacetDelegate
extends AbstractJBossASContentFacetDelegate {
    private Map<PackageType, FileContentDelegate> contentDelegates = new HashMap<PackageType, FileContentDelegate>();
    private File configurationPath;

    public JBossASContentFacetDelegate(JBPMWorkflowManager workflowManager, File configurationPath) {
        super(workflowManager);
        this.configurationPath = configurationPath;
    }

    public Set<ResourcePackageDetails> discoverDeployedPackages(PackageType type) {
        FileContentDelegate contentDelegate = this.getContentDelegate(type);
        Set<ResourcePackageDetails> details = null;
        if (contentDelegate != null) {
            details = contentDelegate.discoverDeployedPackages();
        }
        return details;
    }

    private FileContentDelegate getContentDelegate(PackageType type) {
        FileContentDelegate contentDelegate = this.contentDelegates.get(type);
        if (contentDelegate == null) {
            if (type.getName().equals("library")) {
                File deployLib = new File(this.configurationPath, "lib");
                contentDelegate = new JarContentDelegate(deployLib, type.getName());
            }
            this.contentDelegates.put(type, contentDelegate);
        }
        return contentDelegate;
    }
}

