/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas.util;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;
import org.mc4j.ems.connection.bean.EmsBean;
import org.rhq.core.pluginapi.inventory.ResourceContext;

public class JBossMBeanUtility {
    private static final Log LOG = LogFactory.getLog(JBossMBeanUtility.class);

    private JBossMBeanUtility() {
    }

    public static MBeanServer getJBossMBeanServer() {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        MBeanServer jbossServer = null;
        for (MBeanServer server : servers) {
            if (!"jboss".equals(server.getDefaultDomain())) continue;
            jbossServer = server;
        }
        if (jbossServer == null) {
            jbossServer = ManagementFactory.getPlatformMBeanServer();
        }
        return jbossServer;
    }

    public static boolean isStarted(EmsBean emsBean, @Nullable ResourceContext resourceContext) {
        try {
            return "Started".equals(emsBean.getAttribute("StateString").refresh());
        }
        catch (NullPointerException npe) {
            if (resourceContext != null) {
                LOG.warn((Object)("Could not determine availability of unknown EMS bean for [" + resourceContext.getResourceType() + ":" + resourceContext.getResourceKey() + "]"));
            }
            return false;
        }
    }
}

